#ifndef CPPCADESSYMMETRICALGORITHM_H_
#define CPPCADESSYMMETRICALGORITHM_H_
#include "cppcades.h"
#include "CPPCadesCPCertificate.h"

#ifdef _WIN32
typedef unsigned int uint32_t;
#endif //_WIN32

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesSymmetricAlgorithmObject {
  public:
    CPPCadesSymmetricAlgorithmObject();
    CPPCadesSymmetricAlgorithmObject(CBlob &DiversData, CCryptProv &hProv,
                                     HCRYPTKEY hKey, ALG_ID algId);
    ~CPPCadesSymmetricAlgorithmObject();

#ifndef UNIX
    HRESULT put_IV(const BSTR pVal);
    HRESULT get_IV(CComBSTR &pVal);
    HRESULT get_DiversData(CComBSTR &pVal);
    HRESULT put_DiversData(const BSTR pVal);
#endif // UNIX

    HRESULT put_IV(const char *pbData, DWORD cbData);
    HRESULT get_IV(CBlob &pVal);
    HRESULT get_DiversData(CBlob &pVal);
    HRESULT put_DiversData(const char *pbData, DWORD cbData);
    HRESULT put_LegacyPluginSymmetricExport(bool bLegacyPluginSymmetricExport);

    HRESULT GenerateKey(CADESCOM_ENCRYPTION_ALGORITHM algorithm);
    HRESULT
    DiversifyKey(NS_SHARED_PTR::shared_ptr<CPPCadesSymmetricAlgorithmObject> &retval);
    HRESULT Encrypt(const char *pbData, unsigned long cbData, BOOL isFinal,
                    CStringProxy &retval);
    HRESULT Decrypt(const char *pbData, unsigned long cbData, BOOL isFinal,
                    CBlob &retval);
    HRESULT ImportKey(const char *pbData, uint32_t cbData,
                      NS_SHARED_PTR::shared_ptr<CPPCadesCPCertificateObject> &pCert,
                      const char *pbPin, uint32_t cbPin);
    HRESULT ExportKey(NS_SHARED_PTR::shared_ptr<CPPCadesCPCertificateObject> &pCert,
                      CBlob &retval);
    HRESULT SetMode(DWORD mode);
    HRESULT SetPadding(DWORD padding);

  private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesSymmetricAlgorithmObject);
    //   CadesSymmetricAlgorithm    
    void ResetState();
    static const int m_DiversData_len = 40; // MAX DIVERS DATA
    int m_IV_len;
    BOOL m_first_block;
    CBlob m_DiversData;
    CBlob m_IV;
    CCryptProv m_hProv;
    CCryptKey m_enc_hKey;
    long m_LegacyPluginSymmetricExport;
    bool m_RegistryLegacyPluginSymmetricExport;
    ALG_ID m_alg_id;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADESSYMMETRICALGORITHM_H_
