#ifndef CPPCADESCPOID_H_
#define CPPCADESCPOID_H_
#include "cppcades.h"
#include <atlcrypt2.h>

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPOIDObject
{
public:
    CPPCadesCPOIDObject(void);
    ~CPPCadesCPOIDObject(void);
    HRESULT get_Value(NS_SHARED_PTR::shared_ptr<ATL::CAtlStringA>& pVal);
    HRESULT put_Value(CAtlStringA pVal);
    HRESULT get_FriendlyName(ATL::CAtlString& pVal);
    HRESULT put_FriendlyName(CAtlString pVal);
    HRESULT get_Name(CAPICOM_OID* pVal);
    HRESULT put_Name(CAPICOM_OID pVal);

    // internal use
    void set_readonly();
private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPOIDObject);
#ifndef UNIX
#pragma warning(push)
#pragma warning(disable: 4251)
#endif
    // shared_ptr    ,   
    //   const char * pszObjId  CRYPT_ATTRIBUTE.
    //         - ,
    //     .
    NS_SHARED_PTR::shared_ptr<ATL::CAtlStringA> m_oid;
    bool m_readonly;
#ifndef UNIX
#pragma warning(pop)
#endif
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif //CPPCADESCPOID_H_
