#ifndef CPPCADES_CP_ENVELOPEDDATA_OBJECT_H_
#define CPPCADES_CP_ENVELOPEDDATA_OBJECT_H_

#include "cppcades.h"
#include "CPPCadesCPAlgorithm.h"
#include "CPPCadesCPCertificate.h"
#include "CPPCadesCollections.h"
#include "CPPCadesContent.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPEnvelopedDataObject
{
public:
    CPPCadesCPEnvelopedDataObject(void);
    ~CPPCadesCPEnvelopedDataObject(void);

#ifndef UNIX
    HRESULT put_Content(const BSTR pVal);
    HRESULT get_Content(CComBSTR& pVal);
#endif // UNIX

    HRESULT put_Content(LPCSTR pbData, DWORD cbData);
    HRESULT get_Content(CStringBlob& pVal);

    HRESULT put_ContentEncoding(CADESCOM_CONTENT_ENCODING_TYPE EncodingType);
    HRESULT get_ContentEncoding(CADESCOM_CONTENT_ENCODING_TYPE* pVal);

    HRESULT get_Algorithm(NS_SHARED_PTR::shared_ptr<CPPCadesCPAlgorithmObject>& pVal);
    HRESULT get_Recipients(NS_SHARED_PTR::shared_ptr<CPPCadesCPRecipientsObject>& pVal);
    HRESULT Encrypt(CAPICOM_ENCODING_TYPE EncodingType, CBlob& pVal);
    HRESULT Decrypt(const CBlob& EncryptedMessage);
    HRESULT StreamEncrypt(const char *pbData, unsigned long cbData, BOOL isFinal, CBlob &retval);
    HRESULT StreamDecrypt(const char *pbData, unsigned long cbData, BOOL isFinal, CBlob &retval);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPEnvelopedDataObject);
    //   EnvelopedData    
    void ResetState();
    //   StreamDecrypt  
    void ResetStreamDecrypt();
    //internal use
    HRESULT PrepareStreamDecrypt();

    NS_SHARED_PTR::shared_ptr<CPPCadesCPRecipientsObject> m_pRecipients;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPAlgorithmObject> m_pAlg;
    CCadesContent m_content;
    CCryptProv m_Prov;
    HCRYPTMSG m_hMsg; 
    std::vector<BYTE> m_result_buf;
    std::vector<BYTE> m_remained_buf;
    BOOL m_bDecrypt_started;
    ATL2::CCertStore m_store;
    const CERT_CONTEXT *m_recipientCertContext;
    BOOL m_releaseProv;
    DWORD m_recipientKeySpec;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_ENVELOPEDDATA_OBJECT_H_

