#pragma warning(disable:4996)

#include <iterator>
#include <vector>
#include <iostream>
#include <wchar.h>
#include <cstdlib>

#ifdef _WIN32
#include <tchar.h>
#else
#include <cstdio>
#include "reader/tchar.h"
#endif

#include "xades.h"

/*
     XADES_BES       SDK
   ,   . 
    sign.xml.       
    .
*/

using namespace std;

#include "../samples_util.h"

static const CHAR* XML_DATA =
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>"\
"<Envelope xmlns=\"urn:envelope\">"\
"<Data>"\
"Hello, World!"\
"</Data>"\
"<Node xml:id=\"nodeID\">"\
"Hello, Node!"\
"</Node>"\
"</Envelope>";

int main(int argc, char *argv[]) {
    //    
    HCERTSTORE hStoreHandle = CertOpenSystemStore(0, _TEXT("MY"));

    if (!hStoreHandle) {
        cout << "Store handle was not got" << endl;
        return -1;
    }

    wchar_t *wa = NULL;
    if (argc > 1) {
        size_t len = strlen(argv[1]) + 1;
        wa = new wchar_t[len];
        mbstowcs(wa, argv[1], len);
    }

    //    
    PCCERT_CONTEXT context = GetRecipientCert(hStoreHandle, wa);
    if (wa) delete[] wa;

    //    ,  
    if (!context) {
        cout << "There is no certificate with a CERT_KEY_CONTEXT_PROP_ID " << endl
            << "property and an AT_KEYEXCHANGE private key available." << endl
            << "While the message could be sign, in this case, it could" << endl
            << "not be verify in this program." << endl
            << "For more information, read the documentation http://cpdn.cryptopro.ru/" << endl;
        return -1;
    }

    //  
    XADES_SIGN_PARA xadesSignPara = { sizeof(xadesSignPara) };
    xadesSignPara.dwSignatureType = XML_XADES_SIGNATURE_TYPE_ENVELOPED | XADES_BES; //     (ENVELOPED)  XADES_BES
    xadesSignPara.pSignerCert = context;

    XADES_SIGN_MESSAGE_PARA para = { sizeof(para) };
    para.pXadesSignPara = &xadesSignPara;

    //    
    DWORD cbToBeSigned = (DWORD)strlen(XML_DATA);
    BYTE *pbToBeSigned = (BYTE*)XML_DATA;

    PCRYPT_DATA_BLOB pSignedMessage = 0;
    //   
    if (!XadesSign(&para, NULL, FALSE, pbToBeSigned, cbToBeSigned, &pSignedMessage)) {
        cout << "XadesSign() failed" << endl;
        return -1;
    }

    vector<unsigned char> message(pSignedMessage->cbData);
    copy(pSignedMessage->pbData, pSignedMessage->pbData + pSignedMessage->cbData, message.begin());

    //     sign.xml
    if (SaveVectorToFile<unsigned char>("sign.xml", message)) {
        cout << "Signed XML was not saved" << endl;
        return -1;
    }

    cout << "Signed XML was saved successfully" << endl;

    //      
    if (!XadesFreeBlob(pSignedMessage)) {
        cout << "XadesFreeBlob() failed" << endl;
        return -1;
    }

    //  
    if (!CertCloseStore(hStoreHandle, 0)) {
        cout << "Certificate store handle was not closed." << endl;
        return -1;
    }

    //   
    if (context)
        CertFreeCertificateContext(context);

    message.clear();
    //    
    if (ReadFileToVector("sign.xml", message))
    {
        cout << "Reading Signed XML from file \"sign.xml\" failed" << endl;
        return -1;
    }

    if (message.empty())
    {
        cout << "File \"sign.xml\" is empty. Nothing to verify." << endl;
        return -1;
    }

    //   
    XADES_VERIFICATION_PARA xadesVerifyPara = { sizeof(xadesVerifyPara) };
    xadesVerifyPara.dwSignatureType = XADES_BES; //     XADES_BES

    XADES_VERIFY_MESSAGE_PARA verifyPara = { sizeof(verifyPara) };
    verifyPara.pXadesVerifyPara = &xadesVerifyPara;

    PXADES_VERIFICATION_INFO_ARRAY pVerifyInfo = 0;

    //  
    if (!XadesVerify(&verifyPara, NULL, &message[0], (unsigned long)message.size(), &pVerifyInfo))
    {
        XadesFreeVerificationInfoArray(pVerifyInfo);
        cout << "XadesVerify() failed" << endl;
        return -1;
    }

    //   
    for (unsigned int i = 0; i < pVerifyInfo->cbCount; ++i) {
        if (pVerifyInfo->pXadesVerificationInfo[i].dwStatus != XADES_VERIFY_SUCCESS)
            cout << "XML signature #" << i << " is not verified successfully." << endl;
        else
            cout << "XML signature #" << i << " verified successfully." << endl;
    }

    //  
    if (!XadesFreeVerificationInfoArray(pVerifyInfo))
    {
        cout << "XadesFreeVerificationInfoArray() failed" << endl;
        return -1;
    }

    return 0;
}
