#ifndef CPPCADES_H_
#define CPPCADES_H_
// A macro to disallow the copy constructor and operator= functions
// // This should be used in the private: declarations for a class
#define DISALLOW_COPY_AND_ASSIGN(TypeName) \
    TypeName(const TypeName&);               \
    void operator=(const TypeName&)

#ifdef _WIN32
#define CPPCADESCATCH \
    catch ( const ATL::CAtlException& ex ){ return ex.m_hr; } \
    catch( ... ){return ATL::AtlHresultFromLastError();}
#else
#define CPPCADESCATCH \
    catch ( ATL::CAtlException& ex ){ return ex.m_hr; } \
    catch( ... ){return ATL::AtlHresultFromLastError();}
#endif
#ifdef _WIN32
#define CPPCADESTRYCATCH(_expr) try{_expr;} \
    catch ( ATL::CAtlException& ex ){ return ex.m_hr; } \
    catch( ... ){return ATL::AtlHresultFromLastError();}
#else
#define CPPCADESTRYCATCH(_expr) try{_expr;} \
    catch ( ATL::CAtlException& ex ){ return ex.m_hr; } \
    catch( ... ){return ATL::AtlHresultFromLastError();}
#endif

struct SigInfo {
    bool isSigningTimePresent;
    FILETIME signingTime;
    bool isSignatureTimeStampTimePresent;
    FILETIME signatureTimeStampTime;
    bool isValid;
};


#ifdef UNIX
#include <CSP_WinCrypt.h>
//from cades.h
#ifndef _CADES_H_INCLUDED
typedef CRYPT_SEQUENCE_OF_ANY CADES_BLOB_ARRAY, *PCADES_BLOB_ARRAY;
extern "C" BOOL WINAPI CadesFreeBlobArray(
    PCADES_BLOB_ARRAY pBlobArray);
#endif //_CADES_H_INCLUDED
#endif //UNIX

#ifndef _WIN32

typedef enum _CADESCOM_STORE_LOCATION
{   
    CADESCOM_MEMORY_STORE    = 0,
    CADESCOM_LOCAL_MACHINE_STORE = 1,
    CADESCOM_CURRENT_USER_STORE  = 2,
    CADESCOM_ACTIVE_DIRECTORY_USER_STORE = 3,
    CADESCOM_SMART_CARD_USER_STORE   = 4,
    CADESCOM_CONTAINER_STORE = 100
} CADESCOM_STORE_LOCATION;

typedef enum _CADESCOM_PRODUCT
{
    CADESCOM_PRODUCT_CSP = 0,
    CADESCOM_PRODUCT_OCSP = 1,
    CADESCOM_PRODUCT_TSP = 2
} CADESCOM_PRODUCT;

typedef enum _CADESCOM_MEDIA_TYPE
{
    MEDIA_TYPE_DEFAULT = 0x00000000,
    MEDIA_TYPE_REGISTRY = 0x00000001,
    MEDIA_TYPE_HDIMAGE = 0x00000002,
    MEDIA_TYPE_CLOUD = 0x00000004,
    MEDIA_TYPE_SCARD = 0x00000008
} CADESCOM_MEDIA_TYPE;

typedef enum _CAPICOM_STORE_OPEN_MODE
{
    CAPICOM_STORE_OPEN_READ_ONLY    = 0,
    CAPICOM_STORE_OPEN_READ_WRITE   = 1,
    CAPICOM_STORE_OPEN_MAXIMUM_ALLOWED  = 2,
    CAPICOM_STORE_OPEN_EXISTING_ONLY    = 128,
    CAPICOM_STORE_OPEN_INCLUDE_ARCHIVED = 256
} CAPICOM_STORE_OPEN_MODE;

typedef enum _CAPICOM_CERTIFICATE_FIND_TYPE
{
    CAPICOM_CERTIFICATE_FIND_SHA1_HASH  = 0,
    CAPICOM_CERTIFICATE_FIND_SUBJECT_NAME   = 1,
    CAPICOM_CERTIFICATE_FIND_ISSUER_NAME    = 2,
    CAPICOM_CERTIFICATE_FIND_ROOT_NAME  = 3,
    CAPICOM_CERTIFICATE_FIND_TEMPLATE_NAME  = 4,
    CAPICOM_CERTIFICATE_FIND_EXTENSION  = 5,
    CAPICOM_CERTIFICATE_FIND_EXTENDED_PROPERTY  = 6,
    CAPICOM_CERTIFICATE_FIND_APPLICATION_POLICY = 7,
    CAPICOM_CERTIFICATE_FIND_CERTIFICATE_POLICY = 8,
    CAPICOM_CERTIFICATE_FIND_TIME_VALID = 9,
    CAPICOM_CERTIFICATE_FIND_TIME_NOT_YET_VALID = 10,
    CAPICOM_CERTIFICATE_FIND_TIME_EXPIRED   = 11,
    CAPICOM_CERTIFICATE_FIND_KEY_USAGE  = 12
} CAPICOM_CERTIFICATE_FIND_TYPE;

typedef enum _CAPICOM_CERT_INFO_TYPE
{
    CAPICOM_CERT_INFO_SUBJECT_SIMPLE_NAME   = 0,
    CAPICOM_CERT_INFO_ISSUER_SIMPLE_NAME    = 1,
    CAPICOM_CERT_INFO_SUBJECT_EMAIL_NAME    = 2,
    CAPICOM_CERT_INFO_ISSUER_EMAIL_NAME = 3,
    CAPICOM_CERT_INFO_SUBJECT_UPN   = 4,
    CAPICOM_CERT_INFO_ISSUER_UPN    = 5,
    CAPICOM_CERT_INFO_SUBJECT_DNS_NAME  = 6,
    CAPICOM_CERT_INFO_ISSUER_DNS_NAME   = 7,
    CADESCOM_CERT_INFO_ROLE = 100
} CAPICOM_CERT_INFO_TYPE;

typedef enum _CAPICOM_ENCODING_TYPE
{
    CAPICOM_ENCODE_ANY = 0xffffffff,
    CAPICOM_ENCODE_BASE64  = 0,
    CAPICOM_ENCODE_BINARY  = 1 
} CAPICOM_ENCODING_TYPE;

typedef enum _CAPICOM_STORE_SAVE_AS_TYPE {
    CAPICOM_STORE_SAVE_AS_SERIALIZED = 0,
    CAPICOM_STORE_SAVE_AS_PKCS7 = 1
} CAPICOM_STORE_SAVE_AS_TYPE;

typedef enum _CADESCOM_CONTENT_ENCODING_TYPE {
/*  UTF-8  UNICODE */
    CADESCOM_STRING_TO_UCS2LE               = 0x00,
/*  BASE64 */
    CADESCOM_BASE64_TO_BINARY               = 0x01,
/*    */
    CADESCOM_ENCODING_NONE                  = 0x02
} CADESCOM_CONTENT_ENCODING_TYPE;

typedef enum _CAPICOM_CERTIFICATE_INCLUDE_OPTION
{
    CAPICOM_CERTIFICATE_INCLUDE_CHAIN_EXCEPT_ROOT = 0,
    CAPICOM_CERTIFICATE_INCLUDE_WHOLE_CHAIN = 1,
    CAPICOM_CERTIFICATE_INCLUDE_END_ENTITY_ONLY = 2,
    CAPICOM_CERTIFICATE_INCLUDE_NONE = 0x100
} CAPICOM_CERTIFICATE_INCLUDE_OPTION;

typedef enum _CAPICOM_SIGNED_DATA_VERIFY_FLAG
{
    CAPICOM_VERIFY_SIGNATURE_ONLY = 0,
    CAPICOM_VERIFY_SIGNATURE_AND_CERTIFICATE = 1
} CAPICOM_SIGNED_DATA_VERIFY_FLAG;

typedef enum _CAPICOM_OID
{
    CAPICOM_OID_OTHER	= 0,
    CAPICOM_OID_AUTHORITY_KEY_IDENTIFIER_EXTENSION	= 1,
    CAPICOM_OID_KEY_ATTRIBUTES_EXTENSION	= 2,
    CAPICOM_OID_CERT_POLICIES_95_EXTENSION	= 3,
    CAPICOM_OID_KEY_USAGE_RESTRICTION_EXTENSION	= 4,
    CAPICOM_OID_LEGACY_POLICY_MAPPINGS_EXTENSION	= 5,
    CAPICOM_OID_SUBJECT_ALT_NAME_EXTENSION	= 6,
    CAPICOM_OID_ISSUER_ALT_NAME_EXTENSION	= 7,
    CAPICOM_OID_BASIC_CONSTRAINTS_EXTENSION	= 8,
    CAPICOM_OID_SUBJECT_KEY_IDENTIFIER_EXTENSION	= 9,
    CAPICOM_OID_KEY_USAGE_EXTENSION	= 10,
    CAPICOM_OID_PRIVATEKEY_USAGE_PERIOD_EXTENSION	= 11,
    CAPICOM_OID_SUBJECT_ALT_NAME2_EXTENSION	= 12,
    CAPICOM_OID_ISSUER_ALT_NAME2_EXTENSION	= 13,
    CAPICOM_OID_BASIC_CONSTRAINTS2_EXTENSION	= 14,
    CAPICOM_OID_NAME_CONSTRAINTS_EXTENSION	= 15,
    CAPICOM_OID_CRL_DIST_POINTS_EXTENSION	= 16,
    CAPICOM_OID_CERT_POLICIES_EXTENSION	= 17,
    CAPICOM_OID_POLICY_MAPPINGS_EXTENSION	= 18,
    CAPICOM_OID_AUTHORITY_KEY_IDENTIFIER2_EXTENSION	= 19,
    CAPICOM_OID_POLICY_CONSTRAINTS_EXTENSION	= 20,
    CAPICOM_OID_ENHANCED_KEY_USAGE_EXTENSION	= 21,
    CAPICOM_OID_CERTIFICATE_TEMPLATE_EXTENSION	= 22,
    CAPICOM_OID_APPLICATION_CERT_POLICIES_EXTENSION	= 23,
    CAPICOM_OID_APPLICATION_POLICY_MAPPINGS_EXTENSION	= 24,
    CAPICOM_OID_APPLICATION_POLICY_CONSTRAINTS_EXTENSION	= 25,
    CAPICOM_OID_AUTHORITY_INFO_ACCESS_EXTENSION	= 26,
    CAPICOM_OID_SERVER_AUTH_EKU	= 100,
    CAPICOM_OID_CLIENT_AUTH_EKU	= 101,
    CAPICOM_OID_CODE_SIGNING_EKU	= 102,
    CAPICOM_OID_EMAIL_PROTECTION_EKU	= 103,
    CAPICOM_OID_IPSEC_END_SYSTEM_EKU	= 104,
    CAPICOM_OID_IPSEC_TUNNEL_EKU	= 105,
    CAPICOM_OID_IPSEC_USER_EKU	= 106,
    CAPICOM_OID_TIME_STAMPING_EKU	= 107,
    CAPICOM_OID_CTL_USAGE_SIGNING_EKU	= 108,
    CAPICOM_OID_TIME_STAMP_SIGNING_EKU	= 109,
    CAPICOM_OID_SERVER_GATED_CRYPTO_EKU	= 110,
    CAPICOM_OID_ENCRYPTING_FILE_SYSTEM_EKU	= 111,
    CAPICOM_OID_EFS_RECOVERY_EKU	= 112,
    CAPICOM_OID_WHQL_CRYPTO_EKU	= 113,
    CAPICOM_OID_NT5_CRYPTO_EKU	= 114,
    CAPICOM_OID_OEM_WHQL_CRYPTO_EKU	= 115,
    CAPICOM_OID_EMBEDED_NT_CRYPTO_EKU	= 116,
    CAPICOM_OID_ROOT_LIST_SIGNER_EKU	= 117,
    CAPICOM_OID_QUALIFIED_SUBORDINATION_EKU	= 118,
    CAPICOM_OID_KEY_RECOVERY_EKU	= 119,
    CAPICOM_OID_DIGITAL_RIGHTS_EKU	= 120,
    CAPICOM_OID_LICENSES_EKU	= 121,
    CAPICOM_OID_LICENSE_SERVER_EKU	= 122,
    CAPICOM_OID_SMART_CARD_LOGON_EKU	= 123,
    CAPICOM_OID_PKIX_POLICY_QUALIFIER_CPS	= 124,
    CAPICOM_OID_PKIX_POLICY_QUALIFIER_USERNOTICE	= 125
} CAPICOM_OID;

typedef enum _CAPICOM_EKU
{
    CAPICOM_EKU_OTHER = 0,
    CAPICOM_EKU_SERVER_AUTH = 1,
    CAPICOM_EKU_CLIENT_AUTH = 2,
    CAPICOM_EKU_CODE_SIGNING = 3,
    CAPICOM_EKU_EMAIL_PROTECTION = 4,
    CAPICOM_EKU_SMARTCARD_LOGON = 5,
    CAPICOM_EKU_ENCRYPTING_FILE_SYSTEM = 6
} CAPICOM_EKU;

typedef enum _CAPICOM_CHECK_FLAG
{
    CAPICOM_CHECK_NONE	= 0,
    CAPICOM_CHECK_TRUSTED_ROOT	= 1,
    CAPICOM_CHECK_TIME_VALIDITY	= 2,
    CAPICOM_CHECK_SIGNATURE_VALIDITY	= 4,
    CAPICOM_CHECK_ONLINE_REVOCATION_STATUS	= 8,
    CAPICOM_CHECK_OFFLINE_REVOCATION_STATUS	= 16,
    CAPICOM_CHECK_COMPLETE_CHAIN	= 32,
    CAPICOM_CHECK_NAME_CONSTRAINTS	= 64,
    CAPICOM_CHECK_BASIC_CONSTRAINTS	= 128,
    CAPICOM_CHECK_NESTED_VALIDITY_PERIOD	= 256,
    CAPICOM_CHECK_ONLINE_ALL	= 495,
    CAPICOM_CHECK_OFFLINE_ALL	= 503
} CAPICOM_CHECK_FLAG;

typedef enum _CAPICOM_PROPID
{
    CAPICOM_PROPID_UNKNOWN	= 0,
    CAPICOM_PROPID_KEY_PROV_HANDLE	= 1,
    CAPICOM_PROPID_KEY_PROV_INFO	= 2,
    CAPICOM_PROPID_SHA1_HASH	= 3,
    CAPICOM_PROPID_HASH_PROP	= 3,
    CAPICOM_PROPID_MD5_HASH	= 4,
    CAPICOM_PROPID_KEY_CONTEXT	= 5,
    CAPICOM_PROPID_KEY_SPEC	= 6,
    CAPICOM_PROPID_IE30_RESERVED	= 7,
    CAPICOM_PROPID_PUBKEY_HASH_RESERVED	= 8,
    CAPICOM_PROPID_ENHKEY_USAGE	= 9,
    CAPICOM_PROPID_CTL_USAGE	= 9,
    CAPICOM_PROPID_NEXT_UPDATE_LOCATION	= 10,
    CAPICOM_PROPID_FRIENDLY_NAME	= 11,
    CAPICOM_PROPID_PVK_FILE	= 12,
    CAPICOM_PROPID_DESCRIPTION	= 13,
    CAPICOM_PROPID_ACCESS_STATE	= 14,
    CAPICOM_PROPID_SIGNATURE_HASH	= 15,
    CAPICOM_PROPID_SMART_CARD_DATA	= 16,
    CAPICOM_PROPID_EFS	= 17,
    CAPICOM_PROPID_FORTEZZA_DATA	= 18,
    CAPICOM_PROPID_ARCHIVED	= 19,
    CAPICOM_PROPID_KEY_IDENTIFIER	= 20,
    CAPICOM_PROPID_AUTO_ENROLL	= 21,
    CAPICOM_PROPID_PUBKEY_ALG_PARA	= 22,
    CAPICOM_PROPID_CROSS_CERT_DIST_POINTS	= 23,
    CAPICOM_PROPID_ISSUER_PUBLIC_KEY_MD5_HASH	= 24,
    CAPICOM_PROPID_SUBJECT_PUBLIC_KEY_MD5_HASH	= 25,
    CAPICOM_PROPID_ENROLLMENT	= 26,
    CAPICOM_PROPID_DATE_STAMP	= 27,
    CAPICOM_PROPID_ISSUER_SERIAL_NUMBER_MD5_HASH	= 28,
    CAPICOM_PROPID_SUBJECT_NAME_MD5_HASH	= 29,
    CAPICOM_PROPID_EXTENDED_ERROR_INFO	= 30,
    CAPICOM_PROPID_RENEWAL	= 64,
    CAPICOM_PROPID_ARCHIVED_KEY_HASH	= 65,
    CAPICOM_PROPID_FIRST_RESERVED	= 66,
    CAPICOM_PROPID_LAST_RESERVED	= 32767,
    CAPICOM_PROPID_FIRST_USER	= 32768,
    CAPICOM_PROPID_LAST_USER	= 65535
} CAPICOM_PROPID;

typedef enum _CAPICOM_KEY_USAGE
{
    CAPICOM_DIGITAL_SIGNATURE_KEY_USAGE	= 128,
    CAPICOM_NON_REPUDIATION_KEY_USAGE	= 64,
    CAPICOM_KEY_ENCIPHERMENT_KEY_USAGE	= 32,
    CAPICOM_DATA_ENCIPHERMENT_KEY_USAGE	= 16,
    CAPICOM_KEY_AGREEMENT_KEY_USAGE	= 8,
    CAPICOM_KEY_CERT_SIGN_KEY_USAGE	= 4,
    CAPICOM_OFFLINE_CRL_SIGN_KEY_USAGE	= 2,
    CAPICOM_CRL_SIGN_KEY_USAGE	= 2,
    CAPICOM_ENCIPHER_ONLY_KEY_USAGE	= 1,
    CAPICOM_DECIPHER_ONLY_KEY_USAGE	= 32768
} CAPICOM_KEY_USAGE;

typedef enum _CAPICOM_ERROR_CODE
{
    CAPICOM_E_ENCODE_INVALID_TYPE	= 0x80880100,
    CAPICOM_E_EKU_INVALID_OID	= 0x80880200,
    CAPICOM_E_EKU_OID_NOT_INITIALIZED	= 0x80880201,
    CAPICOM_E_CERTIFICATE_NOT_INITIALIZED	= 0x80880210,
    CAPICOM_E_CERTIFICATE_NO_PRIVATE_KEY	= 0x80880211,
    CAPICOM_E_CHAIN_NOT_BUILT	= 0x80880220,
    CAPICOM_E_STORE_NOT_OPENED	= 0x80880230,
    CAPICOM_E_STORE_EMPTY	= 0x80880231,
    CAPICOM_E_STORE_INVALID_OPEN_MODE	= 0x80880232,
    CAPICOM_E_STORE_INVALID_SAVE_AS_TYPE	= 0x80880233,
    CAPICOM_E_ATTRIBUTE_NAME_NOT_INITIALIZED	= 0x80880240,
    CAPICOM_E_ATTRIBUTE_VALUE_NOT_INITIALIZED	= 0x80880241,
    CAPICOM_E_ATTRIBUTE_INVALID_NAME	= 0x80880242,
    CAPICOM_E_ATTRIBUTE_INVALID_VALUE	= 0x80880243,
    CAPICOM_E_SIGNER_NOT_INITIALIZED	= 0x80880250,
    CAPICOM_E_SIGNER_NOT_FOUND	= 0x80880251,
    CAPICOM_E_SIGNER_NO_CHAIN	= 0x80880252,
    CAPICOM_E_SIGNER_INVALID_USAGE	= 0x80880253,
    CAPICOM_E_SIGN_NOT_INITIALIZED	= 0x80880260,
    CAPICOM_E_SIGN_INVALID_TYPE	= 0x80880261,
    CAPICOM_E_SIGN_NOT_SIGNED	= 0x80880262,
    CAPICOM_E_INVALID_ALGORITHM	= 0x80880270,
    CAPICOM_E_INVALID_KEY_LENGTH	= 0x80880271,
    CAPICOM_E_ENVELOP_NOT_INITIALIZED	= 0x80880280,
    CAPICOM_E_ENVELOP_INVALID_TYPE	= 0x80880281,
    CAPICOM_E_ENVELOP_NO_RECIPIENT	= 0x80880282,
    CAPICOM_E_ENVELOP_RECIPIENT_NOT_FOUND	= 0x80880283,
    CAPICOM_E_ENCRYPT_NOT_INITIALIZED	= 0x80880290,
    CAPICOM_E_ENCRYPT_INVALID_TYPE	= 0x80880291,
    CAPICOM_E_ENCRYPT_NO_SECRET	= 0x80880292,
    CAPICOM_E_NOT_SUPPORTED	= 0x80880900,
    CAPICOM_E_UI_DISABLED	= 0x80880901,
    CAPICOM_E_CANCELLED	= 0x80880902,
    CAPICOM_E_NOT_ALLOWED	= 0x80880903,
    CAPICOM_E_OUT_OF_RESOURCE	= 0x80880904,
    CAPICOM_E_INTERNAL	= 0x80880911,
    CAPICOM_E_UNKNOWN	= 0x80880999,
    CAPICOM_E_PRIVATE_KEY_NOT_INITIALIZED	= 0x80880300,
    CAPICOM_E_PRIVATE_KEY_NOT_EXPORTABLE	= 0x80880301,
    CAPICOM_E_ENCODE_NOT_INITIALIZED	= 0x80880320,
    CAPICOM_E_EXTENSION_NOT_INITIALIZED	= 0x80880330,
    CAPICOM_E_PROPERTY_NOT_INITIALIZED	= 0x80880340,
    CAPICOM_E_FIND_INVALID_TYPE	= 0x80880350,
    CAPICOM_E_FIND_INVALID_PREDEFINED_POLICY	= 0x80880351,
    CAPICOM_E_CODE_NOT_INITIALIZED	= 0x80880360,
    CAPICOM_E_CODE_NOT_SIGNED	= 0x80880361,
    CAPICOM_E_CODE_DESCRIPTION_NOT_INITIALIZED	= 0x80880362,
    CAPICOM_E_CODE_DESCRIPTION_URL_NOT_INITIALIZED	= 0x80880363,
    CAPICOM_E_CODE_INVALID_TIMESTAMP_URL	= 0x80880364,
    CAPICOM_E_HASH_NO_DATA	= 0x80880370,
    CAPICOM_E_INVALID_CONVERT_TYPE	= 0x80880380
} CAPICOM_ERROR_CODE;

typedef enum _CAPICOM_ATTRIBUTE
{
    CAPICOM_AUTHENTICATED_ATTRIBUTE_SIGNING_TIME = 0,
    CAPICOM_AUTHENTICATED_ATTRIBUTE_DOCUMENT_NAME = 1,
    CAPICOM_AUTHENTICATED_ATTRIBUTE_DOCUMENT_DESCRIPTION = 2
} CAPICOM_ATTRIBUTE;

typedef enum _CADESCOM_ATTRIBUTE
{
    CADESCOM_AUTHENTICATED_ATTRIBUTE_SIGNING_TIME = 0,
    CADESCOM_AUTHENTICATED_ATTRIBUTE_DOCUMENT_NAME = 1,
    CADESCOM_AUTHENTICATED_ATTRIBUTE_DOCUMENT_DESCRIPTION = 2,
    /** \brief     (1.2.643.2.74.2.1.1.1) */
    CADESCOM_AUTHENTICATED_ATTRIBUTE_MACHINE_INFO = 0x100,
    CADESCOM_ATTRIBUTE_OTHER = 0xffffffff
} CADESCOM_ATTRIBUTE;

typedef enum _CADESCOM_HUMAN_SEXES
{
    CADESCOM_SEX_NOT_KNOWN = 0,
    CADESCOM_SEX_MALE = 1,
    CADESCOM_SEX_FEMALE = 2,
    CADESCOM_SEX_NOT_APPLICABLE = 9
} CADESCOM_HUMAN_SEXES;

typedef enum _CAPICOM_PROV_TYPE
{
    CAPICOM_PROV_RSA_FULL = 1,
    CAPICOM_PROV_RSA_SIG = 2,
    CAPICOM_PROV_DSS = 3,
    CAPICOM_PROV_FORTEZZA = 4,
    CAPICOM_PROV_MS_EXCHANGE = 5,
    CAPICOM_PROV_SSL = 6,
    CAPICOM_PROV_RSA_SCHANNEL = 12,
    CAPICOM_PROV_DSS_DH = 13,
    CAPICOM_PROV_EC_ECDSA_SIG = 14,
    CAPICOM_PROV_EC_ECNRA_SIG = 15,
    CAPICOM_PROV_EC_ECDSA_FULL = 16,
    CAPICOM_PROV_EC_ECNRA_FULL = 17,
    CAPICOM_PROV_DH_SCHANNEL = 18,
    CAPICOM_PROV_SPYRUS_LYNKS = 20,
    CAPICOM_PROV_RNG = 21,
    CAPICOM_PROV_INTEL_SEC = 22,
    CAPICOM_PROV_REPLACE_OWF = 23,
    CAPICOM_PROV_RSA_AES = 24
} CAPICOM_PROV_TYPE;

typedef enum _CAPICOM_KEY_SPEC
{
    CAPICOM_KEY_SPEC_KEYEXCHANGE = 1,
    CAPICOM_KEY_SPEC_SIGNATURE = 2
} CAPICOM_KEY_SPEC;

typedef enum _CADESCOM_ENCRYPTION_ALGORITHM
{
    CADESCOM_ENCRYPTION_ALGORITHM_RC2 = 0,
    CADESCOM_ENCRYPTION_ALGORITHM_RC4 = 1,
    CADESCOM_ENCRYPTION_ALGORITHM_DES = 2,
    CADESCOM_ENCRYPTION_ALGORITHM_3DES = 3,
    CADESCOM_ENCRYPTION_ALGORITHM_AES = 4,
    CADESCOM_ENCRYPTION_ALGORITHM_GOST_28147_89 = 25,
    CADESCOM_ENCRYPTION_ALGORITHM_GOST_MAGMA = 35,
    CADESCOM_ENCRYPTION_ALGORITHM_GOST_MAGMA_OMAC = 36,
    CADESCOM_ENCRYPTION_ALGORITHM_GOST_KUZNYECHIK = 45,
    CADESCOM_ENCRYPTION_ALGORITHM_GOST_KUZNYECHIK_OMAC = 46
} CADESCOM_ENCRYPTION_ALGORITHM;

typedef enum _CAPICOM_ENCRYPTION_KEY_LENGTH
{
    CAPICOM_ENCRYPTION_KEY_LENGTH_MAXIMUM	= 0,
    CAPICOM_ENCRYPTION_KEY_LENGTH_40_BITS	= 1,
    CAPICOM_ENCRYPTION_KEY_LENGTH_56_BITS	= 2,
    CAPICOM_ENCRYPTION_KEY_LENGTH_128_BITS	= 3,
    CAPICOM_ENCRYPTION_KEY_LENGTH_192_BITS	= 4,
    CAPICOM_ENCRYPTION_KEY_LENGTH_256_BITS	= 5
} CAPICOM_ENCRYPTION_KEY_LENGTH;

typedef enum _CAPICOM_HASH_ALGORITHM
{
    CAPICOM_HASH_ALGORITHM_SHA1 = 0,
    CAPICOM_HASH_ALGORITHM_MD2 = 1,
    CAPICOM_HASH_ALGORITHM_MD4 = 2,
    CAPICOM_HASH_ALGORITHM_MD5 = 3,
    CAPICOM_HASH_ALGORITHM_SHA_256 = 4,
    CAPICOM_HASH_ALGORITHM_SHA_384 = 5,
    CAPICOM_HASH_ALGORITHM_SHA_512 = 6,
    CADESCOM_HASH_ALGORITHM_CP_GOST_3411 = 100,
    CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_256 = 101,
    CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_512 = 102,
    CADESCOM_HASH_ALGORITHM_CP_GOST_3411_HMAC = 110,
    CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_256_HMAC = 111,
    CADESCOM_HASH_ALGORITHM_CP_GOST_3411_2012_512_HMAC = 112
} CAPICOM_HASH_ALGORITHM;

#else //WIN32
#include <cadescom.h>
#include "Wininet.h"
#endif //!WIN32

#ifndef __CAdESCOM_LIBRARY_DEFINED__

typedef enum _CADESCOM_CADES_TYPE
{
    CADESCOM_CADES_DEFAULT = 0,
    CADESCOM_CADES_BES = 0x1,
    CADESCOM_CADES_T = 0x5,
    CADESCOM_CADES_X_LONG_TYPE_1 = 0x5d,
    CADESCOM_CADES_A = 0xdd,
    CADESCOM_PKCS7_TYPE = 0xffff
} CADESCOM_CADES_TYPE;

typedef enum {
    CADESCOM_XML_SIGNATURE_TYPE_ENVELOPED = 0x00,
    CADESCOM_XML_SIGNATURE_TYPE_ENVELOPING = 0x01,
    CADESCOM_XML_SIGNATURE_TYPE_TEMPLATE = 0x02
} CADESCOM_XML_SIGNATURE_TYPE;

// afevma: HIWORD,     
// CADESCOM_XML_SIGNATURE_TYPE,  .
//   xades.h.
typedef enum _CADESCOM_XADES_TYPE
{
    CADESCOM_XADES_DEFAULT = 0x00000010,
    CADESCOM_XADES_BES = 0x00000020,
    CADESCOM_XADES_T = 0x00000050,
    CADESCOM_XADES_X_LONG_TYPE_1 = 0x000005d0,
    CADESCOM_XADES_A = 0x000007d0,
    CADESCOM_XMLDSIG_TYPE = 0x00000000
} CADESCOM_XADES_TYPE;

typedef enum _CADESCOM_XADES_ADDITIONAL_OPTIONS
{
    CADESCOM_XADES_ADDITIONAL_OPTIONS_NONE = 0,
    CADESCOM_XADES_ACCEPT_ANY_ID_ATTR_NAMESPACE = 0x1
} CADESCOM_XADES_ADDITIONAL_OPTIONS;

typedef enum {
    CADESCOM_DISPLAY_DATA_NONE                 = 0x00,
    CADESCOM_DISPLAY_DATA_CONTENT              = 0x01,
    CADESCOM_DISPLAY_DATA_ATTRIBUTE            = 0x02
} CADESCOM_DIPLAY_DATA;

#endif //__CAdESCOM_LIBRARY_DEFINED__

#ifdef UNIX
#define INTERNET_PORT int
typedef enum {
  INTERNET_SCHEME_PARTIAL = -2,
  INTERNET_SCHEME_UNKNOWN = -1,
  INTERNET_SCHEME_DEFAULT = 0,
  INTERNET_SCHEME_FTP,
  INTERNET_SCHEME_GOPHER,
  INTERNET_SCHEME_HTTP,
  INTERNET_SCHEME_HTTPS,
  INTERNET_SCHEME_FILE,
  INTERNET_SCHEME_NEWS,
  INTERNET_SCHEME_MAILTO,
  INTERNET_SCHEME_SOCKS,
  INTERNET_SCHEME_JAVASCRIPT,
  INTERNET_SCHEME_VBSCRIPT,
  INTERNET_SCHEME_ABOUT,
  INTERNET_SCHEME_RES,
  INTERNET_SCHEME_FIRST = INTERNET_SCHEME_FTP,
  INTERNET_SCHEME_LAST = INTERNET_SCHEME_VBSCRIPT
} INTERNET_SCHEME, * LPINTERNET_SCHEME;

typedef struct {
  DWORD dwStructSize;
  LPTSTR lpszScheme;
  DWORD dwSchemeLength;
  INTERNET_SCHEME nScheme;
  LPTSTR lpszHostName;
  DWORD dwHostNameLength;
  INTERNET_PORT nPort;
  LPTSTR lpszUserName;
  DWORD dwUserNameLength;
  LPTSTR lpszPassword;
  DWORD dwPasswordLength;
  LPTSTR lpszUrlPath;
  DWORD dwUrlPathLength;
  LPTSTR lpszExtraInfo;
  DWORD dwExtraInfoLength;
} URL_COMPONENTS, * LPURL_COMPONENTS;
#endif

class OpenStoreInfo {
public:
    OpenStoreInfo() : 
        sStoreName(""), dwFlagsLow(0), dwFlagsHigh(0), bIsSystemStore(false) {}
    OpenStoreInfo(
        CAtlString storeName, DWORD flagsLow, DWORD flagsHigh, bool isSystemStore) : 
        sStoreName(storeName), dwFlagsLow(flagsLow), dwFlagsHigh(flagsHigh), bIsSystemStore(isSystemStore) {}

    CAtlString sStoreName;
    DWORD dwFlagsLow;
    DWORD dwFlagsHigh;
    bool bIsSystemStore;
};

//  URL'  .   
// UserApprove (npcades.dll)  CPPPluginConfiguration (cppcades.dll)
HRESULT CrackURL(CAtlString& sURL, URL_COMPONENTS& UrlComps);

BOOL isCryptoProCspHandle(HCRYPTPROV hCryptProv);

// -   UC4 -> UC2
//       UNIX (plugin)  WIN (plugin + COM)
#ifdef UNIX
#include "cplib/Blob.h"
void towin_wchar(CryptoPro::CBlob& data);
void win_towchar(CryptoPro::CBlob& data);
#else
#define towin_wchar(a) 
#define win_towchar(a)
#endif //UNIX

#endif //CPPCADES_H_

