#ifndef CPP_CADES_ENVELOPED_XML_H_
#define CPP_CADES_ENVELOPED_XML_H_
#include "cppcades.h"
#include "CPPCadesCollections.h"
#include "CPPCadesCPSigner.h"
#include "CPPCadesContent.h"
#include "CPPCadesCPAlgorithm.h"

namespace CryptoPro {
    namespace PKI {
        namespace CAdES {


            class CPPCadesEnvelopedXMLObject
            {
            public:
                CPPCadesEnvelopedXMLObject();
                ~CPPCadesEnvelopedXMLObject();

#ifndef UNIX
                HRESULT put_Content(const BSTR& pVal);
                HRESULT get_Content(CComBSTR& pVal);
#endif // UNIX

                HRESULT put_Content(const CStringBlob& pVal);
                HRESULT get_Content(CStringBlob& pVal);

                HRESULT get_Algorithm(
                    NS_SHARED_PTR::shared_ptr<CPPCadesCPAlgorithmObject>& pVal);

                HRESULT get_Recipients(NS_SHARED_PTR::shared_ptr<CPPCadesCPRecipientsObject>& pVal);

                HRESULT Encrypt(CStringBlob& pVal);
                HRESULT Decrypt(const CStringBlob& envelopedMessage);

            private:
                DISALLOW_COPY_AND_ASSIGN(CPPCadesEnvelopedXMLObject);

                //   CadesEnvelopedXML    
                void ResetState();
                HRESULT LoadLibs();
                void UnLoadLibs();

#ifndef UNIX
#pragma warning(push)
#pragma warning(disable: 4251)
#endif
                CStringBlob m_content;
                NS_SHARED_PTR::shared_ptr<CPPCadesCPRecipientsObject> m_pRecipients;
                NS_SHARED_PTR::shared_ptr<CPPCadesCPAlgorithmObject> m_pAlg;
#ifndef UNIX
#pragma warning(pop)
#endif
            };

        } /* namespace CAdES */
    } /* namespace PKI */
} /* namespace CryptoPro */

#endif //CPP_CADES_ENVELOPED_XML_H_

