#ifndef CPPCADES_CERTIFICATE_OBJECT_H_
#define CPPCADES_CERTIFICATE_OBJECT_H_

#include "cppcades.h"
#include "CPPCadesCPKeyUsage.h"
#include "CPPCadesCPExtendedKeyUsage.h"
#include "CPPCadesCPBasicConstraints.h"
#include "CPPCadesCPPublicKey.h"
#include "CPPCadesCPPrivateKey.h"
#include "CPPCadesCPCertificateStatus.h"
#include "CPPCadesCPStore.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPCertificateStatusObject;
class CPPCadesCPStoreObject;

class CPPCadesCPCertificateObject
{
public:
    CPPCadesCPCertificateObject();
    CPPCadesCPCertificateObject(OpenStoreInfo storeInfo);
    ~CPPCadesCPCertificateObject();

    HRESULT GetInfo(CAPICOM_CERT_INFO_TYPE infoType, CAtlString& value);
    HRESULT HasPrivateKey(BOOL* value);
    HRESULT IsValid(NS_SHARED_PTR::shared_ptr<CPPCadesCPCertificateStatusObject>& pVal);
    HRESULT ExtendedKeyUsage(NS_SHARED_PTR::shared_ptr<CPPCadesCPExtendedKeyUsageObject>& value);
    HRESULT KeyUsage(NS_SHARED_PTR::shared_ptr<CPPCadesCPKeyUsageObject>& value);
    HRESULT Export(CAPICOM_ENCODING_TYPE findType, CryptoPro::CBlob& value);
    HRESULT Import(CryptoPro::CBlob& value);
    HRESULT get_SerialNumber(CAtlString& value);
    HRESULT get_Thumbprint(CAtlString& value);
    HRESULT get_SubjectName(CAtlString& value);
    HRESULT get_IssuerName(CAtlString& value);
    HRESULT get_Version(DWORD* value);
    HRESULT get_ValidToDate(CryptoPro::CDateTime& value);
    HRESULT get_ValidFromDate(CryptoPro::CDateTime& value);
    HRESULT BasicConstraints(NS_SHARED_PTR::shared_ptr<CPPCadesCPBasicConstraintsObject>& value);
    HRESULT get_CertContext(CCertContext& pVal);
    HRESULT put_CertContext(const CCertContext& pVal);
    HRESULT FreeContext(PCCERT_CONTEXT pVal);
    HRESULT PublicKey(NS_SHARED_PTR::shared_ptr<CPPCadesCPPublicKeyObject>& pVal);
    HRESULT PrivateKey(NS_SHARED_PTR::shared_ptr<CPPCadesCPPrivateKeyObject>& pVal);
    HRESULT FindPrivateKey(CAtlString cont_name);
    HRESULT AdditionalStore(NS_SHARED_PTR::shared_ptr<CPPCadesCPStoreObject>& pStore);
    HRESULT get_Extensions(NS_SHARED_PTR::shared_ptr<CPPCadesCPExtensionsObject>& pExtensions);
    HRESULT get_Archived(BOOL& pVal);
    HRESULT put_Archived(BOOL pVal);
    HRESULT get_PrivateKeyUsagePeriodFrom(CryptoPro::CDateTime& value);
    HRESULT get_PrivateKeyUsagePeriodTo(CryptoPro::CDateTime& value);

#ifndef UNIX
    HRESULT Display(LONG hwndParent, const wchar_t* Title);
#endif
    //internal use
    HRESULT Clear();
    HRESULT Assign(CCertContext& value);
    PCCERT_CONTEXT GetHandle();
    PCCERT_CHAIN_CONTEXT BuildChain(void);
    void CheckValidState();
private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPCertificateObject);

    HRESULT FillExtendedKeyUsage();
    HRESULT FillKeyUsage();
    HRESULT FillBasicConstraints();
    HRESULT FillPublicKey();
    HRESULT GetContextFromSystemStore(CCertStore tempStore, CCertContext& result);

#pragma warning(push)
#pragma warning(disable: 4251)
    CCertContext m_certificate;
    CCertChainContext m_certificateChain;
#pragma warning(pop)
    NS_SHARED_PTR::shared_ptr<CPPCadesCPCertificateStatusObject> m_pCertStatus;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPExtendedKeyUsageObject> m_pExtendedKeyUsage;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPKeyUsageObject> m_pKeyUsage;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPBasicConstraintsObject> m_pBasicConstraints;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPPublicKeyObject> m_pPublicKey;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPPrivateKeyObject> m_pPrivateKey;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPStoreObject> m_pAdditionalStore;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPExtensionsObject> m_pExtensions;
    OpenStoreInfo m_storeInfo;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CERTIFICATE_OBJECT_H_
