#!/bin/sh
usage_and_exit()
{
    echo "Usage: `basename $0` -i ip_hsm -c cont_name -p pincode [-r path_for_root_cert] [-v mode]"
    echo "    -i    ip address of HSM"
    echo "    -c    name of container that will be used in connection to HSM"
    echo "    -p    pin_code for user container"
    echo "    -r    temporary path to store root certificate"
    echo "    -v    verify certificate mode"
    echo " "
    echo "Example: sudo `basename $0` -i 192.168.26.2 -c HSMClient -p 11111111"
    exit 1
}

make_stunnel_conf()
{
    set -e
    mkdir -p /etc/opt/cprocsp/stunnel
    if [ -e /etc/opt/cprocsp/stunnel/stunnel.conf.$arch ]; then 
       mv -f /etc/opt/cprocsp/stunnel/stunnel.conf.$arch /etc/opt/cprocsp/stunnel/stunnel.conf.old.$arch
    fi
    cat <<-END >>/etc/opt/cprocsp/stunnel/stunnel.conf.$arch
    setuid = root
    setgid = 0
    pid = /var/opt/cprocsp/tmp/stunnel-K2.pid
    #output=/var/log/stunnel-K2.log
    #socket = l:TCP_NODELAY=1
    socket = r:TCP_NODELAY=1
    debug = 0
    for_hsm = yes
    [clientk2]
    client = yes
END
    echo "verify = $verify" >> /etc/opt/cprocsp/stunnel/stunnel.conf.$arch
    echo "accept = /var/opt/cprocsp/tmp/.clientk2_$arch" >> /etc/opt/cprocsp/stunnel/stunnel.conf.$arch
    echo "connect = $ipaddres:1501" >> /etc/opt/cprocsp/stunnel/stunnel.conf.$arch
    echo "cert = $user_cert_path/cert.cer" >> /etc/opt/cprocsp/stunnel/stunnel.conf.$arch
    echo "pincode = $pin_code" >> /etc/opt/cprocsp/stunnel/stunnel.conf.$arch
    set +e
}

check_csp_ver()
{
    version_string=`/opt/cprocsp/bin/$arch/csptestf -keyset -verifycontext 2>/dev/null | grep Ver`;
    if test -z "$version_string"; then
        echo "Can not get CSP version"
        exit 1
    elif [ `echo $version_string | awk '{print substr($3,1,4)}'` = "v3.9" ]; then
	CSPVER=3.9
    elif [ `echo $version_string | awk '{print substr($3,1,4)}'` = "v4.0" ]; then
	CSPVER=4.0
    else 
	CSPVER=5.0
    fi
}

check_os_ver()
{
    cd `dirname $0`
    arch=`pwd  | awk -F / '{print $5}'`	
    echo "OS Arch: $arch"
}	

reg_hsm_prov()
{
    
    cpconfig=/opt/cprocsp/sbin/$arch/cpconfig
    echo "$cpconfig"
    check_csp_ver
    case `uname -s` in
    Darwin) LIBCSPR=libcspr.dylib;;
    *) LIBCSPR=libcspr.so;;
    esac
    set -e
    $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro HSM RSA CSP' -add string 'Image Path' /opt/cprocsp/lib/$arch/$LIBCSPR
    $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro HSM RSA CSP' -add long Type 1
    $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro HSM RSA CSP' -add string Channel .clientk2_$arch
    $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro HSM RSA CSP' -add string Media HSM
    $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro HSM RSA CSP' -add string 'Function Table Name' CPSRV_GetFunctionTable  

    if [ $CSPVER = 3.9 ]; then
         echo "CSPVER = 3.9"
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro HSM CSP' -add string 'Image Path' /opt/cprocsp/lib/$arch/$LIBCSPR
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro HSM CSP' -add long Type 75
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro HSM CSP' -add string Channel .clientk2_$arch
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro HSM CSP' -add string Media HSM
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro HSM CSP' -add string 'Function Table Name' CPSRV_GetFunctionTable  
    else
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2001 HSM CSP' -add string 'Image Path' /opt/cprocsp/lib/$arch/$LIBCSPR
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2001 HSM CSP' -add long Type 75
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2001 HSM CSP' -add string Channel .clientk2_$arch
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2001 HSM CSP' -add string Media HSM
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2001 HSM CSP' -add string 'Function Table Name' CPSRV_GetFunctionTable  
         
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2012 HSM CSP' -add string 'Image Path' /opt/cprocsp/lib/$arch/$LIBCSPR
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2012 HSM CSP' -add long Type 80
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2012 HSM CSP' -add string Channel .clientk2_$arch
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2012 HSM CSP' -add string Media HSM
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2012 HSM CSP' -add string 'Function Table Name' CPSRV_GetFunctionTable  

         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2012 Strong HSM CSP' -add string 'Image Path' /opt/cprocsp/lib/$arch/$LIBCSPR
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2012 Strong HSM CSP' -add long Type 81
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2012 Strong HSM CSP' -add string Channel .clientk2_$arch
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2012 Strong HSM CSP' -add string Media HSM
         $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro GOST R 34.10-2012 Strong HSM CSP' -add string 'Function Table Name' CPSRV_GetFunctionTable  
    
	 if [ $CSPVER = 4.0 ]; then
             echo "CSPVER = 4.0"
	 else
             echo "CSPVER = 5.0"
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro RSA HSM CSP' -add string 'Image Path' /opt/cprocsp/lib/$arch/$LIBCSPR
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro RSA HSM CSP' -add long Type 1
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro RSA HSM CSP' -add string Channel .clientk2_$arch
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro RSA HSM CSP' -add string Media HSM
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro RSA HSM CSP' -add string 'Function Table Name' CPSRV_GetFunctionTable  

             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro ECDSA and AES HSM CSP' -add string 'Image Path' /opt/cprocsp/lib/$arch/$LIBCSPR
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro ECDSA and AES HSM CSP' -add long Type 16
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro ECDSA and AES HSM CSP' -add string Channel .clientk2_$arch
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro ECDSA and AES HSM CSP' -add string Media HSM
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro ECDSA and AES HSM CSP' -add string 'Function Table Name' CPSRV_GetFunctionTable  

             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro Enhanced RSA and AES HSM CSP' -add string 'Image Path' /opt/cprocsp/lib/$arch/$LIBCSPR
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro Enhanced RSA and AES HSM CSP' -add long Type 24
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro Enhanced RSA and AES HSM CSP' -add string Channel .clientk2_$arch
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro Enhanced RSA and AES HSM CSP' -add string Media HSM
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro Enhanced RSA and AES HSM CSP' -add string 'Function Table Name' CPSRV_GetFunctionTable  

             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro Curve25519 and AES HSM CSP' -add string 'Image Path' /opt/cprocsp/lib/$arch/$LIBCSPR
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro Curve25519 and AES HSM CSP' -add long Type 32
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro Curve25519 and AES HSM CSP' -add string Channel .clientk2_$arch
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro Curve25519 and AES HSM CSP' -add string Media HSM
             $cpconfig -ini '\cryptography\Defaults\Provider\Crypto-Pro Curve25519 and AES HSM CSP' -add string 'Function Table Name' CPSRV_GetFunctionTable  
	 fi
    fi
    $cpconfig -ini '\config\parameters' -add long CheckSocketBeforeCall 1
    set +e
}

install_certs()
{
    set -e
    echo "Installing certificates"
    FQCN=`/opt/cprocsp/bin/$arch/csptestf -keyset -enum_cont -fqcn -verifycontext | grep -F "$cont" | sort | head -n1`
    /opt/cprocsp/bin/$arch/csptestf -keyset -container "$FQCN" -saveext $rootcert_file
    /opt/cprocsp/bin/$arch/certmgr -inst -cont "$FQCN"
    /opt/cprocsp/bin/$arch/certmgr -exp -cont "$FQCN" -dest $user_cert_path/cert.cer
    /opt/cprocsp/bin/$arch/certmgr -inst -store mRoot -file $rootcert_file > /dev/null
    set +e
}

check_hsm_prov()
{
    
    if [ $CSPVER = 3.9 ]; then
	PROVIDER="Crypto-Pro HSM CSP"
    else 
	PROVIDER="Crypto-Pro GOST R 34.10-2001 HSM CSP"
    fi    
    echo "Checking provider: $PROVIDER"
    errorcode="`/opt/cprocsp/bin/$arch/csptestf -enum -info -provtype 75 -provider "\$PROVIDER"| grep ErrorCode | awk '{print(substr($2,3,8))}'`" 
    if [ $errorcode = 00000000 ]; then
        echo "OK"
    else 
        echo "Failed"
        exit 1
    fi
    
}

if [  $# -le 4 ]; then 
    echo "Not enough options!"
    usage_and_exit
fi

pin_code=""
rootcert_file=/tmp/hsm_root_tmp.cer
verify=2
while getopts "i:c:r:p:v:" opt
do
    case $opt in 
        i)
        ipaddres=$OPTARG
        ;;
        c)
        cont=$OPTARG
        ;;
        r)
        rootcert_file=$OPTARG
        ;;
        p)
        pin_code=$OPTARG
        ;;
        v)
        verify=$OPTARG
        ;;
        \?)usage_and_exit
    esac
done
    
user_cert_path=~
echo "Path to user certificate: $user_cert_path"
check_os_ver
check_csp_ver
echo "CSP version: $CSPVER"

make_stunnel_conf
reg_hsm_prov
install_certs
sleep 1
case `uname -s` in
Darwin) STUNNEL_BIN=stunnel_thread;;
*) STUNNEL_BIN=stunnel_fork;;
esac
/opt/cprocsp/sbin/$arch/$STUNNEL_BIN /etc/opt/cprocsp/stunnel/stunnel.conf.$arch
sleep 1
check_hsm_prov
echo "Done."
