<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>


<xsl:template match="DVCSResponse" name="DVCSResponse">


    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSResponse_info</xsl:with-param> </xsl:call-template>
    </fo:block>




   <xsl:for-each select="./dvCertInfo">  
	<xsl:call-template name="DVCSCertInfo"/>
   </xsl:for-each>

   <xsl:for-each select="./dvErrorNote">  
	<xsl:call-template name="DVCSErrorNotice"/>
   </xsl:for-each>

</xsl:template>

	<!--  DVCSCertInfo -->
<xsl:template match="DVCSCertInfo" name="DVCSCertInfo">


    <!--   -->	
    <xsl:for-each select="./version">  
	<xsl:call-template name="INTVersion"/>
    </xsl:for-each>

    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSCertInfo_dvReqInfo</xsl:with-param> </xsl:call-template>
    </fo:block>

    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      border-style="solid"
	      padding="3pt"
	      >

	    <!--    -->	
	    <xsl:for-each select="./dvReqInfo">  
		<xsl:call-template name="DVCSRequestInformation"/>
	    </xsl:for-each>
    </fo:block>

    <xsl:for-each select="./messageImprint">  
	<xsl:call-template name="DigestInfo"/>
    </xsl:for-each>

    <xsl:for-each select="./serialNumber">  
	<xsl:call-template name="CertificateSerialNumber"/>
    </xsl:for-each>

    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSCertInfo_responseTime</xsl:with-param> </xsl:call-template>


    <!--    -->	
    <xsl:for-each select="./responseTime">  
	<xsl:call-template name="DVCSTime"/>
    </xsl:for-each>
    </fo:block>

	<!--   PKIStatusInfo -->
    <xsl:for-each select="./dvStatus">
	<xsl:call-template name="PKIStatusInfo"/>
    </xsl:for-each>


 	<!--  : -->
    <xsl:for-each select="./policy">  
      <fo:block font-family="Courier New" font-size="10pt"                      
	    padding="3pt"
	    >

	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSCertInfo_policy</xsl:with-param> </xsl:call-template>
      </fo:block>

	<xsl:call-template name="PolicyInformation"/>
    </xsl:for-each>


	<!--> <-->
    <xsl:for-each select="./reqSignature">  
      <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      
<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSCertInfo_reqSignature</xsl:with-param> </xsl:call-template>
      </fo:block>

   
	<xsl:call-template name="SignerInfos"/>
    </xsl:for-each>

	<!--><-->
    <xsl:for-each select="./certs">  
      <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSCertInfo_certs</xsl:with-param> </xsl:call-template>
      </fo:block>

   	<xsl:for-each select="./*">  
        	<xsl:call-template name="TargetEtcChain"/>
	</xsl:for-each>  
    </xsl:for-each>


     <xsl:for-each select="./extensions">  
	  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSCertInfo_extensions</xsl:with-param> </xsl:call-template>				
	  </fo:block>

		<!--   -->
	  <fo:block font-family="Times" font-size="10pt"
	    margin-left="1.5em"
	    >
	    <xsl:call-template name="Extensions"/>
          </fo:block>
    </xsl:for-each>
</xsl:template>

	<!--  DVCSErrorNotice -->
<xsl:template match="DVCSErrorNotice" name="DVCSErrorNotice">

    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSErrorNotice_header</xsl:with-param> </xsl:call-template>
    </fo:block>

	<!--   PKIStatusInfo -->
    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSErrorNotice_transactionStatus</xsl:with-param> </xsl:call-template>
    </fo:block>

    <xsl:for-each select="./transactionStatus">
	<xsl:call-template name="PKIStatusInfo"/>
    </xsl:for-each>


    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSErrorNotice_transactionIdentifier</xsl:with-param> </xsl:call-template>
    </fo:block>

  <fo:block font-family="Courier New" font-size="10pt"
    border-style="solid"
    padding="3pt"
    >
    <xsl:for-each select="./transactionIdentifier">  
	<xsl:call-template name="GeneralName"/>
    </xsl:for-each>
   </fo:block>

</xsl:template>


</xsl:stylesheet>