<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>



    <!-- Header   -->

<xsl:template name="CertificationRequest" match="CertificationRequest">
  <xsl:param name="PKI"/>
    <!-- Header -->
  <fo:static-content flow-name="xsl-region-before">
    <fo:block>
<!--      <fo:block text-align="left" font-size="8pt"
		>
      </fo:block>
      <fo:block text-align="center" font-size="8pt"				
		>
      </fo:block>
      <fo:block text-align="right" font-size="8pt"
		>
	<fo:inline text-decoration="underline">
          <xsl:call-template name="printPERS"> <xsl:with-param name="persID">form_nf_certreq_title</xsl:with-param> </xsl:call-template>
	</fo:inline>
      </fo:block>
-->    </fo:block>
  </fo:static-content>




	<!-- Footer -->
  <fo:static-content flow-name="xsl-region-after">
    <fo:block text-align="center" font-size="10pt"				
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_paper</xsl:with-param> </xsl:call-template>						<!--  -->
      <fo:page-number/>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_of</xsl:with-param> </xsl:call-template>
      <fo:page-number-citation ref-id="end of certificate"/>
    </fo:block>
  </fo:static-content>




	<!--   -->

		<!--   -->

  <fo:flow flow-name="xsl-region-body">
    <fo:block text-align="center"
	      font-family="Arial" font-size="14pt"
	      space-before="32pt"
	      space-after="16pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequest_header</xsl:with-param> </xsl:call-template>					<!--  -->
    </fo:block>


            <!--     -->	  
    <xsl:call-template name="uc_title"/>


	<!--   -->
    <fo:block test-align="center"                                                            	
	      font-family="Times" font-size="12pt"				
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequest_text</xsl:with-param> </xsl:call-template>					<!--  -->

      <xsl:if test="$PKI='true'">
	<xsl:choose>

	<!--  ( ) -->
	<xsl:when test="count(//ir) &gt; 0">
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequest_ir</xsl:with-param> </xsl:call-template>                             <!--  -->
	</xsl:when>

	<!--  (  ) -->
	<xsl:when test="count(//kur) &gt; 0">
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequest_kur</xsl:with-param> </xsl:call-template>                             <!--  -->
	</xsl:when>

	<!--  (  ) -->
	<xsl:when test="count(//ccr) &gt; 0">
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequest_ccr</xsl:with-param> </xsl:call-template>                          <!--  -->
	</xsl:when>
	</xsl:choose>
      </xsl:if>	


    </fo:block>

	<!--     : -->		
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"               
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequest_owner</xsl:with-param> </xsl:call-template>              <!--  -->

    </fo:block>


	<!--       -->		
    <fo:block font-family="Times" font-size="10pt"
	      space-before="0pt"
	      space-after="10pt"                        
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <fo:table text-align="center"
		keep-with-next="always"
		border-style="solid"
		>
	<fo:table-column column-width="35%"/>      	<!--  -->
	<fo:table-column column-width="65%"/>
	<fo:table-body>
	  <fo:table-row>
	    <fo:table-cell
			    border-style="solid"
			    padding="1pt" text-align="left">


		<!--    -->
	      <fo:block
			keep-with-next="always"
			>
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequest_FIO</xsl:with-param> </xsl:call-template>		<!--  -->
	      </fo:block>
	    </fo:table-cell>
	    <fo:table-cell
			    border-style="solid"
			    padding="1pt" text-align="right">
	      <fo:block
			keep-with-next="always"
			>
		<xsl:text>.</xsl:text>
	      </fo:block>
	    </fo:table-cell>
	  </fo:table-row>
	  <fo:table-row>
	    <fo:table-cell
			    border-style="solid"
			    padding="1pt" text-align="left">

		<!--    -->
	      <fo:block
			keep-with-next="always"
			>
		<!--    -->        
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequest_nick</xsl:with-param> </xsl:call-template>        <!--  -->
	      </fo:block>
	    </fo:table-cell>
	    <fo:table-cell
			    border-style="solid"
			    padding="1pt" text-align="right">
	      <fo:block
			keep-with-next="always"
			>
		<xsl:text>.</xsl:text>
	      </fo:block>
	    </fo:table-cell>
	  </fo:table-row>
	  <fo:table-row>
	    <fo:table-cell
			    border-style="solid"
			    padding="1pt" text-align="left">

		<!--    -->
	      <fo:block
			keep-with-next="always"
			>                               
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequest_company</xsl:with-param> </xsl:call-template>     <!--  -->
	      </fo:block>
	    </fo:table-cell>
	    <fo:table-cell
			    border-style="solid"
			    padding="1pt" text-align="right">
	      <fo:block
			keep-with-next="always"
			>
		<xsl:text>.</xsl:text>
	      </fo:block>
	    </fo:table-cell>
	  </fo:table-row>
	</fo:table-body>
      </fo:table>
    </fo:block>



 	<!--      -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"                 	
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequest_authoritytext</xsl:with-param> </xsl:call-template>        <!--  -->
    </fo:block>



	<!--     -->
     <xsl:for-each select="./certificationRequestInfo">  
	<xsl:call-template name="CertificationRequestInfo"/>
    </xsl:for-each>


    <xsl:if test="$PKI='true'">

 	   <fo:block font-family="Times" font-size="10pt"
		      >
		<xsl:choose>
		<xsl:when test="count(//p10cr) &gt; 0">
		     <xsl:for-each select="//certificationRequestInfo">  
			<xsl:call-template name="CertificationRequestInfo"/>
		    </xsl:for-each>
		</xsl:when>
		<xsl:when test="count(//ir) &gt; 0 or count(//kur) &gt; 0 or count(//cr) &gt; 0 or count(//ccr) &gt; 0">
		    <xsl:for-each select="//certTemplate">  
			<xsl:call-template name="CertTemplate"/>
		    </xsl:for-each>
		</xsl:when>
		</xsl:choose>
	    </fo:block>
            <xsl:for-each select="//pop">  
	        <xsl:call-template name="ProofOfPossession"/>
	    </xsl:for-each>
    </xsl:if>


	<!-- :-->
    <xsl:for-each select="./signatureAlgorithm">  
	<xsl:call-template name="SignatureAlgorithm"/>
    </xsl:for-each>


        <!--    -->
	<!--   -->
     <xsl:for-each select="./signature">  
	<xsl:call-template name="Signature"/>
    </xsl:for-each>


	<!--    -->	
    <!-- <xsl:call-template name="skzi_list"/>-->

    <xsl:call-template name="stamp-issuer-or-subject">
      <xsl:with-param name="title"><xsl:call-template name="printPERS"> <xsl:with-param name="persID">pers_vl_title</xsl:with-param> </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>

    <fo:block id="end of certificate">
    </fo:block>
  </fo:flow>
</xsl:template>

<xsl:template match="CertificationRequestInfo" name="CertificationRequestInfo">

     <xsl:for-each select="./version">  
	<xsl:call-template name="INTVersion"/>
     </xsl:for-each>


  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequestInfo_subject</xsl:with-param> </xsl:call-template>		<!--  --> 	
  </fo:block>

     <xsl:for-each select="./subject">  
	<fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
	<xsl:call-template name="Name"/>
	</fo:block>
     </xsl:for-each>  

	<!--      -->

     <xsl:for-each select="./subjectPublicKeyInfo">  
	<xsl:call-template name="SubjectPublicKeyInfo"/>
    </xsl:for-each>


  <xsl:variable name="attributeCount" select="0"/>

	<!--     :-->
  <fo:block font-family="Times" font-size="10pt"       			
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificationRequestInfo_attributes</xsl:with-param> </xsl:call-template>
  </fo:block>

	<!--   -->
  <fo:block font-family="Times" font-size="10pt"                        
	    margin-left="1.5em"
	    >
     <xsl:for-each select="./attributes/*">  
	<xsl:call-template name="Attribute"/>
    </xsl:for-each>

  
  </fo:block>


</xsl:template>


	<!--  CertTemplate-->
<xsl:template name="CertTemplate" match="CertTemplate">


    <!--   -->	
     <xsl:for-each select="./version">  
	<xsl:call-template name="Version"/>
    </xsl:for-each>





	<!--   : -->
  <xsl:for-each select="./serialNumber">  
  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_serialNumber</xsl:with-param> </xsl:call-template>					<!--  -->
  </fo:block>

    <!--    -->	
  <fo:block font-family="Courier New" font-size="10pt"                      
	    border-style="solid"
	    padding="3pt"
	    >
	<xsl:call-template name="CertificateSerialNumber"/>
  </fo:block>
  </xsl:for-each>




  <xsl:for-each select="./signingAlg">  
	<xsl:call-template name="SignatureAlgorithm"/>
  </xsl:for-each>




	<!--   -->

	<!-- -->
  <xsl:for-each select="./issuer">  
  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_issuer</xsl:with-param> </xsl:call-template>		<!--  --> 	
  </fo:block>

	<!--   -->

	<fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
	<xsl:call-template name="Name"/>
	</fo:block>
  </xsl:for-each>



	<!--    -->
  <xsl:if test="count(issuerUniqueID)>=1">

	<!--   -->
     <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_issuerUniqueID</xsl:with-param> </xsl:call-template>		<!--  --> 	
     </fo:block>

	<!--   -->
     <xsl:for-each select="./issuerUniqueID">  
	<xsl:call-template name="UniqueIdentifier"/>
    </xsl:for-each>

  </xsl:if> 






     <!--   -->

     <xsl:for-each select="./validity">  
	<xsl:call-template name="Validity"/>
    </xsl:for-each>




	<!--  -->

	<!--  -->
  <xsl:for-each select="./subject">  
  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_subject</xsl:with-param> </xsl:call-template>		<!--  --> 	
  </fo:block>

	<!--   -->


	<fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
	<xsl:call-template name="Name"/>
	</fo:block>
  </xsl:for-each>



	<!--   -->
  <xsl:if test="count(subjectUniqueID)>=1">

	<!--   -->
     <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_subjectUniqueID</xsl:with-param> </xsl:call-template>		<!--  --> 	
     </fo:block>

	<!--   -->
     <xsl:for-each select="./subjectUniqueID">  
	<xsl:call-template name="UniqueIdentifier"/>
    </xsl:for-each>

  </xsl:if> 



	<!--      -->

     <xsl:for-each select="./publicKey">  
	<xsl:call-template name="SubjectPublicKeyInfo"/>
    </xsl:for-each>



	<!--   -->
	<!--   : -->
 <xsl:for-each select="./extensions">  
  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_extensions</xsl:with-param> </xsl:call-template>				<!--  -->
  </fo:block>

	<!--   -->
  <fo:block font-family="Times" font-size="10pt"
	    margin-left="1.5em"
	    >


	<xsl:call-template name="Extensions"/>

  </fo:block>
  </xsl:for-each>
</xsl:template>

 </xsl:stylesheet>
