<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>

                                
<xsl:template match="CertificateList" name="CertificateList">
<xsl:param name="Included"/>

<xsl:if test="$Included = 'false'">

    <!-- Header   -->
	
  <fo:static-content flow-name="xsl-region-before">
    <fo:block>
      <fo:block text-align="left" font-size="8pt"
		>
      </fo:block>
      <fo:block text-align="center" font-size="8pt"
		>
      </fo:block>

	<!--     -->
      <!--<fo:block text-align="right" font-size="8pt"		
		>
	<fo:inline text-decoration="underline">
          <xsl:call-template name="printPERS"> <xsl:with-param name="persID">form_nf_crl_title</xsl:with-param> </xsl:call-template>
	</fo:inline>
      </fo:block> -->
    </fo:block>
  </fo:static-content>


      <!-- Footer  -->

  <fo:static-content flow-name="xsl-region-after">
    <fo:block text-align="center" font-size="10pt"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_paper</xsl:with-param> </xsl:call-template>				<!--  -->
      <fo:page-number/>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_of</xsl:with-param> </xsl:call-template>
      <fo:page-number-citation ref-id="end of certificate"/>
    </fo:block>
  </fo:static-content>




    <!--     -->


	<!--    -->
	
  <fo:flow flow-name="xsl-region-body">


	<!--     -->	

    <fo:block text-align="center"
	      font-family="Arial" font-size="14pt"
	      space-before="32pt"
	      space-after="16pt"                                
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificateList_list</xsl:with-param> </xsl:call-template>                     <!--  -->
    </fo:block>

	<!--   -->

            <!--       -->
    <fo:block text-align="center"
	      font-family="Arial" font-size="12pt"
	      space-before="0pt"
	      space-after="16pt"                                
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificateList_at</xsl:with-param> </xsl:call-template>			<!--  -->
    <xsl:for-each select="./tbsCertList/thisUpdate">  
	<xsl:call-template name="Time"/>
    </xsl:for-each>
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificateList_nextupd</xsl:with-param> </xsl:call-template>	
    <xsl:for-each select="./tbsCertList/nextUpdate">  
	<xsl:call-template name="Time"/>
    </xsl:for-each>
    <xsl:text>)</xsl:text>
  </fo:block>


            <!--     -->	  
    <xsl:call-template name="uc_title"/>



    	<!--  TBSCertificate-->

    <xsl:for-each select="./tbsCertList">  
	<xsl:call-template name="TBSCertList"/>
    </xsl:for-each>


	<!-- :-->
     <xsl:for-each select="./signatureAlgorithm">  
	<xsl:call-template name="SignatureAlgorithm"/>
    </xsl:for-each>



	<!--   -->

     <xsl:for-each select="./signature">  
	<xsl:call-template name="Signature"/>
    </xsl:for-each>





	<!--    -->	
	<!-- <xsl:call-template name="skzi_list"/>-->



	<!--     /   -->
    <xsl:call-template name="stamp-issuer-or-subject">
      <xsl:with-param name="title"><xsl:call-template name="printPERS"> <xsl:with-param name="persID">pers_ul_title</xsl:with-param> </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>


    <fo:block id="end of certificate">
    </fo:block>
  </fo:flow>

</xsl:if>


<xsl:if test="$Included != 'false'">
    	<!--  TBSCertificate-->

    <xsl:for-each select="./tbsCertList">  
	<xsl:call-template name="TBSCertList"/>
    </xsl:for-each>


	<!-- :-->
     <xsl:for-each select="./signatureAlgorithm">  
	<xsl:call-template name="SignatureAlgorithm"/>
    </xsl:for-each>



	<!--   -->

     <xsl:for-each select="./signature">  
	<xsl:call-template name="Signature"/>
    </xsl:for-each>

</xsl:if>

</xsl:template>

<xsl:template match="TBSCertList" name="TBSCertList">

         <!--     -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"					
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertList_issuer_inf</xsl:with-param> </xsl:call-template>                    <!--  -->
    </fo:block>                                                 


	<!--   -->

	<!-- -->

  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertList_issuer</xsl:with-param> </xsl:call-template>		<!--  --> 	
  </fo:block>

	<!--   -->
     <xsl:for-each select="./issuer">  
	<fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
	<xsl:call-template name="Name"/>
	</fo:block>
    </xsl:for-each>


	<!--   -->
  <fo:block font-family="Times" font-size="10pt"
	    margin-left="1.5em"
	    >

     <xsl:for-each select="./crlExtensions">  
	<xsl:call-template name="Extensions"/>
    </xsl:for-each>

  </fo:block>



        <!--   ,   /: -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"                                 
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertList_stopped</xsl:with-param> </xsl:call-template>		<!--  -->
    </fo:block>

      <xsl:apply-templates select="./revokedCertificates"/>   <!--    .  -->

</xsl:template>




<xsl:template match="revokedCertificates">
    <fo:list-block provisional-distance-between-starts="75mm" provisional-label-separation="20mm" >
	<fo:list-item space-before="3mm" space-after="5mm">
		<!--     -->
	    <fo:list-item-label>
	      <fo:block  font-size="10pt">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertList_revokedCertificates_userCertificate</xsl:with-param> </xsl:call-template> 	<!--  -->
	      </fo:block>
	    </fo:list-item-label>
		<!--     -->
	    <fo:list-item-body>
	      <fo:block  font-size="10pt">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertList_revokedCertificates_revocationDate</xsl:with-param> </xsl:call-template> 	<!--  -->
	      </fo:block>
	    </fo:list-item-body>
	</fo:list-item>
	<!--   -->
  <xsl:for-each select="SEQUENCE">
	<fo:list-item space-before="3mm" space-after="5mm">
		<!--   -->
	    <fo:list-item-label>
	      <fo:block font-family="sans serif">
		<xsl:value-of select="userCertificate"/>
	      </fo:block>
	    </fo:list-item-label>
		
		<!--   -->
	    <fo:list-item-body>
	      <fo:block font-family="sans serif">
		 <xsl:for-each select="./revocationDate">  
			<xsl:call-template name="Time"/>
		 </xsl:for-each>
	      </fo:block>
	    </fo:list-item-body>
	</fo:list-item>
  </xsl:for-each>
      </fo:list-block>
</xsl:template>


 </xsl:stylesheet>

