/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 195469 $
 * \date $Date:: 2019-07-02 11:39:24 +0300#$
 * \author $Author: frolov $
 *
 * \brief      .
 */

#include "rndm_prj.h" 

/*!    . */
typedef struct TRandomFind_
{
    TRndmType mask; /*!<    . */
    TRndmType value; /*!<    . */
} TRandomFind;

/*!
 * \brief       
 * \param add_info [in]  
 * \param item [in]  
 * \return  
 * \retval 0    
 * \retval -1  
 * \retval 1   
 */
static int rndm_find_mask_valid( const TSupSysFindInfo *add_info, 
    const TSupSysEContext *item )
{
    const TRandomFind *rf = (const TRandomFind *)add_info;
    TRndmType type;
    DWORD code;
    SUPSYS_PRE(add_info);
    SUPSYS_PRE(item);

    code = rndm_type_get( item, &type );
    if( code )
	return -1;
    if( ( rf->mask & type ) == rf->value )
	return 0;
    return 1;
}

DWORD rndm_find_mask(
    TSupSysEList *list,
    TSupSysEContext **context,
    TRndmType mask,
    TRndmType value ) 
{
    TSupSysEFind *f;
    DWORD code;
    TRandomFind rf;
    SUPSYS_PRE(list);
    SUPSYS_PRE(context);
    rf.mask = mask;
    rf.value = value;
    code = supsys_find_open_ext(list, &f, (TSupSysFindInfo*)&rf, rndm_find_mask_valid);
    if(code)
	return code;

    code = supsys_find_next( f, context );
    supsys_find_close( f );
    if( code == (DWORD)SCARD_E_READER_UNAVAILABLE )
	return (DWORD)NTE_PROVIDER_DLL_FAIL;
    return code;
}
