/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 186620 $
 * \date $Date:: 2018-12-24 16:38:12 +0300#$
 * \author $Author: borodin $
 * \brief   pin.
 */

#include "ric_prj.h"

/*!
 * \brief   pin.
 */
DWORD ric_change_pin(
    TRICContext *ctx, 
    unsigned char pin[PIN_LENGTH] )
{
    DWORD code;
    BYTE apdu_change[] = { 0, 0xDC, 0x00, 0x00 };
    if (ctx->card_type == CardType_Magistra) {
	apdu_change[PCSC_INS_NUM] = 0x24;
	apdu_change[PCSC_P1_NUM] = 0x01;
    }

    /* Select pin file. */
    code = select_app( ctx);
    if( code )
	return code;
    /* change pin */
    code = send_apdu( ctx, apdu_change, pin, PIN_LENGTH, NULL, NULL );
    if( code )
	return code;
    /*   select file,   . */
    if( ctx->file ) {
	size_t length;
	ric_select_file( ctx, ctx->file, &length );
    }
    return ERROR_SUCCESS;
}
/* end of file:$Id: ricchp.c 186620 2018-12-24 13:38:12Z borodin $ */
