/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 186620 $
 * \date $Date:: 2018-12-24 16:38:12 +0300#$
 * \author $Author: borodin $
 * \brief   pin-.
 */

#include "ric_prj.h"

/*!
 * \brief   pin-.
 */
DWORD ric_verify_pin(TRICContext *ctx, const char * pin, int *retries)
{
    DWORD code;
    BYTE apdu_verify[] = { 0, 0x20, 0x00, 0x00};
    /* Select pin file. */
    if (ctx->card_type == CardType_Magistra) {
	code = trust_select_application(ctx);
	if (code)
	    return code;
    }
    else {
	code = select_app( ctx);
	if( code )
	    return code;
    }
    /* verify pin */
    code = send_apdu(ctx, apdu_verify, (BYTE*)pin, PIN_LENGTH, NULL, NULL);
    if (code == (DWORD)SCARD_W_WRONG_CHV) {
	*retries = ctx->retries;
	return code;
    }
    
    return code;
}
/* end of file:$Id: ric_vpin.c 186620 2018-12-24 13:38:12Z borodin $ */
