 /*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

#include "ric_prj.h"

DWORD ric_file_read( 
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TReaderInfoRead *inf = (TReaderInfoRead*)info;
    DWORD code;
    TRICContext *ctx = (TRICContext*)context;
    BYTE apdu[] = { 0, 0xB0, 0, 0 };
    size_t length = 0;
    int full = 0;
    size_t offset = 0;

    SUPSYS_PRE_CONTEXT( context, TRICContext );
    SUPSYS_PRE_INFO( info, TReaderInfoRead );
    SUPSYS_PRE( ctx->file );
    SUPSYS_PRE( inf->from <= 0x7fff );
    SUPSYS_PRE( inf->info.length <= 0xffff );

    length = ctx->block_len_read;
    if( length > inf->info.length )
	length = inf->info.length;
    if( inf->from >= ctx->file_length )
	return (DWORD)NTE_TOKEN_KEYSET_STORAGE_FULL;
    if( inf->from + length > ctx->file_length ) {
	full = 1;
	length = ctx->file_length - inf->from;
    }
    if (ctx->card_type == CardType_OSCAR2) {
	size_t from_new;
	if((ctx->file > 0) && (ctx->file < 6)) {
	    size_t _offset;
	    code = oscar2_file_offset(ctx->file, &_offset, ctx->connect_name);
	    if(code)
		return code;
	    from_new = inf->from + _offset;
	}
	else
	    from_new = inf->from;
	offset = from_new;
    } 
    else {
	offset = inf->from;
    }
    apdu[PCSC_P1_NUM] = (unsigned char)( offset >> 8 );
    apdu[PCSC_P2_NUM] = (unsigned char)( offset & 0xff );
    code = send_apdu (ctx, apdu, NULL, 0, inf->info.info, &length);
    if( code )
	return code;
    inf->info.length -= length;
    if( full )
	return (DWORD)NTE_TOKEN_KEYSET_STORAGE_FULL;
    if( inf->info.length )
	return (DWORD)CPR_ERR_BLOCK;
    return ERROR_SUCCESS;
}
/* end of file: $Id: ric_rd.c 150304 2016-12-16 14:05:23Z sagafyin $ */
