/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 186620 $
 * \date $Date:: 2018-12-24 16:38:12 +0300#$
 * \author $Author: borodin $
 * \brief      .
 */

#include "ric_prj.h"
#include "reader.kit/rdr_ver.h"

#if defined( _WIN32 )
static DWORD oscar_property_init( TSupSysContext *context, 
    TSupSysInfo *info );

static DWORD oscar_wizard_init( TSupSysContext *context, 
    TSupSysInfo *info );
#endif

/*!
 * \ingroup oscar_internal
 * \brief      
 * \sa #TSupSysFunctionTable, #TSupSysFunctionTableItem
 */
static const TSupSysFunctionTableItem OSCAR_FUNS[] =
{
    {SUPSYS_FUN_NICKNAME, oscar_info_nickname},
    { SUPSYS_FUN_NAME, oscar_info_name },
    { SUPSYS_FUN_INSTANCE, ric_info_instance },
    { SUPSYS_FUN_CONTEXT_DUP, ric_context_dup },
    { SUPSYS_FUN_CONTEXT_FREE, ric_context_free },
    { SUPSYS_FUN_IDS_BLOCK, oscar_info_ids },
    { SUPSYS_FUN_VERSIONSUPPORT, info_versionsupport},
#if defined _WIN32
    { SUPSYSW_FUN_PROPERTY_INIT, oscar_property_init },
    { SUPSYSW_FUN_PROPERTY_DONE, base_property_done },
    { SUPSYSW_FUN_WIZARD_INIT, oscar_wizard_init },
    { SUPSYSW_FUN_WIZARD_ATTACH, base_wizard_attach },
    { SUPSYSW_FUN_WIZARD_DONE, base_wizard_done },
#endif

    { SUPSYS_FUN_REGISTER, oscar_register },
    { SUPSYS_FUN_UNREGISTER, ric_unregister },
    
    { READER_FUN_GET_PARAM, ric_get_param },
    { READER_FUN_AUTH_INFO, ric_get_auth_info },
    { READER_FUN_PASSWORD_TYPE, ric_get_password_type },
    
    { RSCARD_FUN_CONNECT_CARRIER, ric_connect_carrier },

    { READER_FUN_UNIQUE_GET, ric_unique_get },

    { READER_FUN_FOLDER_OPEN, ric_folder_open },

    { READER_FUN_LOGOUT, ric_logout },
    { READER_FUN_SIMPLE_LOGIN_ASCII, ric_login },

    { READER_FUN_OPEN, ric_file_open },
    { READER_FUN_CLOSE, ric_file_close },
    { READER_FUN_PASSWD_CHANGE_ASCII, ric_passwd_change },

    { READER_FUN_READ, ric_file_read },
    { READER_FUN_WRITE, ric_file_write },
    { READER_FUN_CHSIZE, ric_file_chsize },
    { READER_FUN_LENGTH, ric_file_size },
};

/*!
 * \ingroup oscar_internal
 * \brief    .
 * \sa #TSupSysFunctionTable, #TSupSysFunctionTableItem, 
 */
static const TSupSysFunctionTable OSCAR_TABLE =
{
    sizeof( OSCAR_FUNS ) / sizeof( TSupSysFunctionTableItem ),
    OSCAR_FUNS
};

/*!
 * \ingroup ric_external
 * \brief      .
 * \sa #rdr_register_all, #TSupSysExportFunction
 * \return      .
 * \internal    #OSCAR_TABLE
 */
const TSupSysEHandle *
    oscar_media_get_table( void )
{
    return (const TSupSysEHandle*)&OSCAR_TABLE;
}

#if defined( _WIN32 )
DWORD oscar_property_init(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    return base_property_init( context, info, PF_APPLICATION, OSCAR_PATH_CFG, _TEXT( "oscar" ) );
}

DWORD oscar_wizard_init(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    return base_wizard_init( context, info, 
	PF_APPLICATION,
	_TEXT( "0000000000000043525950544F5052" ),
	_TEXT( "00000000000000FFFFFFFFFFFFFFFF" ),
	_TEXT( "0B00" ),
	OSCAR_PATH_CFG,
	_TEXT( "oscar" )
	);
}
#endif
