/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/****
 * $Id: rdr_prj.h 282204 2024-11-27 16:55:34Z dedal $
 *
 *       (READER).
 *
 *     (RDR).
 *
 *  include    (READER/RDR).
 *
 *     READER/RDR.
 *
 *    define: 
 *
 * : _WIN32
 ****/

#if !defined( _READER_RDR_RDR_PRJ_H )
#define _READER_RDR_RDR_PRJ_H

#include "reader.kit/gen_prj.h"

/*+ Windows +*/
#if defined _WIN32 && defined _USRDLL

/*+ Std include. +*/
#include <process.h>

#include <windowsx.h> /*+ Windows include. +*/
#include <CommCtrl.h>

#endif /* _WIN32 && _USRDLL */

#include "reader/sup_syse.h"

//   ,       release:
#if defined IOS
#  define DB_ERROR CONS
#  define DB_TRACE CONS
#  define DB_WARN CONS
#  define DB_CALL CONS
#  define DB_LOG CONS
#else // IOS
#  define DB_ERROR ERRO
#  define DB_TRACE NORM
#  define DB_WARN NORM
#  define DB_CALL NORM
#  define DB_LOG NORM
#endif // IOS

#include "reader/dprint2.h"
#include "reader.kit/sup_sys.h"
#include "reader.kit/sup_lst.h"
#if !defined UNIX
#include "reader/sup_sysw.h"
#endif /* UNIX */

#include "cpcsp/WinCryptEx.h"
#include "reader/rdr.h"
#if defined _USRDLL && defined _WIN32
#include "reader/rdr_wnd.h"
#endif /* _USRDLL && _WIN32 */

#include "reader.kit/reader.h"
     
#include "sup_rc.h"	   /*  .    */

/* ,  CODE  ,      . 
 CODE        -  1 .
    rdr-   return.
*/
#define LOGRETURN(CODE)\
do {DWORD temp = (CODE);\
    DbTrace(DB_CALL, (FTEXT(db_ctx, "res: 0x%x"), (temp))); \
    return (temp);\
}while(0)

#endif /* _READER_RDR_RDR_PRJ_H */
