/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 287439 $
 * \date $Date:: 2025-02-23 18:10:36 +0300#$
 * \author $Author: fomichev $
 * \brief  . ,  ,   .
 */

#if !defined( _READER_RDR_H )
#define _READER_RDR_H

#include "reader/rdr_indie.h"

/* **** **** ,    **** **** */
#if defined( __cplusplus )
extern "C" {
#endif /* defined( __cplusplus ) */

 /*!  
 * \ingroup Reader_RDR_12
 * \brief   /  . 
 *
 *         /
 *      /,  ,    /     
 * /.    ,    ,      
 *     /.
 *           ,    /.
 *  /      \ref rdr_unlock .
 *
 * \param context [in]  .
 * \param carrier_ctx [in]  .
* \return \ref reader_errors
* \sa \ref rdr_lock, \ref rdr_unlock
* 
 */
 DWORD rdr_lock(TSupSysEContext *context, const TProvCallCtx * carrier_ctx);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief    /.  
 *
 *     \ref rdr_lock    ,   .
 *     ,         ,    .
 *
 * \param context [in]  .
* \return 
* \sa \ref rdr_lock, \ref rdr_unlock
* 
 */
 void rdr_unlock(TSupSysEContext *context);

#if defined( _WIN32 ) 
 /*!  
 * \ingroup Reader_RDR_12
 * \brief    
*
* \param context [in]  .
* \param s_info [in]    .
* \param p_sec_descr [in]  . 
* \param out_error [out]  
* \sa \ref rdr_set_sec_descr, \ref rdr_get_sec_descr
* 
 */
 DWORD rdr_set_sec_descr(
     TSupSysEContext *context,
     SECURITY_INFORMATION s_info,
     PSECURITY_DESCRIPTOR p_sec_descr);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief    
*
* \param context [in]  .
* \param s_info [in]    .
* \param p_sec_descr [in]  .  
* \param sec_descr_len [out]   .
* \sa \ref rdr_set_sec_descr, \ref rdr_get_sec_descr
* 
 */
 DWORD rdr_get_sec_descr(
     TSupSysEContext *context,
     SECURITY_INFORMATION request_info,
     PSECURITY_DESCRIPTOR p_sec_descr,
     DWORD * sec_descr_len);
#endif /*_WIN32 */

/* ****    . **** */
 /*!  
 * \ingroup Reader_RDR_12
 * \brief    /.
 *
 * \param context [in]  .
 * \param applet_count [out]    ()  .     "" 
 *       0.
* \return \ref reader_errors
* \sa \ref  rdr_disconnect_carrier
* 
*/ 
 DWORD rdr_connect_carrier(
    TSupSysEContext *context, unsigned int * applet_count );

 /*!
* \ingroup Reader_RDR_12
* \brief   /.
*
* \param context [in]  .
* \param applet_count [out]    (),   . 
* \return \ref reader_errors
* \sa \ref  rdr_connect_carrier
*
*/
 DWORD rdr_format_carrier(
     TSupSysEContext* context, unsigned int* applet_count);
 
 /*!  
 * \ingroup Reader_RDR_12
 * \brief   ()  .
 *
 * \param context [in]  .
 * \param app_num [in]  ,   .    ,   0,   
 *          ,       ,  
 *         .
* \return \ref reader_errors
 * \sa \ref #rdr_connect_carrier
 * 
 */
 DWORD rdr_select_applet(TSupSysEContext *context, unsigned app_num);
 
 /*!  
 * \ingroup Reader_RDR_12
 * \brief      .
 *
 * \param context [in]  .
 * \param text_info_length [in/out]       .
 * \param text_info [out]     .   NULL     text_info_length.
* \return \ref reader_errors
* \sa \ref rdr_get_applet_text_info
* 
 */
 DWORD rdr_get_applet_text_info(
     const TSupSysEContext *context, size_t * text_info_length, TCHAR * text_info);


/*!
* \ingroup Reader_RDR_12
* \brief    
*
*     .    
*    ,      
*   .     \ref rdr_term_application,
*     .
* \param context [in]  
* \return \ref reader_errors
* \sa \ref rdr_connect_carrier
* 
*/
 DWORD rdr_disconnect_carrier( 
    TSupSysEContext *context );

 

/*!
* \ingroup Reader_RDR_12
* \brief  local machine.
*
*      .
* \param context [in]  
* \param local_machine [in] 1    local_machine, 0
*   .
* \return \ref reader_errors
* \sa \ref rdr_local_machine
* 
*/
 DWORD rdr_local_machine(
    TSupSysEContext *context, int local_machine );


 /*!
  * \ingroup Reader_RDR_12
  * \brief    .       .
  *
  * \param context [in]  .
  * \param permissions [out]   DWORD,    .
  * \return \ref reader_errors
  * \sa \ref
  *
  */
 DWORD rdr_get_license_permissions(const TSupSysEContext *context, unsigned * permissions);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief     .
 *
 * \param context [in]  .
 * \param length [in/out]   -  ,      unique.  ,     ((length + 1) * sizeof(TCHAR)).
 *   -     ,    ,    phrase,    ,   ,
 *       NULL.
 * \param unique [out] ,      .
* \return \ref reader_errors
* \sa \ref  
* 
*/
 DWORD rdr_unique_get(
     const TSupSysEContext *context, size_t *length, TCHAR *unique);

 /*!
 * \ingroup Reader_RDR_12
 * \brief    ,  .
 *
 * \param context [in]  .
 * \param length [in/out]   -  ,      name.  ,     ((length + 1) * sizeof(TCHAR)).
 *   -     ,    ,    phrase,    ,   ,
 *       NULL.
 * \param name [out] ,    ,  
 * \sa \ref
 *
 */
 DWORD rdr_get_user_defined_name(
     const TSupSysEContext *context,
     size_t *length,
     TCHAR *name);

/* ****    PIN-(   ). **** */
 
/*!
* \ingroup Reader_RDR_12
* \brief      
*
*    .    EKE
*    .
*
* \param context [in]  
* \param auth_type [in] ,    (, , )
* \param auth_alg [out]    (EKE, SIMPLE,  ..)
* \return \ref reader_errors
* \sa rdr_password_type
* _fkc
*/
 DWORD rdr_password_type(
     const TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrLoginInfoType * auth_alg);

/*!  
 * \ingroup Reader_RDR_12
 * \brief    .
 *
 * \param context [in]  .
 * \param passwd [in] PUK   TCHAR-,  _T('\0').
 * \param retries [out]    .        .        !
 * \param auth_type [in] AUTH_TYPE_PUK -   PUK; AUTH_TYPE_ROOT -     ; AUTH_TYPE_CONT -     ; AUTH_TYPE_USER_PIN1 -    1;
 * AUTH_TYPE_USER_PIN2 -   2.
* \return \ref reader_errors
* \sa \ref rdr_login_ex
* 
*/
 DWORD rdr_login_ex(
     TSupSysEContext *context, TRdrLoginInfoType auth_type, const char *passwd, int *retries);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief      .
 *
 * \param context [in]  .
 * \param auth_type [in] AUTH_TYPE_PUK -   PUK; AUTH_TYPE_ROOT -     ; AUTH_TYPE_CONT -     ; AUTH_TYPE_USER_PIN1 -    1;
 * AUTH_TYPE_USER_PIN2 -   2.
 * \return \ref reader_errors
 * \sa  \ref rdr_logout, \ref rdr_folder_open
 * 
 */
 DWORD rdr_self_login_ex(TSupSysEContext *context, TRdrLoginInfoType auth_type);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief      .
 *
 * \param context [in]  .
 * \param auth_type [in] AUTH_TYPE_PUK -   PUK; AUTH_TYPE_ROOT -     ; AUTH_TYPE_CONT -     ; AUTH_TYPE_USER_PIN1 -    1;
 * AUTH_TYPE_USER_PIN2 -   2.
 * \return \ref reader_errors
 * \sa \ref rdr_self_change
 * 
 */
 DWORD rdr_self_change(TSupSysEContext *context, TRdrLoginInfoType auth_type);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief        
 *
 * \param context [in]  .
 * \return \ref reader_errors
 * \sa \ref rdr_restore_default_login
 */
 DWORD rdr_restore_default_login(TSupSysEContext *context);

/*!
* \ingroup Reader_RDR_12
* \brief    .
*
*       \ref rdr_term_application. 
*      , 
* SCARD_E_UNSUPPORTED_FEATURE.
* \param context [in]  
* \sa \ref rdr_logout
*/
 DWORD rdr_logout(TSupSysEContext *context);
 

/*!
 * \ingroup Reader_RDR_12
 * \brief C     .
 *
 *   \ref rdr_term_passwd  \ref rdr_term_application.
 *
 *      ,    
 *   .
 *       ,     .
 * ,      .
 * \param context [in]  .
 * \param auth_type [in]  ,   .
 * \param new_passwd [in]  .   NULL,  
 * \param set_auth_type [in]  ,   .
 * \param set_passwd [in] ,     auth_type.
 * \param retries [out]    set_auth_type.
 *  .        ,
 *  ..        NULL   
 *   ,    ,    
 *      .
 * \return \ref reader_errors
 * \sa \ref  rdr_passwd_default_set,
 *
 */
 DWORD rdr_auth_change(
     TSupSysEContext *context, TRdrLoginInfoType auth_type, const char *new_passwd, TRdrLoginInfoType set_auth_type, const char *set_passwd);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief      .
 *
 * \param context [in]  .
 * \param auth_type [in] AUTH_TYPE_PUK -  PUK; AUTH_TYPE_ROOT -    ; AUTH_TYPE_CONT -    ; AUTH_TYPE_USER_PIN1 -   1;
 * AUTH_TYPE_USER_PIN2 -  2.
 * \param length [in/out]   -  ,      phrase.  ,     ((length + 1) * sizeof(TCHAR)).
 *   -     ,    ,    phrase,    ,   ,
 *       NULL.
 * \param phrase [out]  .
 * \return \ref reader_errors
 * \sa \ref  rdr_folder_open
 * 
*/

 DWORD rdr_passwd_phrase(
     TSupSysEContext *context, TRdrLoginInfoType auth_type, size_t *length, TCHAR *phrase);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief       .
 *
 * \param context [in]  .
 * \param auth_type [in] AUTH_TYPE_PUK -  PUK; AUTH_TYPE_ROOT -    ; AUTH_TYPE_CONT -    ; AUTH_TYPE_USER_PIN1 -   1;
 * AUTH_TYPE_USER_PIN2 -  2.
 * \return \ref reader_errors
 * \sa \ref rdr_clear_tries
 * 
 */
 DWORD rdr_clear_tries(TSupSysEContext *context, TRdrLoginInfoType auth_type);

 /* ****     . **** */

  /*!  
 * \ingroup Reader_RDR_12
 * \brief     .
 *
 * \param context [in]  /.
 * \param auth_type [in] AUTH_TYPE_ROOT -        ; AUTH_TYPE_CONT -    .
 * \param counters [out] .
 * \param has_counters [out]   .
 * \return \ref reader_errors
 * \sa \ref rdr_get_sespake_counters
 * 
 */
 DWORD rdr_get_sespake_counters(const TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrFkcSespakeCounters counters, BOOL* has_counters);


 /*!  
 * \ingroup Reader_RDR_12
 * \brief    .
 *
 * \param context [in]  /.
 * \param auth_type [in] AUTH_TYPE_ROOT -   ,    .
 * \return \ref reader_errors
 * \sa \ref rdr_get_auth_state
 */
 DWORD rdr_get_auth_state(const TSupSysEContext *context, TRdrLoginInfoType auth_type);

 /*!
* \ingroup Reader_RDR_12
* \brief     .
*
* \param context [in]  /.
* \param type [out]   .
* \param algid [out]  .
* \param cipher_mode [out]  .
* \param imit_key_algid [out]  ,     .
* \return \ref reader_errors
* \sa \ref rdr_get_sm_params
*
*/
 DWORD rdr_get_sm_params(const TSupSysEContext* context, TRdrFkcSecureMessagingType* type, unsigned int* algid, DWORD* cipher_mode, unsigned int* imit_key_algid, BOOL* padding);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief     .
 *
 * \param context [in]  /.
 * \param security_level [out]  .
 * \return \ref reader_errors
 * \sa \ref rdr_get_container_level
 * 
 */
 DWORD rdr_get_container_level(const TSupSysEContext *context, DWORD * security_level);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief      .
 *
 * \param context [in]  /.
 * \param flag [in]  .
 * \param value [out]  .
 * \return \ref reader_errors
 * \sa \ref rdr_get_support_flag
 * 
 */
 DWORD rdr_get_support_flag(const TSupSysEContext *context, size_t flag, int * value);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief       
 *
 * \param context [in]  /.
 * \param algid_array [out]     
 * \param size_algid_array [in/out]  .
 * \return \ref reader_errors
 * \sa \ref rdr_get_userkey_algids
 * 
 */
 DWORD rdr_get_userkey_algids(TSupSysEContext *context, TRdrFkcEllipticPointParam * algid_array, size_t * size_algid_array);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief   OID. 
 *
 * \param context [in]  /.
 * \param oids [out]   asciiz-,   -
 * \return \ref reader_errors
 * \sa \ref rdr_get_userkey_algids
 * 
 */
 DWORD rdr_get_oids(TSupSysEContext* context, TSupSysMultiStringAsciiText* oids);
 
 /*!  
 * \ingroup Reader_RDR_12
 * \brief       
 *
 * \param context [in]  /.
 * \param auth_type [in] ,     
 * \param algid_array [out]     
 * \param size_algid_array [in/out]  .
 * \return \ref reader_errors
 * \sa \ref rdr_get_sespake_algids
 * 
 */
 DWORD rdr_get_sespake_algids(TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrFkcEllipticPointParam * algid_array, size_t * size_algid_array);

 /*!
 * \ingroup Reader_RDR_12
 * \brief     RSA  
 *
 * \param context [in]  /.
 * \param min_key_bits [out]   RSA  
 * \param max_key_bits [out]   RSA  
 * \param key_bits_increment [out]   min_key_bits,     ; 0      min  max
 * \return \ref reader_errors
 * \sa \ref rdr_get_available_rsa_length
 *
 */
 DWORD rdr_get_available_rsa_length(TSupSysEContext *context, DWORD * min_key_bits, DWORD* max_key_bits, DWORD* key_bits_increment);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief     SESPAKE
 *
 * \param context [in]  /.
 * \param auth_type [in]  ,     (, , )
 * \param auth_id [out]   .
 * \param salt [out]   salt.
 * \param ind [out]   ind,  .
 * \param dont_use_mq [out]   m/q   
 * \param prehash [out]    
 * \return \ref reader_errors
 * \sa \ref rdr_get_sespake_full
 * 
 */ 
 DWORD rdr_get_sespake_full(TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrFkcEllipticPointParam * auth_id, TRdrFkcRndm12 salt, BYTE * ind, BOOL* dont_use_mq, BOOL * prehash);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief     SESPAKE. 
 *
 *  r, salt, ind   Qpw    ,        (Qpw   ).
 *             ,    ,   Qpw.    Qpw 
 *      .           .       ( . 
 *        )       auth_id.  auth_id    .     APDU 
 *       ( ).
 * \param context[in]   / .
 * \param auth_type [in]  ,     (, , )
 * \param auth_id [int]   .
 * \param salt [in]   salt.
 * \param ind [in]   ind,  .
 * \param Qpw [in]  Qpw,  .
 * \return \ref reader_errors
 * \sa \ref rdr_set_sespake_full
 * 
 */
 DWORD rdr_set_sespake_full(TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrFkcEllipticPointParam auth_id, TRdrFkcRndm12 salt, BYTE ind, TRdrFkcPoint * Qpw);

   /*!  
 * \ingroup Reader_RDR_12
 * \brief     SESPAKE
 *
 * \param context [in]  /.
 * \param auth_type [in] AUTH_TYPE_ROOT -    ; AUTH_TYPE_CONT -      ..
 * \param transaction_id [in]    SESPAKE.     ,   .
 * \param u1 [in]  .
 * \param u2 [out]  .
 * \param ukm [out]  ukm.
 * \return \ref reader_errors
 * \sa \ref rdr_sespake_first_step
 * 
 */
 DWORD rdr_sespake_first_step(TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrFkcTrID transaction_id, TRdrFkcPoint * u1, TRdrFkcPoint *u2);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief     SESPAKE
 *
 * \param context [in]  /.
 * \param auth_type [in] AUTH_TYPE_ROOT -    ; AUTH_TYPE_CONT -      ..
 * \param transaction_id [in]   SESPAKE.    ,      ,   .
 * \param hmacA [in] HMA_A   SESPAKE.  .
 * \param hmacB [out]   HMAC_B.  -.
 * \return \ref reader_errors
 * \sa \ref rdr_sespake_second_step
 * 
 */
 DWORD rdr_sespake_second_step(TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrFkcTrID transaction_id, BYTE * hmacA, BYTE * hmacB);

/* ****      . **** */

/*!
* \ingroup Reader_RDR_12
* \brief    
* \param context [in]  
* \param enum_ctx [out]   
* \param folder_length [out]       
*  ,    0.
* \param prototype [in]       ,
*        NULL.
* \param flags   
* \return \ref reader_errors
* \sa \ref   rdr_folder_enum_next,  rdr_folder_enum_close
* 
*/
 DWORD rdr_folder_enum_open(
    const TSupSysEContext *context, 
    TRdrFolderEnumContext **enum_ctx,
    size_t *folder_length,
    const TCHAR *prototype,
    unsigned flags );

/*!
* \ingroup Reader_RDR_12
* \brief   
* \param enum_ctx [in]   
* \param folder [out]  ;       + 1
*      .
* \return \ref reader_errors
* \sa \ref    rdr_folder_enum_open,  rdr_folder_enum_close
* 
*/
 DWORD rdr_folder_enum_next(
    TRdrFolderEnumContext *enum_ctx,
    TCHAR *folder );

/*!
* \ingroup Reader_RDR_12
* \brief    
* \param enum_ctx [out]   
* \return \ref reader_errors
* \sa \ref    rdr_folder_enum_open,  rdr_folder_enum_next
* 
*/
 DWORD rdr_folder_enum_close(
    TRdrFolderEnumContext *enum_ctx );
 
/*!
* \ingroup Reader_RDR_12
* \brief        
* \param enum_ctx [out]   
* \return \ref reader_errors
* \sa \ref   rdr_folder_enum_open,  rdr_folder_enum_next
* 
*/
 DWORD rdr_get_default_folder(
     TSupSysEContext *context, 
     TCHAR * def_name, 
     size_t max_len );

 /*!  
 * \ingroup Reader_RDR_12
 * \brief     .
 *
 * \param context [in]  /.
 * \param name [in]  .
 * \return \ref reader_errors
 * \sa \ref rdr_set_default_folder
 * 
 */
 DWORD rdr_set_default_folder(
     TSupSysEContext *context, 
     TCHAR * name);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief      .
 *
 * \param context [in]  /.
 * \param free_space   
 * \return \ref reader_errors
 * \sa \ref rdr_get_free_space
 * 
 */
 DWORD rdr_get_free_space(
     TSupSysEContext* context,
     size_t* free_space);
/*!
* \ingroup Reader_RDR_12
* \brief  
* \param context [in]  
* \param mode [in]   .   :
*  - <code>"r"</code>  
*  - <code>"w"</code>   
* \param folder [in]  
* \return \ref reader_errors
* \sa \ref   rdr_folder_close,  rdr_folder_open
* 
*/
 DWORD rdr_folder_open(
    TSupSysEContext *context, 
    BOOL create,
    const TCHAR *folder );

/*!
* \ingroup Reader_RDR_12
* \brief  
*
*      .  
*      ,      
*   .       ,  
*   \ref rdr_term_file.
*     folder   ,    SCARD_E_CARD_UNSUPPORTED.
* \param context [in]  
* \return \ref reader_errors
* \sa \ref    rdr_folder_open,  rdr_folder_close
* 
*/
 DWORD rdr_folder_close(
    TSupSysEContext *context );


/*!
* \ingroup Reader_RDR_12
* \brief  
*
*  .
* \param context [in]  
* \return \ref reader_errors
* \sa \ref rdr_folder_clear
* 
*/
 DWORD rdr_folder_clear(
     TSupSysEContext *context);

/* ****    . **** */

/*!
* \ingroup Reader_RDR_12
* \brief  
*
*          
*   .
* \param context [in/out]  
* \param mode [in]   .   :
*  - <code>"r"</code> <code>O_RDONLY</code>
*  - <code>"w"</code> <code>O_CREAT | O_WRONLY | O_TRUNC</code>
*  - <code>"wp"</code> <code>O_PRIVATE | O_CREAT | O_WRONLY | O_TRUNC</code>
*  - <code>"r+"</code> <code>O_RDWR</code>
*  - <code>"w+"</code> <code>O_RDWR | O_CREAT | O_TRUNC</code>
*  - <code>"wp+"</code> <code>O_PRIVATE | O_RDWR | O_CREAT | O_TRUNC</code>
*  .
*  <p> 
*  - \c O_RDONLY    
*  - \c O_WRONLY    
*  - \c O_RDWR     
*  - \c O_IGNORE  
*  - \c O_CREATE  ,     \c O_TRUNC
*      ,    ,  
*    \ref reader_errors  (DWORD)NTE_EXISTS.
*    ,       0.
*  - \c O_TRUNC    ,    
*         .  
*   ,        
*           ,  
*        \c O_TRUNC   
*   .
*  - \c O_PRIVATE       .
*  .
* \param fileno [in]   .   
*         
*  \c 0,      
*     \c NULL.
* \return \ref reader_errors
* \sa \ref rdr_file_open
* 
*/
 DWORD rdr_file_open(
    TSupSysEContext *context, const char *mode,  TRdrFileNumber filno );

/*!
* \ingroup Reader_RDR_12
* \brief  .
*
*     .     ,  
*    .
*   
* \param context [in]  
* \return \ref reader_errors
* \sa \ref rdr_file_close,  rdr_file_open
* 
*/
 DWORD rdr_file_close(
    TSupSysEContext *context );

/*!
* \ingroup Reader_RDR_12
* \brief   
*
*   \a size   ,   \a context
*     \a pos   \a buffer.
*
*      ,   
*  .
*
*      .
* - ,      ,  
*     o_trunc     
*       .
*
*       ,   .
* \param context [in]  
* \param pos [in]   
* \param size [in]   
* \param buffer [in]  
* \param writen [out]   .   NULL,
*        .
* \return \ref reader_errors
* \sa \ref rdr_file_write
* 
*/
 DWORD rdr_file_write(
    TSupSysEContext *context, size_t pos, size_t size, const void *buffer,
    size_t *writen );

/*!
* \ingroup Reader_RDR_12
* \brief   
*
*   \a size   ,   \a context
*     \a pos   \a buffer.
*
*      ,   
*  .
* \param context [in]  
* \param pos [in]   
* \param size [in]   
* \param buffer [out]  
* \param read [out]   .   NULL,
*        .
* \return \ref reader_errors
* \sa \ref rdr_file_read
* 
*/
 DWORD rdr_file_read(
    TSupSysEContext *context, size_t pos, size_t size, void *buffer,
    size_t *rfread );

/*!
* \ingroup Reader_RDR_12
* \brief  .
*
*     ,    ,
*      .
* \param context [in]  
* \param size [out]  
* \return \ref reader_errors
* \sa \ref rdr_file_length
* 
*/
 DWORD rdr_file_length(
    TSupSysEContext *context, size_t *size );

/*!
* \ingroup Reader_RDR_12
* \brief       
*
*    .     ,
*    \ref reader_errors     .
*        ,     
*     .
* \param context [in]  
* \param size [in,out] in -   , out -  
*    
* \return \ref reader_errors
* \sa \ref rdr_file_chsize
* 
*/
 DWORD rdr_file_chsize(
    TSupSysEContext *context, size_t *size );

/*!
* \ingroup Reader_RDR_12
* \brief  .
*
*
*      ,   
*  .
* \param context [in]  
* \param fileno [in]   .     
*         
*  \c 0,      
*     \c NULL.
* \return \ref reader_errors
* \sa \ref rdr_file_unlink
* 
*/
 DWORD rdr_file_unlink(
    TSupSysEContext *context, TRdrFileNumber rffileno );

 /* ****    . **** */

 /*!  
 * \ingroup Reader_RDR_12
 * \brief      .
 *
 * \param context [in]  /.
 * \param auth_type [in]  ,       .
 * \param exist [out] TRUE,       , FALSE .
 * \return \ref reader_errors
 * \sa \ref rdr_exist_default_password
 * _fkc */
 DWORD rdr_exist_default_password(
     const TSupSysEContext *context, DWORD auth_type, BOOL * exist);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief     . 
 *
 * \param context [in]  /.
 * \param auth_type [in]  
 * \param password [out]    .
 * \param max_length [in]  ,     .
 * \return \ref reader_errors
 * \sa \ref rdr_get_default_password
 * _fkc 
 */
 DWORD rdr_get_default_password(
    const TSupSysEContext *context, DWORD auth_type, char * password, size_t max_length);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief    .
 *
 * \param context [in]  /.
 * \param flags [out] .
 * \return \ref reader_errors
 * \sa \ref rdr_get_fkc_flags
 * _fkc 
 */
 DWORD rdr_get_fkc_flags(const TSupSysEContext *context, TRdrFkcCarrierFlags * flags);

  /*!  
 * \ingroup Reader_RDR_12
 * \brief    .
 *
 * \param context [in]  /.
 * \param flags [out] .
 * \return \ref reader_errors
 * \sa \ref rdr_get_universal_flags
 * _fkc 
 */
 DWORD rdr_get_universal_flags(const TSupSysEContext *context, TRdrUniversalCarrierFlags * flags);

 /*!
 * \ingroup Reader_RDR_12
 * \brief     /.
 *
 * \param context [in]  /.
 * \param flags [out] .
 * \return \ref reader_errors
 * _fkc
 */
 DWORD rdr_get_hardware_store_flags(const TSupSysEContext *context, DWORD* hardware_flags);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief    .
 *
 * \param context [in]  .
 * \param auth_flags [out]    ,    AUTH_FLAG_TYPE_...
 * \return \ref reader_errors
 * \sa \ref rdr_all_password_flags
 * _fkc 
 */
 DWORD rdr_all_password_flags(const TSupSysEContext *context, DWORD * auth_flags);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief    .
 *
 * \param context [in]  .
 * \param param_type [in]   
 * \param pbData [in]    
 * \param dwData [in]    
 * \return \ref reader_errors
 * \sa \ref rdr_set_container_param
 * _fkc */
 DWORD rdr_set_container_param(const TSupSysEContext *context, TRdrFkcFolderEnumParam param_type, BYTE * pbData, DWORD dwData);

 /*!
 * \ingroup Reader_RDR_12
 * \brief  ,    (  ).
 *
 * \param context [in]  .
 * \param hardware_flags [in]  
 * \return \ref reader_errors
 * _fkc */
 DWORD rdr_set_hardware_store_flags(const TSupSysEContext *context, DWORD hardware_flags);
 

/*
*  ,   
*/

 /*!  
 * \ingroup Reader_RDR_12
 * \brief        ( 1).
 *
 * \param context [in]  /.
 * \param masked_key [in]   ,      2^32.
 * \param key_length [in]   .
 * \param public_key [in]    .
 * \param uiIDg [in]    .
 * \param oid [in] OID    .
 * \param alg_type [in] ,    .
 * \param is_able_dh [in]   .
 * \param permissions [in]  .
 * \param index [in]    .
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_simple_key_set_step1
 * _fkc 
 */
 DWORD rdr_crypt_simple_key_set_step1(
     TSupSysEContext *context, 
     TRdrFkcOrder masked_key,
     DWORD key_length,
     TRdrFkcPoint* public_key,
     TRdrFkcEllipticPointParam uiIDg,
     char * oid,
     TKeyAlgType alg_type,
     DWORD key_type, 
     BOOL is_able_dh,
     unsigned int alg_id,
     DWORD permissions, 
     int index
 );
 
 /*!  
 * \ingroup Reader_RDR_12
 * \brief        ( 2).
 *
 * \param context [in]  /.
 * \param mask [in]   .
 * \param key_length [in]   .
 * \param public_key [in]    .
 * \param uiIDg [in]    .
 * \param oid [in] OID    .
 * \param alg_type [in] ,    .
 * \param is_able_dh [in]   .
 * \param permissions [in]  .
  * \param index [in/out]    .   0 -      , 1 -  .  
 *      .         .
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_simple_key_set_step2
 * _fkc
 */
 DWORD rdr_crypt_simple_key_set_step2(
     TSupSysEContext *context, 
     TRdrFkcOrder mask, DWORD key_length, 
     TRdrFkcPoint* public_key, 
     TRdrFkcEllipticPointParam uiIDg, 
     char * oid,
     TKeyAlgType alg_type, 
     DWORD key_type, 
     BOOL is_able_dh,
     unsigned int alg_id, 
     DWORD permissions,
     int* index
 );

 /*!
 * \ingroup Reader_RDR_12
 * \brief     
 *
 * \param context [in]  /.
 * \param key_type [in] AT_KEYEXCHANGE/AT_SIGNATURE
 * \param alg_id [out]   
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_get_public_key, \ref rdr_crypt_get_public_key_oid \ref rdr_crypt_get_key_permissions
 * _fkc
 */
 DWORD rdr_crypt_get_key_algid(TSupSysEContext *context, DWORD key_type, unsigned int *alg_id);

 /*!
 * \ingroup Reader_RDR_12
 * \brief     RSA
 *
 * \param context [in]  /.
 * \param key_type [in] AT_KEYEXCHANGE/AT_SIGNATURE
 * \param public_key [out]   RSA
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_get_public_key_param, \ref rdr_crypt_get_public_key_oid
 * _fkc
 */
 DWORD rdr_crypt_get_rsa_public_key(TSupSysEContext *context, DWORD key_type, TRdrFkcRsaKey *public_key);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief    
 *
 * \param context [in]  /.
 * \param key_type [in] AT_KEYEXCHANGE/AT_SIGNATURE
 * \param public_key [out]  
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_get_public_key_param, \ref rdr_crypt_get_public_key_oid
 * _fkc
 */
 DWORD rdr_crypt_get_public_key(TSupSysEContext *context, DWORD key_type, TRdrFkcPoint* public_key);

 /*!
 * \ingroup Reader_RDR_12
 * \brief     2001 .
 *
 * \param context [in]  /.
 * \return \ref reader_errors
 * _fkc
 */
 DWORD rdr_crypt_set_gost_2001(TSupSysEContext *context);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief    
 *
 * \param context [in]  /.
 * \param key_type [in] AT_KEYEXCHANGE/AT_SIGNATURE
 * \param alg_id [out]   
 * \param idG [out]   
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_get_public_key, \ref rdr_crypt_get_public_key_oid \ref rdr_crypt_get_key_permissions
 * _fkc
 */
 DWORD rdr_crypt_get_public_key_param(TSupSysEContext *context, DWORD key_type, unsigned int * alg_id, TRdrFkcEllipticPointParam * idG);

 /*!
 * \ingroup Reader_RDR_12
 * \brief       DH.
 *
 * \param context [in]  /.
 * \param key_type [in] AT_KEYEXCHANGE/AT_SIGNATURE
 * \param is_able_dh [out]  
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_get_public_key, \ref rdr_crypt_get_public_key_oid, \ref rdr_crypt_get_public_key_param \ref rdr_crypt_get_key_permissions
 * _fkc
 */
 DWORD rdr_crypt_get_able_dh(TSupSysEContext *context, DWORD key_type, BOOL * is_able_dh);

 /*!
 * \ingroup Reader_RDR_12
 * \brief   OIDa 
 *
 * \param context [in]  /.
 * \param key_type [in] AT_KEYEXCHANGE/AT_SIGNATURE
 * \param oid [out] OID  .    ,      CSTR.
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_get_public_key_param, \ref rdr_crypt_get_public_key \ref rdr_crypt_get_key_permissions
 * _fkc
 */
 DWORD rdr_crypt_get_public_key_oid(TSupSysEContext *context, DWORD key_type, char * oid);

 /*!
 * \ingroup Reader_RDR_12
 * \brief    
 *
 * \param context [in]  /.
 * \param key_type [in] AT_KEYEXCHANGE/AT_SIGNATURE
 * \param permissions [out]  .
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_get_public_key_param, \ref rdr_crypt_get_public_key \ref rdr_crypt_get_public_key_oid
 * _fkc
 */
 DWORD rdr_crypt_get_key_permissions(TSupSysEContext *context, DWORD key_type, DWORD * permissions);

/*!  
 * \ingroup Reader_RDR_12
 * \brief     .
 *
 * \param context [in]  /.
 * \param uiIDg [in]    .
 * \param oid [in] OID    .
 * \param alg_type [in] ,    .
 * \param add_random_data [in]     .
 * \param random_length [in]    .
 * \param index [in/out]    .   0 -      , 1 -  .  
 *      .         .
 * \param pubKey [out]   .
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_simple_key_gen 
 * _fkc
 */
 DWORD rdr_crypt_simple_key_gen(
     TSupSysEContext *context, 
     TRdrFkcEllipticPointParam uiIDg, 
     char * oid,
     TKeyAlgType alg_type, 
     DWORD key_type, 
     BOOL is_able_dh,
     unsigned int alg_id, 
     const BYTE * add_random_data, DWORD random_length, DWORD permissions, 
     int* index,
     TRdrFkcPoint * pubKey
 );

 /*!
 * \ingroup Reader_RDR_12
 * \brief   RSA   .
 *
 * \param context [in]  /.
 * \param rsa_len [in]    RSA  .
 * \param alg_type [in] ,    .
 * \param add_random_data [in]     .
 * \param random_length [in]    .
 * \param index [in/out]    .   0 -      , 1 -  .  
 *      .         .
 * \param pubKey [out]    RSA.
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_simple_key_gen
 * _fkc
 */
 DWORD rdr_crypt_simple_rsa_key_gen(TSupSysEContext *context, DWORD rsa_len, long public_exp, DWORD key_type,
     BOOL is_able_dh, unsigned int alg_id, const BYTE *add_random_data, DWORD random_length,
     DWORD permissions, int *index, TRdrFkcRsaKey *pubKey);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief    .
 *
 * \param context [in]  /.
 * \param index [in]     .
 * \param point_Qalpha [in]  ,  .
 * \param coord_length [in]    .
 * \param ukm [in]  , ukm.
 * \param ukm_length [in]  UKM.
 * \param mask [in]  ,   .
 * \param mask_length [in]  .
 * \param key [out]  .
 * \param key_length [in/out]     /  
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_agreement
 * _fkc
 */
 DWORD rdr_crypt_agreement(
TSupSysEContext *context,
 int index,
 DWORD key_type, 
const TRdrFkcPoint *point_Qalpha,
 size_t coord_length, 
const TRdrFkcUKM ukm, 
size_t ukm_length, 
TRdrFkcOrder mask, 
size_t mask_length,
 TRdrFkcOrder key, 
size_t * key_length);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief  .
 *
 * \param context [in]  /.
 * \param index [in]     .
 * \param hash_ctx [in]   .  ,      .
 * \param hash [in]  ,  big-endian
 * \param r, s [out] ,  big-endian  .
 * \param r_length, s_length [out]     .
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_signature
 * 
 */
 DWORD rdr_crypt_signature(TSupSysEContext *context, int index, DWORD key_type, TRdrHashContext * hash_ctx, TRdrFkcOrder hash, size_t hash_length, TRdrFkcOrder r, size_t * r_length, TRdrFkcOrder s, size_t * s_length);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief       RSA.
 *
 * \param context [in]  /.
 * \param index [in]     .
 * \param key_type [in]   (AT_KEYEXCHANGE/AT_SIGNATURE).
 * \param hash_ctx [in]   .  ,      .
 * \param hash_length [in]    .       0.
 * \param in_data [in]   ( / ),  big-endian.
 * \param out_data [out]   ( RSA/ ),  big-endian.
 * \param data_length [in/out]  /    (  RSA).
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_rsa_exptmod
 * 
 */
 DWORD rdr_crypt_rsa_exptmod(TSupSysEContext* context, int index, DWORD key_type, TRdrHashContext* hash_ctx,
     size_t hash_length, DWORD hash_alg, const BYTE* in_data, BYTE* out_data, size_t data_length);

/*!
 * \ingroup Reader_RDR_12
 * \brief      .
 *
 * \param context [in]  /.
 * \param transaction_id [in]   .
 * \param index [in]     .
 * \param hash_ctx [in]   .  ,      .
 * \param hash [in]  ,  big-endian
 * \param r, s [out] ,  big-endian  .
 * \param r_length, s_length [out]     .
 * \param w [out]   w
 * \param w_length [out]    w
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_signature, \ref rdr_crypt_weak_signature_2
 *
 */
 DWORD rdr_crypt_weak_signature_1(TSupSysEContext *context, TRdrFkcTrID transaction_id, int index, DWORD key_type, TRdrHashContext * hash_ctx, TRdrFkcOrder hash, size_t hash_length, TRdrFkcOrder r, size_t * r_length, TRdrFkcOrder s, size_t * s_length, TRdrFkcOrder w, size_t * w_length);
 
 /*!
 * \ingroup Reader_RDR_12
 * \brief      .
 *
 * \param context [in]  /.
 * \param transaction_id [in]   .
 * \param l [in]  ,  
 * \param l_length [in]    l  .
 * \param index [in]    .
 * \param v [out]   v
 * \param v_length [out]    v
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_signature, \ref rdr_crypt_weak_signature_1
 *
 */
 DWORD rdr_crypt_weak_signature_2(TSupSysEContext *context, TRdrFkcTrID transaction_id, TRdrFkcOrder l, size_t l_length, int index, TRdrFkcOrder v, size_t * v_length);


 /*!  
 * \ingroup Reader_RDR_12
 * \brief    .
 *
 * \param context [in]  /.
 * \param hash_algid [in]  .
 * \param hash_ctx [out]    .
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_hash_init
 * 
 */
 DWORD rdr_crypt_hash_init(TSupSysEContext *context, unsigned int hash_algid, TRdrHashContext ** hash_ctx);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief   .
 *
 * \param context [in]  /.
 * \param hash_ctx [in]  .
 * \param data [in]   .
 * \param data_len [in]    .
 * \param hashed_data_len [out]   .
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_hash_data
 * 
 */
 DWORD rdr_crypt_hash_data(TSupSysEContext *context, TRdrHashContext * hash_ctx, const void * data, size_t data_len, size_t * hashed_data_len);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief   .
 *
 * \param context [in]  /.
 * \param hash_ctx [in]  .
 * \param buffer [out]    .
 * \param buffer_len [in/out]    ,    .
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_hash_getval
 * 
 */
 DWORD rdr_crypt_hash_getval(TSupSysEContext *context, TRdrHashContext * hash_ctx, void * buffer, size_t * buffer_len);

 
 /*!  
 * \ingroup Reader_RDR_12
 * \brief    .
 *
 * \param context [in]  /.
 * \param hash_ctx [in]   .
 * \return \ref reader_errors
 * \sa \ref rdr_crypt_hash_destroy
 * 
 */
 DWORD rdr_crypt_hash_destroy(TSupSysEContext *context, TRdrHashContext * hash_ctx);

/*!
* \ingroup Reader_RDR_12
* \brief    .
*
*       .
* \param context [in]  
* \param length [in/out] in -      ;
out -       
* \param out [out]    NULL     
* \return \ref reader_errors
* \sa \ref rdr_get_random
* 
*/
 DWORD rdr_get_random(TSupSysEContext *context, size_t *length, BYTE *out);

 /*!  
 * \ingroup Reader_RDR_12
 * \brief       SM- 
 *
 * \param context [in]  
 * \param isSM [in]    
 * \param auth_typs [in]   
* \sa \ref rdr_set_sm_state
* 
*/
 DWORD rdr_set_sm_state(TSupSysEContext *context, BOOL isSM, TRdrLoginInfoType auth_type);

/*!
* \ingroup  Reader_RDR_12
* \brief    .
*
*     .
* \param list [out]  ()  .
* \return \ref reader_errors
* \sa \ref rdr_register_start
* 
*/
DWORD rdr_register_start(TSupSysEList **list);

/*!
* \ingroup  Reader_RDR_12
* \brief    .
*
*      .
* \param list [in/out]   .
* \param reader [in]  .
* \return \ref reader_errors
* \sa \ref rdr_register_start
*
*/
DWORD rdr_register_one(TSupSysEList *list, const TCHAR *reader);

DWORD rdr_register_one_ext(TSupSysEList *list, const TCHAR *reader, unsigned flags);

/*!
* \ingroup  Reader_RDR_12
* \brief   .
*
*      .
* \param list [in/out]   .
* \return \ref reader_errors
* \sa \ref rdr_register_start
*
*/
DWORD rdr_register_all(TSupSysEList *list);

/*!
* \ingroup  Reader_RDR_12
* \brief       .
*
*     .
* \param list [in/out]   .
* \param flags [in] , ,     .
* \return \ref reader_errors
* \sa \ref rdr_register_start
*
*/
DWORD rdr_register_all_ext(TSupSysEList *list, unsigned flags);

/*!
* \ingroup Reader_RDR_12
* \brief    .
*
*     .
* \param list [out]  ()  .
* \return \ref reader_errors
* \sa \ref rdr_media_register_start
* 
*/
DWORD rdr_media_register_start(TSupSysEList **list);

/*!
* \ingroup Reader_RDR_12
* \brief     .
*
*   \ref rdr_term_conext    
*  :
*  -   
*  -   
*  -     .
*  .
* \param list [in]  
* \param context [out]    
* \return \ref reader_errors
* \sa \ref rdr_context_default_set
* 
*/
DWORD rdr_context_default_get(const TSupSysEList *list, TSupSysEContext **context);

/*!
* \ingroup Reader_RDR_12
* \brief     .
*
*   \ref rdr_term_conext  
*    .
* \param context [in]    
* \return \ref reader_errors
* \sa \ref rdr_context_default_get
* 
*/
DWORD rdr_context_default_set(const TSupSysEContext *context);

/*!
* \ingroup Reader_RDR_12
* \brief    .
* \param context [in]  .
* \param carrier_type [in]   .
* \return \ref reader_errors
* \sa rdr_info_carrier_type
* 
*/
DWORD rdr_info_carrier_type(const TSupSysEContext *context, TSupSysNickname carrier_type);

/*!
* \ingroup Reader_RDR_12
* \brief    .
*
* \param context [in]  .
* \param length [in/out]   .
* \param name [out]  .
* \return \ref reader_errors
* \sa rdr_connect_current
*
*/
DWORD rdr_connect_current(const TSupSysEContext *context, size_t *length, TCHAR *name);

/*!
 * \ingroup Reader_RDR_12
 * \brief      
 *    
 * \param context [in]  
 * \param length [in/out] in -   , 
 *    ; out -     
 *  .         
 * \param name [out]   NULL     
 * \param connect [in]  ,   NULL.
 */
DWORD rdr_default_internal_register_name(const TSupSysEContext *context, size_t *length, TCHAR *name, const TCHAR *ssconnect);


/* ****    . **** */

/*!
* \ingroup Reader_RDR_12
* \brief     .
*
* \param context [in]  .
* \param auth_type [in]  ,     (ROOT  CONT).
* \param min_password_length [out]   .
* \param max_password_length [out]   .
* \param retries [out]      .
* \return \ref reader_errors
* \sa rdr_get_password_info
* 
*/
DWORD rdr_get_password_info(const TSupSysEContext *context, DWORD auth_type, size_t * min_password_length, size_t * max_password_length, size_t * retries, BOOL * isUtf8);


/*!
* \ingroup Reader_RDR_12
* \brief    .
*
* \param context [in]  .
* \param auth_type [in] AUTH_TYPE_PUK -  PUK; AUTH_TYPE_ROOT -    ; AUTH_TYPE_CONT -    ; AUTH_TYPE_USER_PIN1 -   1;
* AUTH_TYPE_USER_PIN2 -  2.
* \param length [in/out]  .
* \param min_length [out]  . "-", "PUK"  ..
* \return \ref reader_errors
* \sa \ref rdr_folder_open
* 
*/
DWORD rdr_passwd_term(const TSupSysEContext *context, TRdrLoginInfoType auth_type, size_t *length, TCHAR *term);

/*!
* \ingroup Reader_RDR_12
* \brief     ( )
*
* \param context [in]  
* \param passwd_length [in,out]
*  in -   , 
*    ; out -     .
*          .
* \param passwd [out] 
* \return \ref reader_errors
* \sa \ref rdr_passwd_default_clear,
*  #rdr_passwd_default_set, #rdr_connect_carrier
* 
*/
DWORD rdr_passwd_default_get(const TSupSysEContext *context, BOOL is_local_machine, TCHAR * carrier_type, TCHAR * unique, TCHAR * folder, size_t *passwd_length, TCHAR *passwd);


/*!
* \ingroup Reader_RDR_12
* \brief     ( )
*
*   \ref rdr_term_passwd   .
*
* \param context [in]  .
* \param passwd [in] ,     "", 
*     NULL.
* \return \ref reader_errors
* \sa \ref  #rdr_passwd_default_clear, #rdr_passwd_default_get,
*  #rdr_connect_carrier
* 
*/
DWORD rdr_passwd_default_set(const TSupSysEContext *context, BOOL is_local_machine, TCHAR * carrier_type, TCHAR * unique, TCHAR * folder, const TCHAR *passwd);

/*!
* \ingroup Reader_RDR_12
* \brief     ( )
*
* \param context [in]  .
* \return \ref reader_errors
* \sa \ref  #rdr_passwd_default_get, #rdr_passwd_default_set
* 
*/
DWORD rdr_passwd_default_clear(const TSupSysEContext *context, BOOL is_local_machine, TCHAR * carrier_type, TCHAR * unique, TCHAR * folder);

/*       . */
DWORD rdr_passwd_default_clear_all(int machine);

/*!
* \ingroup Reader_RDR_12
* \brief     .
*
* \param context [in]  /.
* \param car_ctx [in]  ,   
* \param callbacks [in]   .
* \return \ref reader_errors
*/
DWORD rdr_set_provider_callbacks(const TSupSysEContext *context, TProvCallCtx car_ctx, const TCarrierCallbacks * callbacks);

#if defined( __cplusplus )
}
#endif /* defined( __cplusplus ) */

#endif /* !defined( _READER_RDR_H ) */
/* end of file:Id: rdr.h,v 1.40 2001/01/22 09:42:09 cav Exp  */
