/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

#include "fat12prj.h"
#include "Win32/fat12_rc.h"

static const TSupSysInfoIDSBaseItem HDIMAGE_IDS_ITEMS[] = 
{
    { SUPSYS_IDS_BLOCK_BASE, IDS_HDIMAGE_NAME, SUPSYS_IDS_BASE_QUANT_V2 },
    { SUPSYS_IDS_BLOCK_ICON, IDI_HDIMAGE, SUPSYS_IDS_ICON_QUANT_V1 },
    { READER_IDS_BLOCK, IDS_HDIMAGE_INSERT_TEXT, READER_IDS_QUANT_V1 }
};

/*!
 * \ingroup fat12_internal
 * \brief     HDIMAGE
 */
static const TSupSysInfoIDSBase HDIMAGE_IDS = 
{
    sizeof( HDIMAGE_IDS_ITEMS ) / sizeof( TSupSysInfoIDSBaseItem ),
    HDIMAGE_IDS_ITEMS
};

/*!
 * \ingroup hdimage_fun_general
 * \brief      HDIMAGE
 * \param context [in]  .  .
 * \param info [out]  #TSupSysInfoIDSBase
 * \return  .
 * \retval #ERROR_SUCCESS   .
 * \retval #(DWORD)ERROR_INVALID_PARAMETER   
 */
DWORD hdimage_info_ids(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    UNUSED( context );

    SUPSYS_PRE_INFO( info, TSupSysInfoIDSBase );
    memcpy( info, &HDIMAGE_IDS, sizeof( TSupSysInfoIDSBase ) );
    return ERROR_SUCCESS;
}

DWORD hdimage_get_text_info(TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoText * inf = (TSupSysInfoText *)info;
#ifndef _WIN32
    const TCHAR * applet_info = _TEXT("Use HDD file system as key storage.");
    UNUSED(context);
    if (!inf->text) {
	inf->length = _tcslen(applet_info);
	return 0;
    }
    if (inf->length < _tcslen(applet_info)) {
	inf->length = _tcslen(applet_info);
	return (DWORD)ERROR_MORE_DATA;
    }
    _tcscpy(inf->text, applet_info);
    inf->length = _tcslen(applet_info);
    return 0;
#else //_WIN32
    UNUSED(context);
    return support_resource_string(FAT12_DLL_INSTANCE, IDS_HDIMAGE_INFO, inf->text, &inf->length);
#endif //_WIN32
}
