/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/****
 * $Id: fat12.c 261561 2023-09-14 13:50:44Z a.sokolov $
 *
 *       (READER).
 *
 *   /      (FAT12).
 *
 *       FAT12.
 *
 * : fat12_*
 *
 ****/

#include "fat12prj.h" /*+ Project (READER/FAT12) include.
     include    (READER/FAT12). +*/

/*++++
 *           Windows.
 ++++*/
DWORD fat12_os_error_inside(void)
/*+
 * :   Windows  .
 +*/
{
#if defined _WIN32
    DWORD w = GetLastError();
    SetLastError(0);
    switch (w) {
	/*+ 0 -> ERROR_SUCCESS +*/
	case 0:
	    return ERROR_SUCCESS;
	    /*+ ERROR_FILE_NOT_FOUND -> (DWORD)ERROR_FILE_NOT_FOUND +*/
	case ERROR_PATH_NOT_FOUND:
	case ERROR_FILE_NOT_FOUND:
	    return (DWORD)ERROR_FILE_NOT_FOUND;
	    /*+ ERROR_WRONG_DISK -> (DWORD)SCARD_W_REMOVED_CARD +*/
	case ERROR_WRONG_DISK:
	    return (DWORD)SCARD_W_REMOVED_CARD;
	    /*+ ERROR_NOT_ENOUGH_MEMORY -> (DWORD)NTE_NO_MEMORY +*/
	case ERROR_NOT_ENOUGH_MEMORY:
	    return (DWORD)NTE_NO_MEMORY;
	    /*+ ERROR_WRITE_PROTECT -> (DWORD)ERROR_WRITE_PROTECT +*/
	case ERROR_WRITE_PROTECT:
	    return (DWORD)SCARD_E_READ_ONLY_CARD;
	    /*+ ERROR_REQUEST_ABORTED, ERROR_NOT_READY -> (DWORD)SCARD_W_REMOVED_CARD +*/
	case ERROR_REQUEST_ABORTED:
	    return (DWORD)SCARD_W_CANCELLED_BY_USER;
	case ERROR_INVALID_HANDLE:
	case ERROR_NOT_READY:
	    return (DWORD)SCARD_W_REMOVED_CARD;
	    /*+ ERROR_INVALID_DRIVE, ERROR_ACCESS_DENIED, ERROR_SHARING_VIOLATION
	    ERROR_LOCK_VIOLATION, ERROR_DRIVE_LOCKED, ERROR_BUSY ->
	    (DWORD)SCARD_E_READER_UNAVAILABLE +*/
	case ERROR_ACCESS_DENIED:
	    return (DWORD)NTE_PERM;
	case ERROR_INVALID_DRIVE:
        case ERROR_LOCK_VIOLATION:
        case ERROR_DRIVE_LOCKED:
        case ERROR_BUSY:
            return (DWORD)SCARD_E_READER_UNAVAILABLE;
        case ERROR_SHARING_VIOLATION:
            return (DWORD)ERROR_CONTINUE;
	case ERROR_FILE_INVALID:
	    return (DWORD)SCARD_E_NOT_READY;
	case ERROR_DISK_FULL:
	case ERROR_HANDLE_DISK_FULL:
	case ERROR_CANNOT_MAKE:
	    return (DWORD)NTE_TOKEN_KEYSET_STORAGE_FULL;
	case ERROR_ALREADY_EXISTS:
	case ERROR_FILE_EXISTS:
	    return (DWORD)NTE_EXISTS;
    }
    /*+ otherwise  -> (DWORD)SCARD_W_UNSUPPORTED_CARD+*/
    return (DWORD)SCARD_W_UNSUPPORTED_CARD;
#else /* _WIN32 */
    switch (errno) {
	/*+ 0 - ERROR_SUCCESS +*/
	case 0:
	    return ERROR_SUCCESS;

	    /*+ ENOMEM, ECONTR, EINVMEM - (DWORD)NTE_NO_MEMORY +*/
	case ENOMEM:
	    return (DWORD)NTE_NO_MEMORY;

	    /*+ ENOFILE, ENOPATH, EACCES, ENOTSAM, ENOENT - (DWORD)SCARD_W_REMOVED_CARD +*/
	case ENOENT:
	case ENOTDIR:
	case EISDIR:
	case EACCES:
	    return (DWORD)ERROR_FILE_NOT_FOUND;
	case EROFS:
	    return (DWORD)SCARD_E_READ_ONLY_CARD;

	    /*+ EINVDRV, EINVACC - (DWORD)SCARD_E_READER_UNAVAILABLE +*/
	case EMFILE:
	case ENOSPC:
	case ENFILE:
	    return (DWORD)SCARD_E_READER_UNAVAILABLE;
    }
    return (DWORD)SCARD_W_UNSUPPORTED_CARD;
    /*+ otherwise  -> (DWORD)SCARD_W_UNSUPPORTED_CARD+*/
#endif /* _WIN32 */
}

DWORD fat12_os_error(void) {
    DWORD err = fat12_os_error_inside();
    if (err == (DWORD)ERROR_CONTINUE)
        return (DWORD)SCARD_E_READER_UNAVAILABLE;
    return err;
}

/*+ end of file: $Id: fat12.c 261561 2023-09-14 13:50:44Z a.sokolov $ +*/
