/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

#include "fat12prj.h"

#if defined UNIX
/*
 *         UNIX.
 */
DWORD fat12_volume_name(
    const TCHAR *path, 
    TCHAR **name, 
    unsigned long *serial )
{
    UNUSED(path);

    *serial = (unsigned long)-1;
    *name = malloc(12 * sizeof(TCHAR));
    if(!*name)
	return (DWORD)NTE_NO_MEMORY;

    (*name)[0]=_TEXT('\0');
    return ERROR_SUCCESS;
}
#else // !UNIX
/*
 *         Windows Desktop.
 */
DWORD fat12_volume_name(
    const TCHAR *path, 
    TCHAR **name, 
    unsigned long *serial )
{
    DWORD code = ERROR_SUCCESS;
    DWORD maximumComponentLength; /*    . */
    DWORD fileSystemFlags; /*   . */

    *serial = (unsigned long)-1;
    *name = NULL;
    if( !GetVolumeInformation( path, NULL, 0, 
			       serial, &maximumComponentLength, &fileSystemFlags,
			       NULL, 0 ) ) {
	code=fat12_os_error();
	goto done;
    }
    *name = malloc( ( maximumComponentLength + 1 ) * sizeof( TCHAR ) );
    if( *name == NULL ){
	code=(DWORD)NTE_NO_MEMORY;
	goto done;
    }
    if( !GetVolumeInformation( path, *name, 
			       maximumComponentLength + 1 /*volume_name_size */, 
			       serial, &maximumComponentLength, &fileSystemFlags,
			       NULL, 0 ) ) {
	code=fat12_os_error();
	goto done;
    }

done:
    if(code!=ERROR_SUCCESS){
	*serial = (unsigned long)-1;
	free(*name);
	*name = NULL;
    }

    return code;
}
#endif // !UNIX

DWORD fat12_connect_carrier(TSupSysContext *context, TSupSysInfo *info)
{
    UNUSED(context);
    UNUSED(info);

    return ERROR_SUCCESS;
}
