/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

#include "fat12prj.h"
#include "os_specific.h"

static const TCHAR BASE_NAME_CFG[] = _TEXT("FAT12");

/*!
 * \ingroup fat12_info_general
 * \brief   .
 * \return  
 * \retval ERROR_SUCCESS  
 * \retval (DWORD)NTE_NO_MEMORY   
 */
DWORD fat12_register(TSupSysContext *context, TSupSysInfo *info)
{
    TFat12Context *ctx;
    TSupSysInfoRegister *inf = (TSupSysInfoRegister*)info;
    TCHAR * reg_path = NULL;
    size_t reg_length;

    UNUSED(context);

    SUPSYS_PRE_INFO(info, TSupSysInfoRegister);

    support_set_library(inf->support_module);

    ctx = calloc(1, sizeof(TFat12Context));
    if (ctx == NULL) {
	return (DWORD)NTE_NO_MEMORY;
    }
    if (inf->in_group_name.text) {
	TCHAR *ptr;
	_tcsncpy(ctx->nickname, inf->in_group_name.text, sizeof(ctx->nickname) / sizeof(TCHAR)-1);
	ctx->nickname[SUPSYSE_NICKNAME_LENGTH] = 0;
	ptr = _tcsrchr(inf->in_group_name.text, _TEXT('_'));
	if (ptr) {
	    ctx->connect[0] = ptr[1];
	}
	ctx->connect[1] = 0;
	reg_length = _tcslen(BASE_PATH_CFG) + 1 + _tcslen(BASE_NAME_CFG) + 1 + _tcslen(inf->in_group_name.text) + 1 + _tcslen(DEFAULT_CONNECT) + 1 + _tcslen(LONG_NAMES_KEY) + 1;
	reg_path = malloc(reg_length*sizeof(TCHAR));
	if (!reg_path) {
	    free(ctx);
	    return (DWORD)NTE_NO_MEMORY;
	}
	_sntprintf(reg_path, reg_length, _TEXT("%s\\%s\\%s\\%s\\%s"), BASE_PATH_CFG, BASE_NAME_CFG, inf->in_group_name.text, DEFAULT_CONNECT, LONG_NAMES_KEY);
    }
    else {
	reg_length = _tcslen(BASE_PATH_CFG) + 1 + _tcslen(BASE_NAME_CFG) + 1 + _tcslen(DEFAULT_CONNECT) + 1 + _tcslen(LONG_NAMES_KEY) + 1;
	reg_path = malloc(reg_length*sizeof(TCHAR));
	if (!reg_path) {
	    free(ctx);
	    return (DWORD)NTE_NO_MEMORY;
	}
	_sntprintf(reg_path, reg_length, _TEXT("%s\\%s\\%s\\%s"), BASE_PATH_CFG, BASE_NAME_CFG, DEFAULT_CONNECT, LONG_NAMES_KEY);
    }
    ctx->long_names = get_registry_long_names_flag(reg_path);
    free(reg_path);
    ctx->path = NULL;
    ctx->volume_label = NULL;
    ctx->file_name = NULL;
    ctx->folder = NULL;
    ctx->flags = 0;
#ifdef UNIX
    _tcscpy(ctx->lock_name, "fat12_lock");
    ctx->handle = NULL;
    if (open_named_mutex(ctx->lock_name, &ctx->lock )) {
	free(ctx);
	return (DWORD)SCARD_E_READER_UNAVAILABLE;
    }
    ctx->locked = FALSE;
#else /* UNIX */
    ctx->handle = INVALID_HANDLE_VALUE;
    ctx->access = 0;
#endif /* UNIX */
    inf->context = ctx;
    return ERROR_SUCCESS;
}

DWORD fat12_unregister(TSupSysContext *context, TSupSysInfo *info)
{
    TFat12Context *ctx = (TFat12Context*)context;
    UNUSED(info);

    if (ctx) {
#ifdef _WIN32
	LocalFree(ctx->pSD);
#endif //_WIN32
	free(ctx->path);
	free(ctx->path_to_item);
#ifdef UNIX
	delete_mutex(ctx->lock);
#endif //UNIX
	free(ctx);
    }
    return ERROR_SUCCESS;
}

BOOL get_registry_long_names_flag(TCHAR *path) {
    long l = 0;
    DWORD code = support_registry_get_long(path, &l);
    if (code || l == 0) return FALSE;
    return TRUE;
}
