/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

#include "fat12prj.h" /* Project (READER/FAT12) include.
     include    (READER/FAT12). */

/*++++ 
 *    . 
 ++++*/
DWORD fat12_read( 
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TReaderInfoRead *inf = (TReaderInfoRead*)info;
    TFat12Context *ctx = (TFat12Context*)context;

#ifdef UNIX
    size_t loc_read = 0;
    DWORD code;
#else /* UNIX */
    DWORD loc_read = 0;
    void *buffer = (void*)inf->info.info;
#endif /* UNIX */

    SUPSYS_PRE_CONTEXT( context, TFat12Context );
    SUPSYS_PRE_INFO( info, TReaderInfoRead );
    SUPSYS_PRE_WRITE_PTRS( inf->info.info, inf->info.length );

#ifdef UNIX
    if( fseek( ctx->handle, inf->from, SEEK_SET ) )
	return fat12_os_error();
    errno=0;
    loc_read = fread( inf->info.info, 1, inf->info.length, ctx->handle );
    if((code = fat12_os_error()))
	return code;
#else /* UNIX */
    if( ctx->handle == INVALID_HANDLE_VALUE )
	return (DWORD)SCARD_E_NOT_READY;
    SUPSYS_PRE( inf->from <= MAXLONG );
    if( SetFilePointer( ctx->handle, (long)inf->from, NULL, 
	FILE_BEGIN ) == INVALID_SET_FILE_POINTER )
	return fat12_os_error(); 
    SUPSYS_PRE( inf->info.length <= MAXLONG );
    if( !ReadFile( ctx->handle, buffer, (long)inf->info.length, &loc_read, 
	NULL ) )
	return fat12_os_error();
#endif /* UNIX */
    inf->info.length -= loc_read;
    return ERROR_SUCCESS;
}

/*+ end of file: $Id: f12kread.c 118717 2015-04-14 16:16:50Z sagafyin $ +*/
