/*
 * Copyright(C) 2007  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 246196 $
 * \date $Date:: 2022-08-30 14:58:29 +0300#$
 * \author $Author: borodin $
 * \brief    .
 */

#include "fat12prj.h"

DWORD fat12_info_nickname( 
    TSupSysContext *context, TSupSysInfo *info )
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    DWORD err;
    SUPSYS_PRE_INFO( info, TSupSysInfoNickname );

    if (context) {
	TFat12Context* ctx = (TFat12Context*)context;
	SUPSYS_PRE_CCONTEXT(context, TFat12Context);
	_tcscpy(inf->nickname, ctx->nickname);
	err = ERROR_SUCCESS;
    }
    else {
	err = ERROR_NOT_SUPPORTED;
    }
    return err;
}

DWORD dir_info_group_nickname(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    SUPSYS_PRE_INFO(info, TSupSysInfoNickname);
    UNUSED(context);

    size_t resource_len = SUPSYSE_NICKNAME_LENGTH; //  1 ,   .
    return support_resource_string(FAT12_RESOURCE, IDS_DIR_GROUP_NICKNAME, inf->nickname, &resource_len);
}

/* ,    -   nickname     PNP DIR,    group_nickname - DIR*/
DWORD dir_info_group_group_nickname(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    SUPSYS_PRE_INFO(info, TSupSysInfoNickname);
    UNUSED(context);

    size_t resource_len = SUPSYSE_NICKNAME_LENGTH; //  1 ,   .
    return support_resource_string(FAT12_RESOURCE, IDS_DIR_NICKNAME, inf->nickname, &resource_len);
}
