/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 192094 $
 * \date $Date:: 2019-04-15 12:56:16 +0300#$
 * \author $Author: frolov $
 * \brief      .
 */

#include "fat12prj.h" 
#include "Win32/fat12_rc.h"

/*! 
 * \ingroup hdimage_fun_reader
 * \brief      .
 *
 *    ,    .
 * \param context [in]  . 
 * \param info [in/out]  #TReaderInfoFolderEnum
 * \sa #TReaderInfoFolderEnum, #READER_FUN_FOLDER_ENUM_OPEN, 
 *  #TSupSysFunction, #fat12_info_folder_enum_close, #fat12_info_folder_enum_next,
 * \return  
 */

DWORD fat12_get_password_type(TSupSysContext *context, TSupSysInfo *info) {
    TRdrLoginInfoType * type = (TRdrLoginInfoType*)info;
    UNUSED(context);

    if ((*type & AUTH_TYPE_TYPE_MASK) == AUTH_TYPE_TYPE_CONT)
	*type = AUTH_TYPE_TYPE_CONT | AUTH_TYPE_AUTH_NO;
    else
	return ERROR_INVALID_PARAMETER;

    return ERROR_SUCCESS;
}

DWORD fat12_get_param(TSupSysContext *context, TSupSysInfo *info) {
    TReaderFkcFolderEnumParam paramID;
    TReaderInfoGetParam * inf = (TReaderInfoGetParam*)info;
    TFat12Context *ctx = (TFat12Context *)context;
    DWORD code = ERROR_SUCCESS;

    UNUSED(context);

    paramID = inf->paramID;

    switch (paramID) {
	case TCEP_auth_types:
	    inf->info.auth_types = AUTH_FLAG_TYPE_CONT;
	    break;
	case TCEP_uni_flags:
	    inf->info.uni_flags.folders = 1;
	    inf->info.uni_flags.long_names = ctx->long_names ? 1 : 0;
	    inf->info.uni_flags.can_create_folder = 1;
	    inf->info.uni_flags.functional_container = 0;
	    inf->info.uni_flags.premapped_files = 0;
	    break;
	default:
	    code = (DWORD)NTE_NOT_SUPPORTED;
	    break;
    }
    return code;
}

DWORD fat12_info_folder_enum_open(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TReaderInfoFolderEnum *inf = (TReaderInfoFolderEnum*)info;
    TCHAR *path;
    TFat12Context *ctx = (TFat12Context*)context;
    DWORD code;
    TFat12FolderEnumNew *folder_enum;
    size_t i;

    SUPSYS_PRE_INFO( info, TReaderInfoFolderEnum );
    SUPSYS_PRE_CONTEXT( context, TFat12Context );
    SUPSYS_PRE_STRING_PTR( ctx->path );

    if (ctx->long_names) {
	if ((TSupFileEnum*)inf->add_info.info)
	    support_closedir((TSupFileEnum*)inf->add_info.info);
	inf->add_info.info = NULL;
	code = support_opendir(ctx->path, &inf->name.length, (TSupFileEnum**)&inf->add_info.info);
	inf->add_info.length = sizeof(TSupFileEnum*);
	return code;
    }

    if( !( inf->flags & RDR_FOLDER_ENUM_FLAG_NEW ) )
    {
	code = support_opendir(ctx->path, &inf->name.length, (TSupFileEnum**)&inf->add_info.info);
	inf->add_info.length = sizeof(TSupFileEnum*);
	return code;
    }
    path = malloc( ( _tcslen( ctx->path ) + 2 + 12 + 2 ) * sizeof( TCHAR ) );
    if( path == NULL )
	return (DWORD)NTE_NO_MEMORY;
    _tcscpy( path, ctx->path );
    folder_enum = malloc( sizeof( TFat12FolderEnumNew ) );
    if( folder_enum == NULL )
    {
	free( path );
	return (DWORD)NTE_NO_MEMORY;
    }
    folder_enum->full_prefix = NULL;
    inf->add_info.length = sizeof( *folder_enum );
    inf->add_info.info = (unsigned char*)folder_enum;
    for( i = 0; i < 8 && inf->prototype.text[i]; i++ )
    {
	folder_enum->prefix[i] = fat12_convert( inf->prototype.text[i] );
	folder_enum->prefix[i + 1] = 0;
    }
    _tcscat( folder_enum->prefix, _TEXT( "." ) );
    folder_enum->num = 0;
    folder_enum->full_prefix = path;
    _tcscat( folder_enum->full_prefix, folder_enum->prefix );
    inf->name.length = 12;
    return ERROR_SUCCESS;
}

DWORD fat12_get_text_info(TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoText * inf = (TSupSysInfoText *)info;
#ifndef _WIN32
    const TCHAR * applet_info = _TEXT("Use HDD file system as key storage.");
    UNUSED(context);
    if (!inf->text) {
	inf->length = _tcslen(applet_info);
	return 0;
    }
    if (inf->length < _tcslen(applet_info)) {
	inf->length = _tcslen(applet_info);
	return (DWORD)ERROR_MORE_DATA;
    }
    _tcscpy(inf->text, applet_info);
    inf->length = _tcslen(applet_info);
    return 0;
#else //_WIN32
    UNUSED(context);
    return support_resource_string(FAT12_DLL_INSTANCE, IDS_FAT12_INFO, inf->text, &inf->length);
#endif //_WIN32
}
