/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 * \brief   .
 */

#include "fat12prj.h"
#ifdef UNIX
#include <unistd.h>
#endif /* UNIX */

/*!
 * \ingroup fat12_fun_reader
 * \brief   .
 * \param context [in]  . 
 * \param info [in/out]  #TReaderInfoFolderClear
 * \sa TReaderInfoFolderClear, READER_FUN_FOLDER_OPEN, 
 *  TSupSysFunction, fat12_folder_close, fat12_folder_open
 *  #rdr_folder_open, #rdr_folder_close, #rdr_folder_clear
 */
DWORD fat12_folder_clear( 
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TCHAR *path;
    TFat12Context *ctx = (TFat12Context*)context;
    UNUSED(info);
    SUPSYS_PRE_CONTEXT( context, TFat12Context );


    if( !ctx->folder )
	return ERROR_SUCCESS;

    path = (TCHAR*)malloc( ( _tcslen( ctx->folder ) 
	+ 2 + _tcslen( ctx->path )
	+ 1 ) * sizeof( TCHAR ) );
    if( path == NULL )
	return (DWORD)NTE_NO_MEMORY;
    _tcscpy( path, ctx->path );
    _tcscat( path, ctx->folder );
#ifdef UNIX
    if( _trmdir( path ) )
#else /* UNIX */
    if( !RemoveDirectory( path ) )
#endif /* UNIX */
    {
	DWORD code = fat12_os_error();
	free( path );
	free( ctx->folder ); ctx->folder = NULL;
	return code;
    }
    free( ctx->folder ); ctx->folder = NULL;
    free( path );

    return ERROR_SUCCESS;
}
/* end of file: $Id: f12dclr.c 127051 2015-09-09 12:08:20Z pav $ */
