/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 196556 $
 * \date $Date:: 2019-07-25 08:06:06 +0300#$
 * \author $Author: borodin $
 * \brief    .
 */

#include "fat12prj.h"

/*!
 * \ingroup hdimage_internal
 * \brief  .
 */
static unsigned char HDIMAGE_FLAGS_GENERAL[] = 
{ 
    0 << 7 
};

static unsigned char HDIMAGE_FLAGS_CONNECT[] = 
{
    0 << 7 /* SUPSYS_FLAG_CONNECT_MANY */
    | 0 << 6 /* SUPSYS_FLAG_CONNECT_COM */
    | 0 << 5 /* SUPSYS_FLAG_CONNECT_LPT */
    | 0 << 4 /* SUPSYS_FLAG_CONNECT_AUTO */
    | 0 << 3 /* SUPSYS_FLAG_CONNECT_MULTY */
    | 0 << 2 /* SUPSYS_FLAG_CONNECT_PNPGROUP */
};

static unsigned char EHDIMAGE_FLAGS_RDR[] = 
{
    TO_CP_FLAG(RDR_FLAG_RDR_REMOVABLE, 0) |
    TO_CP_FLAG(RDR_FLAG_RDR_UNIQUE, 0) |
    TO_CP_FLAG(RDR_FLAG_RDR_PROTECTED, 1) |
    TO_CP_FLAG(RDR_FLAG_RDR_VIRTUAL, 0)
};

/*! 
 * \ingroup hdimage_fun_general
 * \brief    .
 * \param context [in]  .  .
 * \param info [out]  #TReaderInfoSystemFlag
 * \sa #TReaderInfoSystemFlag, #READER_FUN_SYSTEM_FLAG, 
 *  #supsys_flag
 * \return  
 */
DWORD ehdimage_info_system_flag(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TSupSysInfoFlags *flags = (TSupSysInfoFlags*)info;
    size_t length;
    unsigned char *ptr = NULL;

    UNUSED( context );
    SUPSYS_PRE_INFO( info, TSupSysInfoFlags );
    SUPSYS_PRE( flags->type <= RDR_FLAG_BLOCK_RDR );
    SUPSYS_PRE( flags->type == RDR_FLAG_BLOCK_RDR
      || flags->type == SUPSYSE_FLAG_BLOCK_GENERAL
      || flags->type == SUPSYS_FLAG_BLOCK_CONNECT );
    length = flags->string.bits;
    if( flags->type == SUPSYSE_FLAG_BLOCK_GENERAL )
    {
	length = SUPSYSE_FLAG_GENERAL_VERSION_1;
	ptr = HDIMAGE_FLAGS_GENERAL;
    }
    if( flags->type == SUPSYS_FLAG_BLOCK_CONNECT )
    {
	length = SUPSYS_FLAG_CONNECT_VERSION_3;
	ptr = HDIMAGE_FLAGS_CONNECT;
    }
    if( flags->type == RDR_FLAG_BLOCK_RDR )
    {
	length = RDR_FLAG_RDR_VERSION_6;
	ptr = EHDIMAGE_FLAGS_RDR;
    }
    if( flags->string.string == NULL )
    {
	flags->string.bits = length;
	return ERROR_SUCCESS;
    }
    if( flags->string.bits > length )
	flags->string.bits = length;
    memcpy( flags->string.string, ptr, 
	flags->string.bits / 8 + ( (flags->string.bits % 8) ? 1 : 0 ) );
    flags->string.bits = length;
    return ERROR_SUCCESS;
}

/* end of file: $Id: ehdiflag.c 196556 2019-07-25 05:06:06Z borodin $ */
