/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2013  
 *
 *    , 
 *    .
 *
 *         
 *  ,     ,    , 
 *    : 
 *   1.        
 *           ,   
 *           . 
 *   2.        
 *           ,   
 *              / 
 *        ,   . 
 * 
 *        
 * /   "  "  -  , 
 *    , ,    , 
 *        
 *  .    ,     
 * ,      ,     
 *      ,    /  
 *  ,    ,  Ѩ 
 * ,   , ,   
 *  ,      
 *   (,     , 
 *  ,  ,    - 
 *    ,       
 *  ),         
 *     
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 59519 $
 * \date $Date: 2010-01-13 15:36:15 +0300 (Wed, 13 Jan 2010) $
 * \author $Author: dedal $
 *
 * \brief       
 * " KTLS"  Unix
 *
 */

#ifndef	DRTKTLS_IO_H
#define	DRTKTLS_IO_H

#include "cpcsp/csp_common.h"
#include "reader/support.h"
#include "WCKernelPart.h"
//#include "wincspc_int.h"

#ifndef CSP_LITE
# include <string.h>
# include <stdio.h>
#endif /* CSP_LITE */

#ifdef	__cplusplus
extern "C" {
#endif

#define MODNAME "drtktls"
#define SUPPORT_DBMAX 256

typedef enum {
    Version1_2 = 0x0102,
    Version2_0 = 0x0200
}   DRTKTLS_VERISON;

typedef enum {
    Drtcsp_RN_Daemon_Magic  = 0x6E6D6452,
    Drtcsp_RN_Driver_Magic  = 0x56524472,
    Drtcsp_KE_Session_Magic = 0x4B736553,
    Drtcsp_KE_OKSetSK_Magic = 0x74706D45
}   DRTKTLS_MAGIC;


#define MAX_MINORS 80
#define DRTKTLS_MAX_CHANNEL MAX_MINORS

#define DRTKTLS_ATTACH		0x01
#define DRTKTLS_OPEN		0x02
#define DRTKTLS_DRVRND_OK	0x04
#define DRTKTLS_DRVKEY_OK	0x08
#define DRTKTLS_SESKEY_OK	0x10

/*   */
typedef struct {
  size_t size;
  int minor;
  int state;
#if defined _KERNEL && defined SOLARIS
  dev_info_t     *dip;
#else
  void           *placeholder;
#endif
  PDRTKTLS_CTX pCtx;  
} DRTKTLS, *PDRTKTLS;

#define FROM_KERNEL 1
#define TO_KERNEL 2
extern int CPCAPI trans(unsigned char *data, size_t len, int dir, void *arg);
extern DWORD CPCAPI stdInitMemory(LPCPC_MEMORY_ARENA *pArena, LONG *PoolSizes, DWORD nPools);
extern void CPCAPI CPCSetLocks(LPCPC_CONFIG pConfig);

#ifdef	__cplusplus
}
#endif

#endif	/* DRTKTLS_IO_H */
