/*
 * Copyright(C) 2005-2011
 *
 * Этот файл содержит информацию, являющуюся
 * собственностью компании Крипто-Про.
 *
 * Любая часть этого файла не может быть скопирована,
 * исправлена, переведена на другие языки,
 * локализована или модифицирована любым способом,
 * откомпилирована, передана по сети с или на
 * любую компьютерную систему без предварительного
 * заключения соглашения с компанией Крипто-Про.
 *
 * This is proprietary information of
 * Crypto-Pro company.
 *
 * Any part of this file can not be copied, 
 * corrected, translated into other languages,
 * localized or modified by any means,
 * compiled, transferred over a network from or to
 * any computer system without preliminary
 * agreement with Crypto-Pro company
 */


#include "stdafx.h"
#include <cstdio>
#include "UnixRequestImpl.h"
#include "MSCAstdRequest.h"

// Начало примера (не следует удалять данный комментарий, он используется 
// для автоматической сборки документации)
//----------------------------------------------------------------------
// Пример кода для получения статуса запроса получения сертификата, 
// если в предыдущий раз были получены статусы, либо CR_DISP_INCOMPLETE, 
// либо CR_DISP_UNDER_SUBMISSION. Принимает в качестве параметра Id 
// запроса, который может быть получен из 
// /opt/cprocsp/src/samples/CSP/MSCA.
//----------------------------------------------------------------------


int main(int argc, char* argv[])
{
	UnixRequest * pRequest = 0;
	// URFactory - конструктор объекта взаимодействия с УЦ
	pRequest = UnixRequest::URFactory("MSCAstd");	
	HRESULT res = -1;	
	LONG pDisposition = 0;
	LONG Id = 0;
	FILE* IdFile = NULL;
        
	if (argc != 2)
	{
	    printf("file was not defined. \n\n");
	    delete pRequest;
	    return 1;
	}
        
	if ((IdFile = fopen(argv[1], "rb")) == NULL)
	{
	    printf("error open file. \n\n");
	    delete pRequest;
	    return 1;
	}
        
	size_t nread = fread(&Id, sizeof(LONG), 1, IdFile);
	if (nread != 1) {
	    printf("error reading file. \n\n");
	    fclose(IdFile);
	    delete pRequest;
	    return 1;
	}
	fclose(IdFile);
	printf("Id = %d\n\n", Id);
	BSTR strConfig = SysAllocString(L"http://vm-test-ca/certsrv");
	if (strConfig == NULL) {
	    printf("memory allocation error. \n\n");
	    delete pRequest;
	    return 1;
	}
	
	//--------------------------------------------------------------------
	// RetrievePending получает статус запроса в pDisposition
	res = pRequest->RetrievePending(Id, strConfig, &pDisposition);
	if (res != S_OK) {
		printf( "Error Retrieve Pending");
		SysFreeString(strConfig);
		delete pRequest;
		return 1;
	} else {
		switch (pDisposition) {
			case CR_DISP_DENIED:
				printf("request was denied. \n");
				break;
				
			case CR_DISP_ERROR:
				printf("error request. \n");
				break;

			case CR_DISP_INCOMPLETE:
				printf("request was incompleted\n");
				break;
			
			case CR_DISP_ISSUED:
				printf("certificate was issued. \n");
				break;
				
			case CR_DISP_ISSUED_OUT_OF_BAND:
	//Сертификат выдан (будет выдан) непосредственно на УЦ, а не по сети
				printf("certificate was issued out of band. \n");
				break;
				
			case CR_DISP_UNDER_SUBMISSION:
				printf("certificate is under submission. \n");
				break;	
			default:
				break;
		}
		printf("Successful RetrievePending. \n");
	}
	
	delete pRequest;
	SysFreeString(strConfig);	
	return 0;
}//end of main



//END-OF-FILE

