/*
* Copyright(C) 2000-2014
*
*    , 
*   .
*
*  ,    , 
*         
*   .
*
*     
*     .
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "cpcsp/WinCryptEx.h"

//   (    ,   
//    )
//-------------------------------------------------------------------------------------
//       .
//          
//     test_search.cer.     .
//-------------------------------------------------------------------------------------


BOOL CmpCertAndContFP(LPCSTR szContainerName, LPBYTE pbFPCert, DWORD cbFPCert);

static void HandleError(const char *s);

int main(int argc, char **argv) {

    //------------------------------------------------------------------------
    //  

    HCERTSTORE          hFileStore;	    //   
    PCCERT_CONTEXT      pCertCtx;	    //  
    HCRYPTPROV          hCryptProv;	    //  
    HCRYPTKEY           hPublicKey;	    //      
    LPBYTE		pbFPCert;	    //  FP   
    DWORD		cbFPCert;	    //   FP  
    LPBYTE		pbContainerName;    //  
    DWORD		cbContainerName;    //   
    DWORD		dwFlags;


    if (2 != argc)
    {
	HandleError("Wrong arguments!");
    }

    //------------------------------------------------------------------------
    //     

    if ((hFileStore = CertOpenStore(
	CERT_STORE_PROV_FILENAME_A,
	0,                        
	0,                     
	CERT_STORE_OPEN_EXISTING_FLAG,
	argv[1] //   
    )))
    {
	printf("The file store was created successfully.\n");
    }
    else
    {
	HandleError("An error occurred during creation of the file store!");
    }

    //------------------------------------------------------------------------
    //     

    if ((pCertCtx = CertEnumCertificatesInStore(hFileStore, NULL)))
    {
	printf("Certificate context was loaded from store.\n");
    }
    else 
    {
	HandleError("Error during CertEnumCertificatesInStore!");
    }


    //------------------------------------------------------------------------
    //   

    if (CryptAcquireContext(
	&hCryptProv,
	NULL,
	NULL,
	PROV_GOST_2012_256,
	CRYPT_VERIFYCONTEXT))
    {
	printf("CryptAcquireContext succeeded. \n");
    }
    else
    {
	HandleError("Error during CryptAcquireContext!");
    }


    //------------------------------------------------------------------------
    //      

    if (CryptImportPublicKeyInfo(
	hCryptProv,
	pCertCtx->dwCertEncodingType,
	&pCertCtx->pCertInfo->SubjectPublicKeyInfo,
	&hPublicKey))
    {
	printf("CryptImportPublicKeyInfo succeeded. \n");
    }
    else
    {
	HandleError("Error during CryptImportPublicKeyInfo!");
    }

    //------------------------------------------------------------------------
    //   KP_FP    

    //   
    if (CryptGetKeyParam(hPublicKey, KP_FP, NULL, &cbFPCert, 0))
    {
	printf("CryptGetKeyParam KP_FP succeeded. \n");
    }
    else 
    {
	HandleError("Error during CryptGetKeyParam!");
    }

    //  
    pbFPCert = (LPBYTE)malloc(cbFPCert);

    if (!pbFPCert)
    {
	HandleError("Fail to allocate memory!");
    }

    //  
    if (CryptGetKeyParam(hPublicKey, KP_FP, pbFPCert, &cbFPCert, 0))
    {
	printf("CryptGetKeyParam KP_FP succeeded. \n");
    }
    else
    {
	HandleError("Error during CryptGetKeyParam!");
    }


    //------------------------------------------------------------------------
    //    

    //   
    if (CryptGetProvParam(hCryptProv, PP_ENUMCONTAINERS, NULL, &cbContainerName, CRYPT_FIRST))
    {
	printf("CryptGetProvParam PP_ENUMCONTAINERS succeeded. \n");
    }
    else
    {
	HandleError("Error during CryptGetProvParam!");
    }

    //  
    pbContainerName = (LPBYTE)malloc(cbContainerName);

    if (!pbContainerName)
    {
	HandleError("Fail to allocate memory!");
    }

    //------------------------------------------------------------------------
    //   

    dwFlags = CRYPT_FIRST;
    while (CryptGetProvParam(hCryptProv, PP_ENUMCONTAINERS, pbContainerName, &cbContainerName, dwFlags | CRYPT_FQCN)) 
    {
	if (CmpCertAndContFP((LPCSTR)pbContainerName, pbFPCert, cbFPCert))
	{
	    printf("Container found! Name: '%s'\n", pbContainerName);
	    break;
	}
	dwFlags = CRYPT_NEXT;
    }
    

    //------------------------------------------------------------------------
    //  

    free(pbContainerName);

    free(pbFPCert);

    if (hFileStore) 
    {
	if (!CertCloseStore(hFileStore, CERT_CLOSE_STORE_FORCE_FLAG)) 
	{
	    HandleError("Error during CertCloseStore!");
	}
    }

    if (hPublicKey)
    {
	if (!CryptDestroyKey(hPublicKey))
	{
	    HandleError("Error during CryptDestroyKey!");
	}
    }

    if (hCryptProv)
    {
	if (!CryptReleaseContext(hCryptProv, 0))
	{
	    HandleError("Error during CryptReleaseContext!");
	}
    }

    return 0;
}

BOOL CmpCertAndContFP(LPCSTR szContainerName, LPBYTE pbFPCert, DWORD cbFPCert) {

    HCRYPTPROV          hProvCont;
    LPBYTE		pbFPCont;
    DWORD		cbFPCont;
    BOOL		result = FALSE;

    //------------------------------------------------------------------------
    //    

    if (CryptAcquireContextA(
	&hProvCont,
	szContainerName,
	NULL,
	PROV_GOST_2012_256,
	CRYPT_VERIFYCONTEXT))
    {
	printf("CryptAcquireContext for '%s' succeeded. \n", szContainerName);
    }
    else
    {
	HandleError("Error during CryptAcquireContext!\n");
    }

    //------------------------------------------------------------------------
    //   PP_SIGNATURE_KEY_FP    

    cbFPCont = cbFPCert; //  FP     FP  
    pbFPCont = (LPBYTE)malloc(cbFPCont);

    if (CryptGetProvParam(hProvCont, PP_SIGNATURE_KEY_FP, pbFPCont, &cbFPCont, 0))
    {
	printf("CryptGetProvParam PP_SIGNATURE_KEY_FP for '%s' succeeded. \n", szContainerName);
	//  FP    FP  
	if (!memcmp(pbFPCont, pbFPCert, cbFPCert)) {
	    result = TRUE;
	    goto Done;
	}
    }

    //------------------------------------------------------------------------
    //   PP_EXCHANGE_KEY_FP    

    if (CryptGetProvParam(hProvCont, PP_EXCHANGE_KEY_FP, pbFPCont, &cbFPCont, 0))
    {
	printf("CryptGetProvParam PP_EXCHANGE_KEY_FP for '%s' succeeded. \n", szContainerName);
	//  FP    FP  
	if (!memcmp(pbFPCont, pbFPCert, cbFPCert)) {
	    result = TRUE;
	    goto Done;
	}
    }

Done:

    free(pbFPCont);

    if (hProvCont)
    {
	if (!CryptReleaseContext(hProvCont, 0))
	{
	    HandleError("Error during CryptReleaseContext!");
	}
    }

    return result;
}

//  
// (    ,   
//     )

//       HandleError,  
//   ,         
//   (stderr)    . 
//         , 
//        .

static void HandleError(const char *s) {
    fprintf(stderr, "An error occurred in running the program. \n");
    fprintf(stderr, "%s\n", s);
    fprintf(stderr, "Error number %x.\n", GetLastError());
    fprintf(stderr, "Program terminating. \n");
    exit(1);
}
