#include <stdio.h>
#include <string.h>
#ifdef _WIN32
#   include <tchar.h>
#else
#   include <stdlib.h>
#   include "reader/tchar.h"
#endif
#include "cpcsp/WinCryptEx.h"

//   (    ,   
//    )
//--------------------------------------------------------------------
//        AT_KEYEXCHANGE 
//    .
//
//    ,   "Sender"  "Responder", 
//    ExportInFile, EncryptKey  DecryptKey  
//    .
//--------------------------------------------------------------------



#pragma region vars

#define BLOCK_LENGTH 4096
#define SALT_LENGTH 16

static void WriteBlobToFile(BYTE *pbData, DWORD cbData,char *FName);//!!!!!!!!!!!!!!!
static void HandleError(const char *s);
static void CleanUp(void);


static HCRYPTPROV hProv = 0;		//  CSP 
static HCRYPTKEY hKey = 0;		//      AT_EXCHANGE
static HCRYPTKEY hDerivedKey = 0;	//   
static HCRYPTHASH hHash = 0;		//   

static BYTE *pbKeyBlobExport = NULL;    //    BLOB     AT_EXCHANGE
static BYTE *pbIV = NULL;		//    

static CRYPT_DATA_BLOB salt = {0, NULL}; //  CRYPT_DATA_BLOB   


#pragma endregion

#define MAX_PUBLICKEYBLOB_SIZE 200

int main(void)
{
    DWORD dwKeyBlobExportLen;		//   BLOB  

    DWORD dwIV = 0;			//   
    ALG_ID ke_alg = CALG_PRO12_EXPORT;	//   

    char password[] = "password";   // 
    CRYPT_DATA_BLOB password_blob;  //  CRYPT_DATA_BLOB   
    password_blob.cbData = (DWORD)strlen(password);
    password_blob.pbData = (BYTE*)password;

    
    //       "Sender" 
    if(CryptAcquireContext(
	&hProv, 
	_TEXT("Sender"),
	NULL, 
	PROV_GOST_2012_256,
	0)) 
    {
	printf("The key container \"Sender\" has been acquired. \n");
    }
    else
    {
	HandleError("Error during CryptAcquireContext.");
    }

    //    .
    salt.cbData = SALT_LENGTH;
    salt.pbData = (BYTE*)malloc(salt.cbData);
    if (!salt.pbData)
	HandleError("Out of memory.");
    if (!CryptGenRandom(hProv, salt.cbData, salt.pbData)) {
	HandleError("CryptGenRandom failed.");
    }

    //    .
    WriteBlobToFile(salt.pbData, salt.cbData, "salt.bin");

    //----------------------------------------------------------------------------
    //  .
    //----------------------------------------------------------------------------

    //    .
    if (!CryptCreateHash(
	hProv,
	CALG_PBKDF2_2012_512,
	0,
	0,
	&hHash))
    {
	HandleError("CryptCreateHash failed.");
    }

    //  .
    if (!CryptSetHashParam(
	hHash,
	HP_PBKDF2_SALT,
	(BYTE*)&salt,
	0))
    {
	HandleError("CryptSetHashParam HP_PBKDF2_SALT failed.");
    }

    //   .
    if (!CryptSetHashParam(
	hHash,
	HP_PBKDF2_PASSWORD,
	(BYTE*)&password_blob,
	0))
    {
	HandleError("CryptSetHashParam HP_PBKDF2_PASSWORD failed.");
    }

    //--------------------------------------------------------------------
    //   ,   ,   .

    if(CryptDeriveKey(
	hProv,
	CALG_G28147,
	hHash,
	CRYPT_EXPORTABLE,
	&hDerivedKey))
    {
	printf("The key has been derived. \n");
    }
    else
    {
	HandleError("Error during CryptDeriveKey!");
    }

    //  PRO12_EXPORT   
    if(CryptSetKeyParam(
        hDerivedKey,
        KP_ALGID,
        (LPBYTE)&ke_alg,
        0))
    {
	printf("PRO12_EXPORT agree key algorithm has been set. \n");
    }
    else
    {
	HandleError("Error during CryptSetKeyParam agree key.");
    }
    
    
    //--------------------------------------------------------------------
    //   .
    //--------------------------------------------------------------------
    //    ,   .
    if(CryptGetUserKey( 
	hProv, 
	AT_KEYEXCHANGE, 
	&hKey)) 
    {
	printf("The sender private key has been acquired. \n");
    }
    else
    {
	HandleError("Error during CryptGetUserKey private key.");
    }

    //--------------------------------------------------------------------
    //     . 
    if(CryptGetKeyParam(
	hDerivedKey, 
	KP_SV, 
	NULL, 
	&dwIV, 
	0))
    {
	printf("Size of the IV for the sender secret Key determined. \n");
    }
    else
    {
	HandleError("Error computing IV length.");

    }

    pbIV = (BYTE*)malloc(dwIV);
    if (!pbIV)
	HandleError("Out of memory. \n");

    //    .
    if(CryptGetKeyParam(
	hDerivedKey, 
	KP_IV, 
	pbIV, 
	&dwIV, 
	0))
    {
	printf( "CryptGetKeyParam succeeded. \n");
    }
    else
    {
	HandleError("Error during CryptGetKeyParam.");
    }
    
    //     .
    WriteBlobToFile(pbIV, dwIV, "vector.bin"); 

    //--------------------------------------------------------------------
    //   BLOB    .   
    
    if(CryptExportKey(
	hKey, 
	hDerivedKey, 
	PRIVATEKEYBLOB, 
	0, 
	NULL,
	&dwKeyBlobExportLen)) 
    {
	printf("Size of the BLOB for the sender secret Key determined. \n");
    }
    else
    {
	HandleError("Error computing BLOB length.");
    }

    pbKeyBlobExport = (BYTE*)malloc(dwKeyBlobExportLen);

    if(!pbKeyBlobExport) 
	HandleError("Out of memory. \n");

    //     Derived.

    if(CryptExportKey(
	hKey, 
	hDerivedKey, 
	PRIVATEKEYBLOB,
	0, 
	pbKeyBlobExport, 
	&dwKeyBlobExportLen))
    {
	printf("Contents have been written to the BLOB. \n");
    }
    else
    {
	HandleError("Error during CryptExportKey.");
    }

    //    
    WriteBlobToFile(pbKeyBlobExport, dwKeyBlobExportLen, "EncryptedKeyBlob.enc");

    CleanUp();

    return 0;
}


void WriteBlobToFile(BYTE *pbData, DWORD cbData, char *FName )
{
    FILE *file;

    //       BLOB-
    if((file = fopen(FName, "wb")))
    {
	printf("The file '%s' was opened\n", FName);
    }
    else
    {
	HandleError("Problem opening the file\n");
    }

    //  BLOB-  
    if(fwrite(pbData, 1, cbData, file))
    {
	printf("The blob was written to the '%s'\n", FName);
    }
    else
    {
	fclose(file);
	HandleError("The blob can not be written to file.");
    }

    fclose(file);
}


void CleanUp(void)
{
    //     .
    if(hKey)
	CryptDestroyKey(hKey);

    //    .
    if(hDerivedKey)
	CryptDestroyKey(hDerivedKey);

    //   .
    if(hHash)
	CryptDestroyHash(hHash);

    //   .
    if(hProv) 
	CryptReleaseContext(hProv, 0);

    free(pbKeyBlobExport);
    free(pbIV);

    free(salt.pbData);
}


//   
// (    ,   
//     )

//--------------------------------------------------------------------
//       HandleError,  
//   ,       . 
//         , 
//        .


void HandleError(const char *s)
{
    DWORD err = GetLastError();
    printf("Error number     : 0x%x\n", err);
    printf("Error description: %s\n", s);
    CleanUp();
    if(!err) err = 1;
    exit(err);
}
