#include <stdio.h>
#ifdef _WIN32
#   include <tchar.h>
#else
#   include <string.h>
#   include <stdlib.h>
#   include "reader/tchar.h"
#endif
#include "cpcsp/WinCryptEx.h"

//   (    ,   
//    )
//--------------------------------------------------------------------
//        .
//        EncryptedKeyBlob.enc.
//         
//      EncryptKey.
//       
//     ,  
//   "vector.bin"  "salt.bin".
//    ,   "Sender"  "Responder", 
//    ExportInFile, EncryptKey  DecryptKey  
//    .
// :  win32   _s  CRT .
//--------------------------------------------------------------------

#ifdef _WIN32
#   define CONTAINER_COPY _TEXT("\\\\.\\registry\\SenderCopy")
#else
#   define CONTAINER_COPY _TEXT("\\\\.\\hdimage\\SenderCopy")
#endif
#define CONTAINER_COPY_PIN "111"

#pragma region vars

#define BLOCK_LENGTH 4096
#define SALT_LENGTH 16

static void HandleError(const char *s);
static void CleanUp(void);


static HCRYPTPROV hProv = 0;		//  CSP     
static HCRYPTKEY hKey = 0;		//      AT_EXCHANGE
static HCRYPTKEY hDerivedKey = 0;	//     hProv
static HCRYPTHASH hHash = 0;		//   

static FILE *vectorf=NULL;		//     
static FILE *saltf = NULL;		//    
static FILE *EncryptedKeyBlob = NULL;   //     

static CRYPT_DATA_BLOB salt = {0, NULL}; //  CRYPT_DATA_BLOB   


//#define PROVIDER_NAME NULL
//#define PROVIDER_NAME "CP2001KC1"

#pragma endregion


int main(void)
{
    BYTE *pbKeyBlobExport = NULL;    //    BLOB   

    DWORD dwKeyBlobExportLen;   //     
    
    BYTE pbIV[100];		//    
    DWORD dwIV = 0;		//   

    DWORD szf;
    BOOL bContExists = FALSE;

    ALG_ID ke_alg = CALG_PRO12_EXPORT; //   

    char password[] = "password";   // 
    CRYPT_DATA_BLOB password_blob;  //  CRYPT_DATA_BLOB   
    password_blob.pbData = (BYTE*)password;
    password_blob.cbData = (DWORD)strlen(password);
    
    //    .
    salt.cbData = SALT_LENGTH;
    salt.pbData = (BYTE*)malloc(salt.cbData);
    if (!salt.pbData)
	HandleError("Out of memory.");

    //  ,    .
    if(!(saltf = fopen("salt.bin", "r+b")))
	HandleError( "Problem opening file 'salt.bin'\n" );
    printf( "File 'salt.bin' was opened\n" );

    //    .
    salt.cbData = (DWORD)fread(salt.pbData, 1, salt.cbData, saltf);
    if(!salt.cbData)
	HandleError( "Failed to read salt from 'salt.bin'\n" );
    printf( "Salt was read from 'salt.bin'\n" );

    //  ,     .
    if(!(vectorf = fopen("vector.bin", "r+b")))
	HandleError( "Problem opening the file 'vector.bin'\n" );
    printf( "The file 'vector.bin' was opened\n" );

    //     .
    dwIV = (DWORD)fread(pbIV, 1, 100, vectorf);
    if(!dwIV)
	HandleError( "The IV can not be reading from the 'vector.bin'\n" );
    printf( "The IV was read from the 'vector.bin'\n" );
    
    //     
    if(!(EncryptedKeyBlob = fopen("EncryptedKeyBlob.enc", "r+b")))
	HandleError( "Problem opening the file 'EncryptedKeyBlob.enc'\n" );
    printf( "The file 'EncryptedKeyBlob.enc' was opened\n" );

    //------------------------------------------------------------------
    //    
    //------------------------------------------------------------------
    //    EncryptedKeyBlob.enc,    szfile
    fseek(EncryptedKeyBlob, 0, SEEK_END);
    szf = ftell(EncryptedKeyBlob);
    fseek(EncryptedKeyBlob, 0, SEEK_SET);
    
    //  
    pbKeyBlobExport = (BYTE*)malloc(szf);
    if (!pbKeyBlobExport)
	HandleError("Out of memory.");

    //       EncryptedKeyBlob.enc 
    dwKeyBlobExportLen = (DWORD)fread(pbKeyBlobExport, 1, szf, EncryptedKeyBlob);
    if(!dwKeyBlobExportLen)
	HandleError( "The private Key can not be reading from the 'EncryptedKeyBlob.enc'\n" );
    printf( "The private Key was read from the 'EncryptedKeyBlob.enc'\n" );


    //------------------------------------------------------------------
    //------------------------------------------------------------------
    //      "SenderCopy", 
    //     . 
    bContExists = CryptAcquireContext(
	&hProv,
	CONTAINER_COPY,
	NULL,
	PROV_GOST_2012_256,
	CRYPT_SILENT);
    if (bContExists) {
	if (!CryptSetProvParam(
	    hProv,
	    PP_DELETE_KEYSET,
	    NULL,
	    0)) {
	    HandleError("Error during CryptSetProvParam CRYPT_DELETEKEYSET");
	}
	if (!CryptReleaseContext(hProv, 0)) {
	    HandleError("Error during CryptReleaseContext");
	}
    }
    if (!CryptAcquireContext(
	&hProv,
	CONTAINER_COPY,
	NULL,
	PROV_GOST_2012_256,
	CRYPT_NEWKEYSET | CRYPT_SILENT)) {
	HandleError("Error during CryptAcquireContext CRYPT_NEWKEYSET");
    }

    if (!CryptSetProvParam(
	hProv,
	PP_KEYEXCHANGE_PIN,
	(BYTE*)CONTAINER_COPY_PIN,
	0)) {
	HandleError("Failed to set PIN");
    }

    printf("The key container \"SenderCopy\" has been acquired. \n");


    //-----------------------------------------------------------------
    //  
    //-----------------------------------------------------------------

    //    .
    if (!CryptCreateHash(
	hProv,
	CALG_PBKDF2_2012_512,
	0,
	0,
	&hHash))
    {
	HandleError("CryptCreateHash failed.");
    }

    //  .
    if (!CryptSetHashParam(
	hHash,
	HP_PBKDF2_SALT,
	(BYTE*)&salt,
	0))
    {
	HandleError("CryptSetHashParam HP_PBKDF2_SALT failed.");
    }

    //   .
    if (!CryptSetHashParam(
	hHash,
	HP_PBKDF2_PASSWORD,
	(BYTE*)&password_blob,
	0))
    {
	HandleError("CryptSetHashParam HP_PBKDF2_PASSWORD failed.");
    }

    //--------------------------------------------------------------------
    //   ,   ,   .

    if(CryptDeriveKey(
	hProv,
	CALG_G28147,
	hHash, 
	CRYPT_EXPORTABLE,
	&hDerivedKey)) 
    {
	printf("The key has been derived. \n");
    }
    else
    {
	HandleError("Error during CryptDeriveKey!");
    }

    //  PRO12_EXPORT   
    if(CryptSetKeyParam(
        hDerivedKey,
        KP_ALGID,
        (LPBYTE)&ke_alg,
        0))
    {
	printf("PRO12_EXPORT agree key algorithm has been set. \n");
    }
    else
    {
	HandleError("Error during CryptSetKeyParam agree key.");
    }

    //-----------------------------------------------------------------
    //    
    //-----------------------------------------------------------------
    //    -    8  
    //  .
    if(!CryptSetKeyParam(
	hDerivedKey,
	KP_SV,
	pbIV,
	0))
    {
	HandleError("Error during CryptSetKeyParam.");
    }
    printf( "CryptSetKeyParam succeeded. \n");

    //        
    //   Derived  
    if(CryptImportKey(
	hProv, 
	pbKeyBlobExport, 
	dwKeyBlobExportLen, 
	hDerivedKey, 
	0, 
	&hKey))
    {
	printf("The private Key has been imported. \n");
    }
    else
    {
	HandleError("Error during CryptImportKey private Key.");
    }


    CleanUp();

    printf("The program ran to completion without error. \n");    

    free(pbKeyBlobExport);


    return 0;

}//  main


void CleanUp(void)
{
    if (EncryptedKeyBlob)
	fclose (EncryptedKeyBlob);
    if(vectorf)    
        fclose (vectorf);
    if(saltf)
	fclose(saltf);

    //     .
    if(hKey)
	CryptDestroyKey(hKey);

    //    .
    if(hDerivedKey)
	CryptDestroyKey(hDerivedKey);

    //   .
    if(hHash)
	CryptDestroyHash(hHash);

    if (hProv) {
	//   SenderCopy.
	CryptSetProvParam(
	    hProv,
	    PP_DELETE_KEYSET,
	    NULL,
	    0);

	//   .
	CryptReleaseContext(hProv, 0);
    }

    free(salt.pbData);
}

//   
// (    ,   
//     )

//--------------------------------------------------------------------
//       HandleError,  
//   ,       . 
//         , 
//        .

void HandleError(const char *s)
{
    DWORD err = GetLastError();
    printf("Error number     : 0x%x\n", err);
    printf("Error description: %s\n", s);
    CleanUp();
    if(!err) err = 1;
    exit(err);
}
