/*
* Copyright(C) 2000-2010  
*
*    , 
*   .
*
*  ,    , 
*         
*   .
*
*     
*     .
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef _WIN32
#   include <tchar.h>
#else
#   include "reader/tchar.h"
#endif
#include "cpcsp/WinCryptEx.h"

//   (    ,   
//    )
//--------------------------------------------------------------------
//        .

//         
//      EncryptFile.
//       "session_EncryptedKey.bin",
//      -  "agree_IV.bin",
// MAC    -  "session_MacKey.bin".
//       , 
//   "Sender.pub" (      
// ExportInFile). 
//        
//    "encrypt.bin".    
//   ,     "vector.bin".
//     "destination.txt".
//    ,   "Sender"  "Responder", 
//    ExportInFile, EncryptFile  DecryptFile  
//    .
// :  win32   _s  CRT .
//--------------------------------------------------------------------

#define BLOCK_LENGTH 4096

static void LoadPublicKey(BYTE *pbBlob, DWORD *pcbBlob, char *szCertFile, char *szKeyFile);
static void CleanUp(void);
static void HandleError(const char *s);

static HCRYPTPROV hProv = 0;		//  CSP
static HCRYPTKEY hKey = 0;		//    
static HCRYPTKEY hSessionKey = 0;	//   
static HCRYPTKEY hAgreeKey = 0;        //   

static FILE *Encrypt=NULL;		//  
static FILE *certf=NULL;		// ,    
static FILE *publicf=NULL;		// ,     
static FILE *session_EncryptedKey=NULL;//      ( )
static FILE *session_MacKey=NULL;	//      ()
static FILE *agree_IV=NULL;		//       
static FILE *vectorf=NULL;		//       
static FILE *destination=NULL;		//  
static FILE *EncryptionParam=NULL;           //      

#define MAX_PUBLICKEYBLOB_SIZE 200

int main(void)
{
    BYTE  pbKeyBlob[MAX_PUBLICKEYBLOB_SIZE];	//    BLOB 
    DWORD dwBlobLen = MAX_PUBLICKEYBLOB_SIZE;	//   BLOB
    BYTE *pbKeyBlobSimple = NULL;  //     BLOB 
    DWORD cbBlobLenSimple;	//    BLOB
    BYTE pbAgreeIV[100];	//    
    BYTE pbSessionIV[100];	//    
    DWORD dwAgreeIV = 0;		//     
    DWORD dwSessionIV = 0;		//     
    BYTE pbContent[BLOCK_LENGTH];	//     
    DWORD cbContent = 0;	//  
    ALG_ID ke_alg = CALG_SIMPLE_EXPORT_M; //   
    CRYPT_SIMPLEBLOB_HEADER tSimpleBlobHeaderStandart;
    DWORD dwBytesRead;
    BYTE *pbEncryptionParamSetStandart; //  
    DWORD cbEncryptionParamSetStandart; //   

    tSimpleBlobHeaderStandart.BlobHeader.aiKeyAlg = CALG_GR3412_2015_M; 
    tSimpleBlobHeaderStandart.BlobHeader.bType = SIMPLEBLOB;
    tSimpleBlobHeaderStandart.BlobHeader.bVersion = BLOB_VERSION;
    tSimpleBlobHeaderStandart.BlobHeader.reserved = 0;
    tSimpleBlobHeaderStandart.EncryptKeyAlgId = CALG_GR3412_2015_M;
    tSimpleBlobHeaderStandart.Magic = G28147_MAGIC;    

    //  ,     .
    //if(!fopen_s( &Encrypt, "encrypt.bin", "r+b" ))
    if(!(Encrypt = fopen("encrypt.bin", "r+b" )))
	HandleError( "Problem opening the file 'encrypt.bin'\n" );
    printf( "The file 'encrypt.bin' was opened\n" );

    //  ,       .
    //if(!fopen_s(&agree_IV, "agree_IV.bin", "r+b" ))
    if(!(agree_IV = fopen("agree_IV.bin", "r+b")))
	HandleError( "Problem opening the file 'agree_IV.bin'\n" );
    printf( "The file 'agree_IV.bin' was opened\n" );

    //  ,      .
    if(!(session_EncryptedKey = fopen("session_EncryptedKey.bin", "r+b")))
	HandleError( "Problem opening the file 'session_EncryptedKey.bin'\n" );
    printf( "The file 'session_EncryptedKey.bin' was opened\n" );

    //  ,      .
    if(!(session_MacKey = fopen("session_MacKey.bin", "r+b")))
	HandleError( "Problem opening the file 'session_MacKey.bin'\n" );
    printf( "The file 'session_MacKey.bin' was opened\n" );

    //  ,       .
    //if(!fopen_s(&vectorf, "vector.bin", "r+b" ))
    if(!(vectorf = fopen("vector.bin", "r+b")))
	HandleError( "Problem opening the file 'vector.bin'\n" );
    printf( "The file 'vector.bin' was opened\n" );

    //  ,      .
    //if(!fopen_s(&destination, "destination.txt", "w+b" ))
    if(!(destination = fopen("destination.txt", "w+b" )))
	HandleError( "Problem opening the file 'destination.txt'\n" );
    printf( "The file 'destination.txt' was opened\n" );

    //  ,      .
    //if(!fopen_s(&vectorf, "vector.bin", "r+b" ))
    if (!(EncryptionParam = fopen("EncryptionParam.bin", "r+b")))
	HandleError("Problem opening the file 'EncryptionParam.bin'\n");
    printf("The file 'EncryptionParam.bin' was opened\n");

    //       .
    dwAgreeIV = (DWORD)fread(pbAgreeIV, 1, 100, agree_IV);
    if(!dwAgreeIV)
	HandleError( "The IV can not be reading from the 'agree_IV.bin'\n" );
    printf( "The IV was read from the 'agree_IV.bin'\n" );

    //        .
    dwSessionIV = (DWORD)fread(pbSessionIV, 1, 100, vectorf);
    if(!dwSessionIV)
	HandleError( "The IV can not be reading from the 'vector.bin'\n" );
    printf( "The IV was read from the 'vector.bin'\n" );

    //       "Responder", 
    //    . 
    if(!CryptAcquireContext(
	&hProv, 
	_TEXT("Responder"),
	NULL, 
	PROV_GOST_2012_256, 
	0)) 
    {
	HandleError("Error during CryptAcquireContext");
    }
    printf("The key container \"Responder\" has been acquired. \n");

    // obtain file size:
    fseek(EncryptionParam, 0, SEEK_END);
    cbEncryptionParamSetStandart = sizeof(char)*ftell(EncryptionParam);
    rewind(EncryptionParam);
    // allocate memory to contain the whole file:
    pbEncryptionParamSetStandart = (BYTE*)malloc(cbEncryptionParamSetStandart);
    if (pbEncryptionParamSetStandart == NULL)
	HandleError("Out of memory. \n");
    // copy the file into the buffer:
    dwBytesRead = (DWORD)fread(pbEncryptionParamSetStandart, 1, cbEncryptionParamSetStandart, EncryptionParam);
    if (dwBytesRead != cbEncryptionParamSetStandart)
	HandleError("The EncryptionParam can not be reading from the 'EncryptionParam.bin'\n");

    cbBlobLenSimple = cbEncryptionParamSetStandart;
    cbBlobLenSimple += (sizeof(CRYPT_SIMPLEBLOB_HEADER)+SEANCE_VECTOR_LEN + G28147_KEYLEN + EXPORT_IMIT_SIZE);// +sizeof(pbEncryptionParamSetStandart);
    pbKeyBlobSimple = malloc(cbBlobLenSimple);
    if(!pbKeyBlobSimple) 
	HandleError("Out of memory. \n");

    memcpy(&((CRYPT_SIMPLEBLOB*)pbKeyBlobSimple)->tSimpleBlobHeader, &tSimpleBlobHeaderStandart, sizeof(CRYPT_SIMPLEBLOB_HEADER)); //    

    memset(((CRYPT_SIMPLEBLOB*)pbKeyBlobSimple)->bSV, 0, SEANCE_VECTOR_LEN);

    //   c   .
    dwBytesRead = (DWORD)fread(((CRYPT_SIMPLEBLOB*)pbKeyBlobSimple)->bEncryptedKey, 1, G28147_KEYLEN, session_EncryptedKey);
    if(!dwBytesRead)
	HandleError( "The session key can not be reading from the 'session_EncryptedKey.bin'\n" );
    printf( "The session key was read from the 'session_EncryptedKey.bin'\n" );

    memcpy(((CRYPT_SIMPLEBLOB*)pbKeyBlobSimple)->bEncryptionParamSet, pbEncryptionParamSetStandart, cbEncryptionParamSetStandart); //  ASN 

    //   c   .
    dwBytesRead = (DWORD)fread(((CRYPT_SIMPLEBLOB*)pbKeyBlobSimple)->bMacKey, 1, EXPORT_IMIT_SIZE, session_MacKey);
    if(!dwBytesRead)
	HandleError( "The session key can not be reading from the 'session_MacKey.bin'\n" );
    printf( "The session key was read from the 'session_MacKey.bin'\n" );

    LoadPublicKey(pbKeyBlob, &dwBlobLen, "Sender.cer", "Sender.pub");

    //     .
    if(CryptGetUserKey(
	hProv, 
	AT_KEYEXCHANGE, 
	&hKey)) 
    {
	printf("The private key has been acquired. \n");
    }
    else
    {
	HandleError("Error during CryptGetUserKey private key.");
    }

    //        
    //    .
    if(CryptImportKey(
	hProv, 
	pbKeyBlob, 
	dwBlobLen, 
	hKey, 
	0, 
	&hAgreeKey))
    {
	printf("The sender public key has been imported. \n");
    }
    else
    {
	HandleError("Error during CryptImportKey public key.");
    }

    //   
    if (CryptSetKeyParam(
	hAgreeKey,
	KP_IV,
	pbAgreeIV,
	0))
    {
	printf("KP_IV agree key has been set. \n");
    }
    else
    {
	HandleError("Error during CryptSetKeyParam KP_IV.");
    }

    //  CALG_SIMPLE_EXPORT_M   
    if(CryptSetKeyParam(
        hAgreeKey,
        KP_ALGID,
        (LPBYTE)&ke_alg,
        0))
    {
	printf("CALG_SIMPLE_EXPORT_M agree key algorithm has been set. \n");
    }
    else
    {
	HandleError("Error during CryptSetKeyParam agree key.");
    }

    //        
    //   Agree.
    if(CryptImportKey(
	hProv, 
	pbKeyBlobSimple, 
	cbBlobLenSimple,
	hAgreeKey, 
	0, 
	&hSessionKey))
    {
	printf("The session key has been imported. \n");
    }
    else
    {
	HandleError("Error during CryptImportKey session key.");
    }

    //    -    8  
    //  .
    if(!CryptSetKeyParam(
	hSessionKey, 
	KP_IV, 	
	pbSessionIV,
	0))
    {
	HandleError("Error during CryptSetKeyParam.");
    }
    printf( "CryptSetKeyParam succeeded. \n");

    //       4 .  
    //       "destination.txt".
    do 
    {
	cbContent = (DWORD)fread(pbContent, 1, BLOCK_LENGTH, Encrypt);
	if(cbContent)
	{
	    BOOL bFinal = feof(Encrypt);
	    //      .
	    if(CryptDecrypt(
		hSessionKey,
		0,
		bFinal,
		0,
		pbContent,
		&cbContent))
	    {
		printf( "Decryption succeeded. \n");
		//     .
		if(fwrite(
		    pbContent,
		    1,
		    cbContent,
		    destination))
		{
		    printf( "The decrypted content was written to the 'destination.txt'\n" );
		}
		else
		{
		    HandleError( "The decrypted content can not be written to the 'destination.txt'\n" );
		}  
	    }
	    else
	    {
		HandleError("Decryption failed.");
	    }
	}
	else
	{
	    HandleError( "Problem reading the file 'encrypt.bin'\n" );
	}
    }
    while(!feof(Encrypt));

    CleanUp();

    printf("The program ran to completion without error. \n");
    free(pbEncryptionParamSetStandart);
    free(pbKeyBlobSimple);
    return 0;
}//  main

//  PUBLICKEYBLOB  ,   , () 
//  ,   .
void LoadPublicKey(BYTE *pbBlob, DWORD *pcbBlob, char *szCertFile, char *szKeyFile)
{
    //  ,      .
    //if(fopen_s(&certf, szCertFile, "r+b" ))
    if((certf = fopen(szCertFile, "rb"))) {
	DWORD cbCert = 2000;
	BYTE  pbCert[2000];
	PCCERT_CONTEXT pCertContext = NULL;
	HCRYPTKEY hPubKey;
	printf( "The file '%s' was opened\n", szCertFile );

	cbCert = (DWORD)fread(pbCert, 1, cbCert, certf);
	if(!cbCert)
	    HandleError( "Failed to read certificate\n" );
	printf( "Certificate was read from the '%s'\n", szCertFile );

	pCertContext = CertCreateCertificateContext (
	    X509_ASN_ENCODING | PKCS_7_ASN_ENCODING, pbCert, cbCert);
	if (!pCertContext) {
	    HandleError( "CertCreateCertificateContext" );
	}

	//   
	if (CryptImportPublicKeyInfoEx(
	    hProv, 
	    X509_ASN_ENCODING | PKCS_7_ASN_ENCODING,
	    &(pCertContext->pCertInfo->SubjectPublicKeyInfo),
	    0,
	    0,
	    NULL,
	    &hPubKey))
	{
	    printf("Public key imported from cert file\n");
	} else {
	    CertFreeCertificateContext(pCertContext);
	    HandleError( "CryptImportPublicKeyInfoEx" );
	}
	CertFreeCertificateContext(pCertContext);

	//    BLOB
	if (CryptExportKey(
	    hPubKey,
	    0,
	    PUBLICKEYBLOB,
	    0,
	    pbBlob,
	    pcbBlob))
	{
	    printf("Public key exported to blob\n");
	}
	else
	{
	    HandleError( "CryptExportKey" );
	}
    } else {
	//  ,      .
	//if(!fopen_s(&publicf, szKeyFile, "r+b" ))
	if(!(publicf = fopen(szKeyFile, "rb")))
	    HandleError( "Problem opening the public key blob file\n" );
	printf( "The file '%s' was opened\n", szKeyFile );

	*pcbBlob = (DWORD)fread(pbBlob, 1, *pcbBlob, publicf);
	if(!*pcbBlob)
	    HandleError( "Failed to read key blob file\n" );
	printf( "Key blob was read from the '%s'\n", szKeyFile );
    }
}

void CleanUp(void)
{
    if(Encrypt)
        fclose (Encrypt);
    if(agree_IV)
	fclose (agree_IV);
    if(session_EncryptedKey)
	fclose (session_EncryptedKey);
    if(session_MacKey)
	fclose (session_MacKey);
    if(vectorf)    
        fclose (vectorf);
    if(destination)    
        fclose (destination);
    if(certf)
	fclose (certf); 
    if(publicf)
	fclose (publicf);
    if (EncryptionParam)
	fclose (EncryptionParam);

    //    .
    if(hKey)
	CryptDestroyKey(hKey);

    //    .
    if(hSessionKey)
	CryptDestroyKey(hSessionKey);

    //    .
    if(hAgreeKey)
	CryptDestroyKey(hAgreeKey);

    //   .
    if(hProv) 
	CryptReleaseContext(hProv, 0);
}

//   
// (    ,   
//     )

//--------------------------------------------------------------------
//       HandleError,  
//   ,       . 
//         , 
//        .

void HandleError(const char *s)
{
    DWORD err = GetLastError();
    printf("Error number     : 0x%x\n", err);
    printf("Error description: %s\n", s);
    CleanUp();
    if(!err) err = 1;
    exit(err);
}





