/*
 * Copyright(C) 2000-2010  
 *
 *    , 
 *   .
 *
 *  ,    , 
 *         
 *   .
 *
 *     
 *     .
 */

//--------------------------------------------------------------------
//          
//   1.5

#include <cstdio>
#include <cstring>

#include "UnixRequest.h"
#include "UnixEnroll.h"
#include "cpcsp/WinCryptEx.h"
#include "CPCA15UserInfo.h"
#include <time.h> 
#include"SecureBuffer.h"
#ifdef _WIN32
#  ifdef _DEBUG
#    pragma comment(lib, "comsuppwd.lib")
#  else
#    pragma comment(lib, "comsuppw.lib")
#  endif
#  define CONTAINER L"\\\\.\\REGISTRY\\CPCA15test"
#else
#  define CONTAINER L"\\\\.\\HDIMAGE\\CPCA15test"
#endif
#include "compiler_attributes.h"

//   
#define CERFILE "CPCA15test.cer"
#define _UN UNNAMED_UNION_B

class Callbacks: public UnixEnroll::UserCallbacks
{
public:
	bool askPermissionToAddToRootStore( const BYTE* pbCert, DWORD cbCert, bool force = false) const;
	UserCallbacks* clone() const;
	virtual ~Callbacks() {}
};

//--------------------------------------------------------------------
//  askPermissionToAddToRootStore   

bool Callbacks::askPermissionToAddToRootStore( const BYTE* pbCert, DWORD cbCert, bool) const
{
    UNUSED(pbCert);
    UNUSED(cbCert);
    return true;
}

UnixEnroll::UserCallbacks* Callbacks::clone() const
{
	return new Callbacks();
}

static void ATTR_NORETURN HandleCode(HRESULT err, const char *s)
{
    ::printf("Error number     : 0x%x\n", err);
    ::printf("Error description: %s\n", s);
    if(!err)
	err = 1;
    ::exit(err);
}

static void ATTR_NORETURN HandleError(const char *s)
{
    const HRESULT err = (HRESULT) GetLastError();
    HandleCode(err, s);
}

static HRESULT SafeGetLastError()
{
    const HRESULT err = (HRESULT)GetLastError();
    return err ? err : NTE_FAIL;
}

static long get_templates(CSecurePin* sbPassword,std::string tokenID, std::string UIURL,
				   std::vector<std::string>& templates)
{
	//URFactory -     
	UnixRequest * pRequest = UnixRequest::URFactory("CPCA15");
    	
	if (pRequest == 0)
	    return NTE_FAIL;
    	
	HRESULT res = -1;
	BSTR bstrTemplates = 0;
    	
	BSTR UrlOfCA = ConvertStringToBSTR(UIURL.c_str());
	    /* UnixRequest */
	CSecurePin* sp;
	BSTR bstrTokenID = 0;
	BSTR bstrTP = 0;
	char * chTemplates = 0;
        
	sp = sbPassword;
	bstrTokenID = ConvertStringToBSTR(tokenID.c_str());
        
	//    TLS      
	X509EnrollmentCheckChainFlags chainFlags = X509CC_TLS;
        
	// SetCredential         .
	res = pRequest->SetCredential(NULL,X509AuthUsername, chainFlags, bstrTokenID,sp);
        
	if(res != S_OK){
	    delete pRequest;
	    SysFreeString(UrlOfCA);
	    SysFreeString(bstrTokenID);
	    return res;
	}

	//   .      
	// ICertAdmin2::GetCAProperty Microsoft CryptoAPI

	res = pRequest->GetCAProperty(UrlOfCA, CR_PROP_TEMPLATES, 0, PROPTYPE_STRING, 0, (VARIANT *)&bstrTemplates);

	if(res != S_OK){
	    delete pRequest;
	    SysFreeString(UrlOfCA);
	    SysFreeString(bstrTokenID);
	    return res;
	}
        
        
	    chTemplates = ConvertBSTRToString(bstrTemplates) ;
	    std::string strTemplates(chTemplates );
	    printf("Templates:\n%s\n",strTemplates.c_str());

	    std::string separator = "\n";
	    size_t counter = 1;
	    size_t found = strTemplates.find_first_of(separator);
	    while(found != std::string::npos){
	        if(found > 0 && counter%2 ){
		    templates.push_back(strTemplates.substr(0,found));
	        }
	        strTemplates = strTemplates.substr(found+1);
	        found = strTemplates.find_first_of(separator);
	        ++counter;
	    }
	    if(strTemplates.length() > 0 && counter%2){
	        templates.push_back(strTemplates);
	    }    
	SysFreeString(bstrTemplates);
	SysFreeString(UrlOfCA);
	SysFreeString(bstrTokenID);
	SysFreeString(bstrTP);
	delete [] chTemplates;
	delete pRequest;
	return S_OK;
}

static CPCA15UserInfo *get_reg_info(std::string UIURL)
{
	UnixRequest * pRequest = UnixRequest::URFactory("CPCA15");
	X509EnrollmentCheckChainFlags chainFlags = X509CC_TLS;
       
	long res = pRequest->SetCredential(NULL, X509AuthAnonymous, chainFlags, NULL, NULL);
	if (res != S_OK) {
	    delete pRequest;
	    return NULL;
	}
	BSTR UrlOfCA = ConvertStringToBSTR(UIURL.c_str());
	CPCA15UserInfo *ui = new CPCA15UserInfo;
	// GetUserRegisterInfo     .
	res = pRequest->GetUserRegisterInfo(UrlOfCA, ui);
	SysFreeString(UrlOfCA);
	delete pRequest;
	return ui;
}

static long register_user(std::string& UIURL, CPCA15UserInfo& ui)
{
	UnixRequest * pRequest = UnixRequest::URFactory("CPCA15");
	X509EnrollmentCheckChainFlags chainFlags = X509CC_TLS;
	long res = pRequest->SetCredential(NULL, X509AuthAnonymous, chainFlags, NULL, NULL);
	if (res != S_OK) {
	    delete pRequest;
	    return res;
	}

	const BSTR UrlOfCA = ConvertStringToBSTR(&UIURL[0]);
	printf("%d\n", (int)ui.fields.size());
	//  
	res = pRequest->RegisterUser(UrlOfCA, &ui);
	delete pRequest;
	SysFreeString(UrlOfCA);
	return res;
}

static void create_UPN_extension(BSTR &value, BSTR &oid)
{
    CERT_NAME_VALUE  OtherNameInfo;
    CERT_ALT_NAME_ENTRY AltNames = { 0 };
    CERT_ALT_NAME_INFO  AltNameInfo = { 0 };
    CERT_OTHER_NAME otherName;
    LPCWSTR pwnzUPN = L"test@cryptopro.ru";
    DWORD size = 0;

    //   CERT_NAME_VALUE       CERT_OTHER_NAME
    OtherNameInfo.dwValueType = CERT_RDN_BMP_STRING;
    OtherNameInfo.Value.cbData = (DWORD)wcslen(pwnzUPN)*sizeof(wchar_t);
    OtherNameInfo.Value.pbData = (LPBYTE)pwnzUPN;
    BOOL bRet = CryptEncodeObject(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING,
	X509_ANY_STRING, &OtherNameInfo, 0, &size);
    if (!bRet) {
	HandleError("Error in extension (CryptEncodeObject OtherNameInfo).");
    }
    std::vector<BYTE> encodedUPNSeq(size);
    bRet = CryptEncodeObject(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING,
	X509_ANY_STRING, &OtherNameInfo, &encodedUPNSeq[0], &size);
    if (!bRet) {
	HandleError("Error in extension (CryptEncodeObject OtherNameInfo).");
    }
    //  CERT_ALT_NAME_INFO    CERT_EXTENSION
    AltNames.dwAltNameChoice = CERT_ALT_NAME_OTHER_NAME;
    otherName.Value.cbData = encodedUPNSeq.size();
    otherName.Value.pbData = &encodedUPNSeq[0];
    otherName.pszObjId = (LPSTR)szOID_NT_PRINCIPAL_NAME;
    AltNames._UN pOtherName = &otherName;

    AltNameInfo.cAltEntry = 1;
    AltNameInfo.rgAltEntry = &AltNames;

    bRet = CryptEncodeObject(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING,
	X509_ALTERNATE_NAME, &AltNameInfo, 0, &size);
    if (!bRet) {
	HandleError("Error in extension (CryptEncodeObject AltNameInfo).");
    }
    std::vector<BYTE> encodedNameSeq(size);
    bRet = CryptEncodeObject(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING,
	X509_ALTERNATE_NAME, &AltNameInfo, &encodedNameSeq[0], &size);
    if (!bRet) {
	HandleError("Error in extension (CryptEncodeObject AltNameInfo).");
    }
    //   CERT_EXTENSION,   base 64
    CERT_EXTENSION AltnameExtension;
    AltnameExtension.fCritical = 0;
    AltnameExtension.pszObjId = const_cast<LPSTR>(szOID_SUBJECT_ALT_NAME2);
    AltnameExtension.Value.pbData = &encodedNameSeq[0];
    AltnameExtension.Value.cbData = encodedNameSeq.size();
    
    if (!CryptBinaryToStringA(AltnameExtension.Value.pbData, AltnameExtension.Value.cbData, 
    CRYPT_STRING_BASE64, 0, &size))
        HandleError("Error in extension (CryptBinaryToStringA).");
    std::vector<char> b64(size + 1);
    if (!CryptBinaryToStringA(AltnameExtension.Value.pbData, AltnameExtension.Value.cbData, 
			      CRYPT_STRING_BASE64, &b64[0], &size))
        HandleError("Error in extension (CryptBinaryToStringA).");
    
    b64[size] = '\0';

    // value  oid   addExtensionToRequest
    value = ConvertStringToBSTR(&b64[0]);
    oid = ConvertStringToBSTR(AltnameExtension.pszObjId);
}

static char* create_request(BSTR bstrRDN, BSTR bstrEKUsage, BSTR contName)
{
	HRESULT res = -1;
	Callbacks tb;
    	
	DWORD dwKeySpec = AT_KEYEXCHANGE;
	UnixEnroll * pEnroll = new UnixEnroll(tb, false);

	HRESULT hr = 0;
	BSTR value, oid;
	create_UPN_extension(value, oid);
	// put_ContainerName   
	pEnroll->put_ContainerName(contName);
        //   "1"   
	std::string PIN = "1";
	CSecurePin pin(PIN.length() + 1);
	memcpy(pin.ptr_rw(), PIN.c_str(), PIN.length() + 1);
	hr = pEnroll->put_PIN(pin);
	if (hr) {
	    HandleCode(hr, "Error in put_Pin.");
	}
	pin.clean();	
	// put_LimitExchangeKeyToEncipherment    AT_KEYEXCHANGE, false
	//  ,  , true -  
	pEnroll->put_LimitExchangeKeyToEncipherment(TRUE);
	// put_KeySpec    
	pEnroll->put_KeySpec(dwKeySpec);
	// put_ProviderType   CSP   .
	pEnroll->put_ProviderType(PROV_GOST_2001_DH);
	// put_RequestStoreFlags       .
	pEnroll->put_RequestStoreFlags(CERT_SYSTEM_STORE_CURRENT_USER);
	hr = pEnroll->addExtensionToRequest(0, oid, value);
	if (hr) {
	    HandleCode(hr, "Error in addExtensionToRequest.");
	}
	SysFreeString(oid);
	SysFreeString(value);

	//     createRequest
	BSTR strRequest;
	res = pEnroll->createRequest(XECR_PKCS10_V2_0, bstrRDN, bstrEKUsage, &strRequest);
	if(res != S_OK){
	    HandleCode(res, "Error createRequest.");
	} 
	char *chTmp = ConvertBSTRToString(strRequest);
	printf("charRequest = %s\n", chTmp);

	SysFreeString(strRequest);
	delete pEnroll;
	return chTmp;
}

int main(int argc, char* argv[])
{
	std::string errorMsg;
	X509EnrollmentCheckChainFlags chainFlags = X509CC_TLS;
	std::vector<std::string> ::iterator it;
	std::vector<std::string> templates;
	std::vector<UnixRequest::AttrTriple> vTrip;
	std::string UIURL;
	std :: string s;
	
	HRESULT res;
	DWORD dwKeySpec;
	LONG Flags = CR_IN_PKCS10;
	LONG pDisposition;
	char *charRequest = NULL;
	CPCA15UserInfo *pui = NULL;
	FILE *fp = NULL;
	UnixRequest *pRequest = UnixRequest::URFactory("CPCA15");
	if (pRequest == NULL)
	    return NTE_FAIL;
	
	BSTR UrlOfCA = NULL;
	BSTR bstrRDN = NULL;
	BSTR bstrEKUsage = NULL;
	BSTR strRequest = NULL;
	BSTR bstrAttributes = NULL;
	BSTR strConfig = NULL;
	BSTR bstrTmplName = NULL;
	BSTR bstrTokenID = NULL;
	BSTR contName = NULL;

        //   -serv   ,   , 
        //  cryptopro.ru
	if (argc == 3 && !strcmp(argv[1], "-serv"))
	{
	    //WideCharToMultiByte(CP_UTF8, 0, (src), (int)(-1 /*len*/), (dest), (int)(len), NULL, NULL)
	    const WCHAR *pwcsName;
	    // required size
	    int nChars = MultiByteToWideChar(CP_UTF8, 0, argv[2], -1, NULL, 0);
	    if (!nChars) {
		res = (HRESULT)SafeGetLastError();
		errorMsg = "Conversion error.";
		goto err;
	    }
	    // allocate it
	    pwcsName = new WCHAR[nChars];
	    if (!MultiByteToWideChar(CP_UTF8, 0, argv[2], -1, (LPWSTR)pwcsName, nChars)) {
		res = (HRESULT)SafeGetLastError();
		errorMsg = "Conversion error.";
		delete[] pwcsName;
		goto err;
	    }
	    // use it....
	    strConfig = SysAllocString(pwcsName);
	    if (strConfig == NULL) {
		delete[] pwcsName;
		res = E_OUTOFMEMORY;
		errorMsg = "Memory allocation error.";
		goto err;
	    }
	    UIURL = argv[2];
	    // delete it
	    delete[] pwcsName;
	} else {
	    strConfig = SysAllocString(L"https://cryptopro.ru:5555/ui");
	    if (strConfig == NULL) {
		res = E_OUTOFMEMORY;
		errorMsg = "Memory allocation error.";
		goto err;
	    }
	    UIURL = "https://cryptopro.ru:5555/ui";
	}
	contName = SysAllocString(CONTAINER);
	if (contName == NULL) {
	    res = E_OUTOFMEMORY;
	    errorMsg = "Memory allocation error.";
	    goto err;
	}

	UrlOfCA = ConvertStringToBSTR(UIURL.c_str());
	
	//  Id  password 
	pui = get_reg_info(UIURL);
	if (pui == NULL) {
	    res = (HRESULT)SafeGetLastError();
	    errorMsg = "Error getting information.";
	    goto err;
	}
	printf("successful getting information. \n");
	
//-----------------------------------------------------------------------------------------//
//     
	{
	    HCRYPTPROV hProv = 0;
	    if (!CryptAcquireContext(&hProv, NULL, NULL, PROV_GOST_2012_256, CRYPT_VERIFYCONTEXT)) {
		delete pui;
		res = (HRESULT)SafeGetLastError();
		errorMsg = "Error during CryptAcquireContext.";
		goto err;
	    }
	    unsigned seed;
	    BOOL bRet = CryptGenRandom(hProv, sizeof(seed), (BYTE *)&seed);
	    if (hProv) {
		CryptReleaseContext(hProv, 0);
	    }
	    if (!bRet) {
		delete pui;
		res = (HRESULT)SafeGetLastError();
		errorMsg = "Random bytes were not correctly generated.";
		goto err;
	    }
	    srand(seed);
	}
	for(CPCA15UserFields::iterator it = pui->fields.begin(); it != pui->fields.end(); it++) {
	    if(it->mandatory == true) {
		int flag;
		for (int i = 1; i <= 9; i++) {
		    flag = rand()%2;
		    if (flag)
			it->value += ('a'+rand()%26);
		    else
			it->value += ('0'+rand()%10);
		}
		s = it->value;
	    }
	}
	printf("name = %s\n",s.c_str());

//-----------------------------------------------------------------------------------------//
//     
	res = register_user(UIURL, *pui);
	if (res != S_OK) {
	    delete pui;
	    errorMsg = "Error register.";
	    goto err;
	}
	printf("successful register. \n");

	res = get_templates(pui->sbPassword, pui->TokenID, UIURL, templates);
	if (res != S_OK) {
	    delete pui;
	    errorMsg = "Error getting tamplates.";
	    goto err;
	}
	printf("successful getting tamplates. \n");

	it = templates.begin();
	bstrTmplName = ConvertStringToBSTR((*it).c_str());
	printf("template = %s \n", (*it).c_str());

//-----------------------------------------------------------------------------------------//
//           

	bstrTokenID = ConvertStringToBSTR(pui->TokenID.c_str());
	res = pRequest->SetCredential(NULL, X509AuthUsername, chainFlags, bstrTokenID, pui->sbPassword);
	delete pui;
	if (res != S_OK) {
	    errorMsg = "Error SetCredential.";
	    goto err;
	}
	printf("successful SetCredential. \n");

	res = pRequest->GetRequestParams(UrlOfCA,bstrTmplName,&bstrRDN, &bstrEKUsage,&dwKeySpec,&vTrip);
	if (res != S_OK) {
	    errorMsg = "Error GetRequestParams.";
	    goto err;
	}
	printf("successful GetRequestParams. \n");

	charRequest = create_request(bstrRDN, bstrEKUsage, contName);
	if (charRequest == NULL) {
	    res = (HRESULT)SafeGetLastError();
	    errorMsg = "Error create_request.";
	    goto err;
	}
	printf("create_request. \n");

//-----------------------------------------------------------------------------------------//
//     
	strRequest = ConvertStringToBSTR(charRequest);
	printf("charRequest = %s\n",charRequest);
	delete [] charRequest;

	res = pRequest->Submit(Flags, strRequest, bstrAttributes, strConfig, &pDisposition);
	if (res != S_OK) {
	    errorMsg = "Error submit.";
	    goto err;
	}

	switch (pDisposition) {
	case CR_DISP_DENIED:
	    printf("request was denied. \n");
	    break;

	case CR_DISP_ERROR:
	    printf("error request. \n");
	    break;

	case CR_DISP_INCOMPLETE:
	    printf("request was incompleted\n");
	    break;

	case CR_DISP_ISSUED:
	{
	    printf("certificate was issued. \n");
	    BSTR pMyCert1=NULL;
	    res=pRequest->GetCertificate(CR_OUT_BASE64HEADER,&pMyCert1);
	    if (res!= S_OK)
		return 2;
	    //    
	    fp = fopen(CERFILE, "wb");
	    if (fp == NULL) {
		SysFreeString(pMyCert1);
		res = (HRESULT)SafeGetLastError();
		errorMsg = "Error while openning file.";
		goto err;
	    }
	    char *pCertStr1 = ConvertBSTRToString(pMyCert1);
	    fputs(pCertStr1, fp);
	    fclose(fp);

	    //     
	    printf("Cert:\n%s",pCertStr1);

	    delete [] pCertStr1;
	    SysFreeString(pMyCert1);
	}
	break;

	case CR_DISP_ISSUED_OUT_OF_BAND:
	//  ( )   ,    
	    printf("certificate was issued out of band. \n");
	    break;

	case CR_DISP_UNDER_SUBMISSION:
	    printf("certificate is under submission. \n");
	    break;	
	default:
	    printf("default. \n");
	    break;
	}

	printf("Successful submitting. \n");
err:
	SysFreeString(contName);
	SysFreeString(strConfig);
	SysFreeString(UrlOfCA);
	SysFreeString(strRequest);
	SysFreeString(bstrEKUsage);
	SysFreeString(bstrRDN);
	SysFreeString(bstrAttributes);
	SysFreeString(bstrTokenID);
	SysFreeString(bstrTmplName);
	delete pRequest;
	if (res == S_OK)
	    return 0;
	else
	    HandleCode(res, errorMsg.c_str());
}
