/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_USER_H_INCLUDED
#define SUPPORT_USER_H_INCLUDED

#include "cpcsp/csp_common.h"

#if defined( __cplusplus )
extern "C" {
#endif

#if defined _WIN32
    typedef unsigned(__stdcall *TSupFun)(void *);
#endif

/*   ERROR_SUCCESS. */
DWORD support_set_impersonate(int delayed, int hsmmode, int kb2mode);

DWORD support_thread_actualize_uids(void) CPRO_CHECK_RESULT;
DWORD support_thread_deactualize_uids(void);

/*     . */
DWORD support_user_id(size_t *length, TCHAR *dest) CPRO_CHECK_RESULT;

/*   1,     ,  0 . */
DWORD support_is_system_user_id(TCHAR *src) CPRO_CHECK_RESULT;

#if defined UNIX && !defined CSP_LITE
#include <unistd.h>
/*     . */
DWORD support_user_dir(size_t *length, TCHAR *dest) CPRO_CHECK_RESULT;

/*     . */
DWORD support_user_id_ex(size_t *length, TCHAR *dest, uid_t *euid, uid_t *egid) CPRO_CHECK_RESULT;

/*     . */
DWORD support_impersonate_user_by_uids(uid_t euid, uid_t egid) CPRO_CHECK_RESULT;
#endif	/* UNIX && !CSP_LITE */

/*     . */
DWORD support_user_name(TCHAR *dest, size_t *length) CPRO_CHECK_RESULT;

/*     . */
DWORD support_impersonate_user(const TCHAR *id) CPRO_CHECK_RESULT;

/*    . */
DWORD support_revert_to_self(void);

#if defined _WIN32 && !defined CSP_LITE
DWORD create_thread_same_rights(TSupFun fun, void *info, HANDLE *thread) CPRO_CHECK_RESULT;
#endif /* _WIN32 && !CSP_LITE */

#if defined( __cplusplus )
}
#endif

#endif //SUPPORT_USER_H_INCLUDED
