/*
 * Copyright (c) 2000,  -
 *
 *         
 * ,     ,    ,  
 *  :
 *
 * 1)       
 *         ,   
 *        .
 *
 * 2)       
 *         ,   
 *           /   ,
 *      .
 *
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 *
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_TIME_H
#define SUPPORT_TIME_H

#if defined(UNIX) && !defined CSP_LITE
#   include <sys/time.h>
#endif /* UNIX && !CSP_LITE */

#include "reader/support_base_defs.h"

#if defined( __cplusplus )
extern "C" {
#endif

#if defined _WIN32
typedef struct
{
    int max_resume_time;
    int timer_id;
} TSupResumeTimeStruct;
#endif

typedef struct timeval support_timeval;

#if defined(UNIX) && !defined CSP_LITE
static SUP_INLINE void support_ms_sleep(int ms) {
    struct timespec tim, tim2;
    tim.tv_sec = 0;
    tim.tv_nsec = ms * 1000 * 1000; //ns = 1000us = 1000*1000ms
    nanosleep(&tim, &tim2);
}
#elif defined(_WIN32)
#define support_ms_sleep Sleep
#endif /* UNIX && !CSP_LITE */

/*     . */
//DWORD support_compound_time(long long *lpCompoundCount);

/*    .
 *   ERROR_SUCCESS */
DWORD support_gettimeofday(support_timeval *stv);

/*      .
 *   ERROR_SUCCESS */
DWORD support_time_set(support_timeval *tv_res, long secs);

/*     . tv_res = tv1 - tv2 
 *   ERROR_SUCCESS */
DWORD support_time_sub(const support_timeval *tv1, const support_timeval *tv2, support_timeval *tv_res, int *cmp);

/*   . tv_res = tv1 + tv2
 *   ERROR_SUCCESS */
DWORD support_time_add(const support_timeval *tv1, const support_timeval *tv2, support_timeval *tv_res);

/*    timeval  ULONGLONG (filetime) */
#define TimevalToULongLong(cpc_timeval) \
    (unsigned long long)((cpc_timeval).tv_sec*10000000ULL + (cpc_timeval).tv_usec*10ULL + 116444736000000000ULL)

#ifndef CSP_LITE
DWORD support_time2tm(support_timeval *tv_src, struct tm *tm_dest) CPRO_CHECK_RESULT;

DWORD support_tm2time(struct tm *tm_src, support_timeval *tv_dest) CPRO_CHECK_RESULT;
#endif /* CSP_LITE */


#if defined( __cplusplus )
}
#endif

#endif //SUPPORT_TIME_H
