/*
 * Copyright (c) 2000,  -
 *
 *         
 * ,     ,    ,  
 *  :
 *
 * 1)       
 *         ,   
 *        .
 *
 * 2)       
 *         ,   
 *           /   ,
 *      .
 *
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 *
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_STRING_H_INCLUDED
#define SUPPORT_STRING_H_INCLUDED

#include "reader/support_base_defs.h"

#ifdef __cplusplus
extern "C" {
#endif //__cplusplus

/*  strdup   . */
#ifndef CSP_LITE
#   ifdef UNICODE
#       define support_tcsdup support_wcsdup
#   else /* UNICODE */
#       define support_tcsdup support_strdup
#   endif /* UNICODE */

static SUP_INLINE CPRO_CHECK_RESULT char *support_strdup(const char *str)
{
    size_t siz = 0;
    char *copy = NULL;
    siz = (strlen(str) + 1) * sizeof(char);
    copy = (char *)malloc(siz);
    if (copy != NULL) {
	memcpy(copy, str, siz);
    }
    return copy;
}

static SUP_INLINE CPRO_CHECK_RESULT wchar_t *support_wcsdup(const wchar_t *str)
{
    size_t siz = 0;
    wchar_t *copy = NULL;
    siz = (wcslen(str) + 1) * sizeof(wchar_t);
    copy = (wchar_t *)malloc(siz);
    if (copy != NULL) {
	memcpy(copy, str, siz);
    }
    return copy;
}
#endif /* CSP_LITE */

#ifdef __cplusplus
}
#endif //__cplusplus

#endif // SUPPORT_STRING_H_INCLUDED
