/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_RESOURCE_H
#define SUPPORT_RESOURCE_H

#include "cpcsp/csp_common.h"

#if defined( __cplusplus )
extern "C" {
#endif /* defined( __cplusplus ) */

#if defined( SUPPORT_RESOURCE_STD )
typedef struct TSupStringTableItem_
{
    size_t num; /*!<  . */
    const wchar_t *string; /*!< . */
} TSupStringTableItem;

/*!      . */
typedef struct TSupVersionItem_
{
    const wchar_t *company; /*!<  . */
    const wchar_t *copyright; /*!< Copyright */
    unsigned int version[4]; /*!<  . */
} TSupVersionItem;

/*!      . */
typedef struct TSupIconTableItem_
{
    int num; /*!<  . */
    const wchar_t *icon_name; /*!<  . */
} TSupIconTableItem;

/*!
 * \brief resource    
 */
#if defined(UNIX) && !defined(CSP_LITE)
typedef void (*TSupOnceFunc)(void);
typedef struct TSupInstanceCatalog_
{
    TSupportOnce once_control;
    const TSupOnceFunc once_func;
    pthread_mutex_t lock;
    nl_catd nl_id;
} TSupInstanceCatalog;
#endif
typedef struct TSupInstanceResourceDecl_
{
#if defined(UNIX) && !defined(CSP_LITE) && defined(USE_NLCAT)
    TSupInstanceCatalog *catalog;
#else
    int string_table_max; /*!<   . */
    const TSupStringTableItem *string_table; /*!<  string table. */
#endif
    const TSupVersionItem *version; /*!<     . */
    int icon_table_max; /*!<   . */
    const TSupIconTableItem *icon_table; /*!<   . */
} TSupInstanceResourceDecl;

/*!
 * \brief instance    
 */
typedef const TSupInstanceResourceDecl *TSupResourceInstance;
#else
/*!
 * \brief instance    DLL instance.
 */
typedef HINSTANCE TSupResourceInstance;
#endif /* !defined( SUPPORT_RESOURCE_STD ) */

#if defined _WIN32 && !defined CSP_LITE
typedef HICON TSupIconHandle;
typedef HBITMAP TSupBitMap;
#else
typedef void *TSupIconHandle;
typedef void *TSupBitMap;
#endif /* _WIN32 && !CSP_LITE */

typedef struct 
{
    DWORD width;	/*  */
    DWORD height;       /*  */
    DWORD priority;	/* ,        */
    TSupIconHandle icon; /*  */
} TSupIconItem;

#define TSUP_ICON_TYPE_SHARED	0 /*    */
#define TSUP_ICON_TYPE_MANY	1 /*     */

typedef struct
{
    DWORD count;	    /*   */
    TSupIconItem *icons;   /*     */
    DWORD icon_type;	    /*  , TSUP_ICON_TYPE_SHARED  TSUP_ICON_TYPE_MANY */
} StTSupIcon, *TSupIcon;

/*     -. */
DWORD support_resource_string(TSupResourceInstance instance, size_t ids, TCHAR *dest, size_t *length) CPRO_CHECK_RESULT;

/*        -. */
DWORD support_resource_string_local(TSupResourceInstance instance, WORD language, size_t ids, TCHAR *dest, size_t *length) CPRO_CHECK_RESULT;

/*! \ingroup group_resource
 *      -.
 */
DWORD support_resource_company(
    TSupResourceInstance instance, /*+ (i)  Windows Dll - instance,   . +*/
    TCHAR *dest, /*+ (io)    NULL   . +*/
    size_t *length
    ) CPRO_CHECK_RESULT;

/*        VersionInfo */
DWORD support_resource_version_string(const TCHAR *target, TSupResourceInstance instance, TCHAR *dest, size_t *length) CPRO_CHECK_RESULT;

DWORD support_icon_free(TSupIcon bitmap);

#define SUP_ICON_PRIORITY_FLAG_COLOR 0xf00
#define SUP_ICON_PRIORITY_1	     1
#define SUP_ICON_PRIORITY_2	     2
#define SUP_ICON_PRIORITY_4	     4
#define SUP_ICON_PRIORITY_8	     8
#define SUP_ICON_PRIORITY_16	     16
#define SUP_ICON_PRIORITY_24	     24
#define SUP_ICON_PRIORITY_32	     32

static SUP_INLINE CPRO_CHECK_RESULT TSupIconHandle support_get_best_icon_handle(TSupIcon icon, DWORD width, DWORD height, DWORD priority)
{
    DWORD i;
    TSupIconItem *pret = NULL;
    if (icon == NULL) return NULL;
    for (i = 0; i < icon->count - 1; i++) {
	if (icon->icons[i].width == width && icon->icons[i].height == height) {
	    if (priority >= icon->icons[i].priority && (pret == NULL || pret->priority < icon->icons[i].priority))
		pret = &icon->icons[i];
	}
    }
    if (pret == NULL)
	return NULL;
    return pret->icon;
}
DWORD support_get_icon_handle(TSupIcon icon, TSupIconHandle *dest) CPRO_CHECK_RESULT;

DWORD support_net_2_icon(void *hwnd, LPBYTE pb_data, DWORD dw_size, TSupIconHandle *result) CPRO_CHECK_RESULT;

DWORD support_icon_2_net(void *hwnd, TSupIconHandle icon, LPBYTE pb_data, DWORD *dw_size) CPRO_CHECK_RESULT;

/*     -. */
DWORD support_resource_bitmap(TSupResourceInstance instance, size_t idi, TSupBitMap *dest) CPRO_CHECK_RESULT;

/*   ERROR_SUCCESS */
DWORD support_bitmap_free(TSupBitMap bitmap) CPRO_CHECK_RESULT;

#if defined( __cplusplus )
}
#endif

#endif // SUPPORT_RESOURCE_H
