/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_LCKREC_H
#define SUPPORT_LCKREC_H

#include "cpcsp/csp_common.h"
#include "reader/support_base_defs.h"

#if defined( __cplusplus )
extern "C" {
#endif //__cplusplus

//
//  / .       
//   C++   .
//

#define SLR_DNTABR	(1)	//    DEBUG     abort(),
				//   .
#define SLR_NORMAL	(0)	//  DEBUG -     abort(), 
				//  ,  .

typedef void(*slr_pfDestruct_t)(void *);
//     .

#if !defined(CSP_LITE) && defined UNIX && (SECURITY_LEVEL > KC1)
#define ENABLE_SLR_STACK
#endif

//   .
void  support_lckrec_push_slr_impl(void *pvLock, slr_pfDestruct_t pfUnlock);
//   .
void  support_lckrec_pop_slr_impl(void *pvLock);
// ,     
//   uBottom .
DWORD support_lckrec_check_slr_impl(unsigned uDntAbr, unsigned uBottom) CPRO_CHECK_RESULT;
//      uBottom .
DWORD support_lckrec_flush_slr_impl(unsigned uDntAbr, unsigned uBottom) CPRO_CHECK_RESULT;
//      .
unsigned support_lckrec_top_slr_impl(void) CPRO_CHECK_RESULT;

#if defined (ENABLE_SLR_STACK)
#define support_lckrec_push(pvLock, pfUnlock) \
	support_lckrec_push_slr_impl((pvLock), (pfUnlock))
#define support_lckrec_pop(pvLock) \
	support_lckrec_pop_slr_impl((pvLock))
#define support_lckrec_check(uDntAbr, uBottom) \
	support_lckrec_check_slr_impl((uDntAbr), (uBottom))
#define support_lckrec_flush(uDntAbr, uBottom) \
	support_lckrec_flush_slr_impl((uDntAbr), (uBottom))
#define support_lckrec_top() \
	support_lckrec_top_slr_impl()
#else
static SUP_INLINE void support_lckrec_push(void *pvLock, slr_pfDestruct_t pfUnlock)
{
    UNUSED(pvLock);
    UNUSED(pfUnlock);
}

static SUP_INLINE void support_lckrec_pop(void *pvLock)
{
    UNUSED(pvLock);
}

static SUP_INLINE DWORD support_lckrec_check(unsigned uDntAbr, unsigned uBottom)
{
    UNUSED(uDntAbr);
    UNUSED(uBottom);
    return (DWORD)ERROR_SUCCESS;
}

static SUP_INLINE DWORD support_lckrec_flush(unsigned uDntAbr, unsigned uBottom)
{
    UNUSED(uDntAbr);
    UNUSED(uBottom);
    return (DWORD)ERROR_SUCCESS;
}

static SUP_INLINE unsigned  support_lckrec_top(void)
{
    return 0;
}
#endif // ENABLE_SLR_STACK

//     
#if defined(DEBUG) || defined(_DEBUG)
#define SLR_DEBUG_CHECK_TOP(uT) unsigned (uT) = support_lckrec_top()
#define SLR_DEBUG_CHECK(uT)     (support_lckrec_check(SLR_NORMAL, (uT)))
#else
#define SLR_DEBUG_CHECK_TOP(uT) unsigned (uT)
#define SLR_DEBUG_CHECK(uT)     ((void)(uT))
#endif

#if defined( __cplusplus )
}
#endif //__cplusplus

#endif // SUPPORT_LCKREC_H
