/*
 * Copyright (c) 2000,  -
 *
 *         
 * ,     ,    ,  
 *  :
 *
 * 1)       
 *         ,   
 *        .
 *
 * 2)       
 *         ,   
 *           /   ,
 *      .
 *
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 *
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SECURE_MEMORY_H
#define SECURE_MEMORY_H


#if defined(__GNUC__) || defined(__clang__)
#define CPRO_COMPILER_MEMORY_BARRIER asm volatile ("" ::: "memory")
#elif defined(_MSC_VER)
#ifdef __cplusplus
extern "C"
#endif
void _ReadWriteBarrier(void);
#pragma intrinsic(_ReadWriteBarrier)
#define CPRO_COMPILER_MEMORY_BARRIER _ReadWriteBarrier()
#else
#define CPRO_COMPILER_MEMORY_BARRIER
#endif


#ifdef __cplusplus
#define CPRO_PREVENT_CXX_NAMESPACE_MAGIC ::
#else
#define CPRO_PREVENT_CXX_NAMESPACE_MAGIC
#endif

#ifdef __cplusplus
extern "C" {
#endif
typedef void *memset_t(void *, int, size_t);
#ifdef __cplusplus
}
#endif

#ifdef CPRO_SECURE_MEMSET
#error "Include cpcsp/secure_memory.h correctly and don't redefine CPRO_SECURE_MEMSET"
#endif

#define CPRO_SECURE_MEMSET(p, c, n) \
    do { \
        CPRO_COMPILER_MEMORY_BARRIER; \
        memset_t * volatile memset_p = CPRO_PREVENT_CXX_NAMESPACE_MAGIC memset; \
        memset_p((p), (c), (n)); \
        CPRO_COMPILER_MEMORY_BARRIER; \
    } while(0)


#ifdef CPRO_SECURE_ZERO_MEMORY
#error "Include cpcsp/secure_memory.h correctly and don't redefine CPRO_SECURE_ZERO_MEMORY"
#endif

#define CPRO_SECURE_ZERO_MEMORY(p, n) CPRO_SECURE_MEMSET(p, 0, n)


#endif
