#ifndef DRVTST_SUPPORT_LINUX_H
#define DRVTST_SUPPORT_LINUX_H
#include<linux/sched.h>
#   if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,24)
static inline pid_t task_pid_nr(struct task_struct *tsk)
{
    return tsk->pid;
}
static inline pid_t task_tgid_nr(struct task_struct *tsk)
{
    return tsk->tgid;
}
static inline pid_t task_pid_vnr(struct task_struct *tsk)
{
    return (pid_t)(-1);// unsupported
}
#endif
static inline void 
print_statistics(const char *prompt)
{
  printk(KERN_ALERT ": " MODNAME ": %s PID=%d, VID=%d, name=%s, group=%d\n", 
    prompt, 
    (int) task_pid_nr(current),
    (int) task_pid_vnr(current),
    current->comm,
    (int) task_tgid_nr(current));  
}

#endif
