/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#if !defined _COMPILER_ATTRIBUTES_H_
#define _COMPILER_ATTRIBUTES_H_

#if !defined __GNUC__
#   define ATTR_NOASAN
#   define ATTR_NOTSAN
#   define ATTR_NORETURN
#   define ATTR_USERES
#if defined _WIN32
#   define CP_FORCE_INLINE __inline
#else
#   define CP_FORCE_INLINE inline
#endif	/* _WIN32 */
#else

/* CPCSP-8892 dim: gcc-4.8  ,     */
#if !((__GNUC__ == 4 && __GNUC_MINOR__ >= 8) || __GNUC__ >= 5)
#   define ATTR_NOASAN
#   define ATTR_NOTSAN
#   define ATTR_NORETURN
#   define ATTR_USERES
#   define CP_FORCE_INLINE inline
#else

/*   mem*()  str*()    -fsanitize=address */
#if defined __SANITIZE_ADDRESS__
# define ATTR_NOASAN __attribute__((no_sanitize_address))
#else
# define ATTR_NOASAN
#endif	/* __SANITIZE_ADDRESS__ */

/*    ,      */
#if defined __SANITIZE_THREAD__
# define ATTR_NOTSAN __attribute__((no_sanitize_thread))
#else
# define ATTR_NOTSAN
#endif	/* __SANITIZE_THREAD__ */

#   define ATTR_NORETURN     __attribute__((noreturn))

/*    support_base_defs.h  CSP_WinDef.h */
#   define ATTR_USERES       __attribute__((warn_unused_result))

#   define CP_FORCE_INLINE   inline __attribute__ ((__always_inline__))
#endif	/*   gcc */
#endif	/*  gcc */

/* CPCSP-11164 */
#if defined(__IBMC__) || defined(__IBMCPP__) || defined(__GNUC__)
#   define DLL_LOCAL  __attribute__((visibility("hidden")))
#   define DLL_PUBLIC __attribute__((visibility("default")))
#elif defined(__SUNPRO_C) || defined(__SUNPRO_CC)
#   define DLL_LOCAL __hidden
#   define DLL_PUBLIC __symbolic
#elif defined(_WIN32)
#   define DLL_LOCAL
#   define DLL_PUBLIC __declspec(dllexport)
#else
#   define DLL_LOCAL
#   define DLL_PUBLIC
#endif

#endif	/* _COMPILER_ATTRIBUTES_H_ */
