/*
 * Copyright(C) 2009  
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 290584 $
 * \date $Date:: 2025-04-16 22:00:14 +0300#$
 * \author $Author: ivan $
 *
 * \brief   RPC (MS RPC  Wire RPC)
 */

#ifndef CSP_RPC_limits_h_
#define CSP_RPC_limits_h_

#ifndef CSP_UIO_MAXIOV
    #define CSP_UIO_MAXIOV  (1024-16)    // TODO:  
#elif CSP_UIO_MAXIOV < (16-2)
    // TODO:XX C++     CSP_UIO_MAXIOV == IOV_MAX
    //#error CSP_UIO_MAXIOV < (16-2)
#endif

	    //    CSP  MS RPC   ncalrpc 
	    // ( )
#if defined(CP_MSRPC_DEBUG)
#   define CPTransportRpcMem		(8*1024*1024)
#else
#   define CPTransportRpcMem		(512*1024*1024)
#endif

//////////////////////////////////////////////////////////////////////////
	    //  / 
	    //   Encrypt()/Decrypt()
            // TODO:  RSA     
#define CPEncDecMinBlkLen		(2048)

//////////////////////////////////////////////////////////////////////////
	    //     MS ncalrpc
#define CPSrvMSlrTransportMaxBlkLen	(CPTransportRpcMem/4)
	    //     Wire
#ifdef __cplusplus
extern "C" {
#endif
DWORD GetRPCBasicBlkLen();
#ifdef __cplusplus
}
#endif
#define CPSrvWireTransportMaxBlkLen	GetRPCBasicBlkLen()
#define CPSrvKchnTransportMaxBlkLen	(2*32*1024) 

	    //   IOvec
#define CPSrvMSlrTransportMaxIOVbuf	(CPSrvMSlrTransportMaxBlkLen/4)
#define CPSrvWireTransportMaxIOVbuf	(CPSrvWireTransportMaxBlkLen)
//#define CPSrvKchnTransportMaxIOVbuf	(CPSrvKchnTransportMaxBlkLen)
#define CPSrvTransportMaxIOVcnt		(CSP_UIO_MAXIOV*3/2)

	    //  
#define CPSrvTransportMaxStrLen		(15*1024)

	    //  -  
#define CPSrvTransportMaxParts		(20) 

//////////////////////////////////////////////////////////////////////////
	    //     MS ncalrpc
#define CPClnMSlrTransportOptBlkLen	(sizeof(void *)*32*1024) 
	    //    Wire (XTODO)
#define CPClnWireTransportOptBlkLen	(32*1024 - 2*CPEncDecMinBlkLen)
#define CPClnKchnTransportOptBlkLen	(16*1024 - 2*CPEncDecMinBlkLen)

	    //       
	    //   
#define CPClnMSlrTransportMaxBlkLen	(2*CPSrvMSlrTransportMaxBlkLen) 
#define CPClnWireTransportMaxBlkLen	(2*CPSrvWireTransportMaxBlkLen) 
#define CPClnKchnTransportMaxBlkLen	(2*CPSrvKchnTransportMaxBlkLen) 
//#define CPClnMSlrTransportMaxIOVbuf	(2*CPSrvMSlrTransportMaxIOVbuf)
#define CPClnWireTransportMaxIOVbuf	(2*CPSrvWireTransportMaxIOVbuf)
//#define CPClnKchnTransportMaxIOVbuf	(2*CPSrvKchnTransportMaxIOVbuf)
#define CPClnTransportMaxIOVcnt		(2*CPSrvTransportMaxIOVcnt)
#define CPClnTransportMaxStrLen		(2*CPSrvTransportMaxStrLen)
#define CPClnTransportMaxParts		(2*CPSrvTransportMaxParts) 

#endif /* CSP_RPC_limits_h_ */
/* $Id: CSP_RPC_limits.h 290584 2025-04-16 19:00:14Z ivan $ */

