/*
 * Copyright(C) 2003  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 278922 $
 * \date $Date:: 2024-10-08 17:27:46 +0300#$
 * \author $Author: ivan $
 *
 * \brief       .
 */

#ifndef __CHAIN_UTIL_H
#define __CHAIN_UTIL_H

#include <set>
#include <string>

#define CP_REVOCATION_CHECK_MASK (CERT_CHAIN_REVOCATION_CHECK_END_CERT | CERT_CHAIN_REVOCATION_CHECK_CHAIN | CERT_CHAIN_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT)

typedef std::basic_string<TCHAR> tstring;

class TrustStatus
{
public:
    // , ,  
    explicit TrustStatus() : value( 0 ) {}
    TrustStatus( unsigned src ) : value( src ) {}

    //   
    unsigned get_unsigned() const { return value; }

    //  CryptoAPI- 
    DWORD toCERT_TRUST_STATUS() const { return value; }
    DWORD toRevocationResult() const;

    // 
    int compare( const TrustStatus &right ) const;

    //   
    std::string toString() const;
    tstring toTstring() const;
    static TrustStatus fromString( const char *str );

    //    
    static const unsigned VALUES[];
    static const char *STRINGS_A[];
    static const size_t VALUE_LENGTH;

private:
    int compare( const TrustStatus &src, unsigned flag ) const;
    unsigned value;
};

//   
inline bool operator== ( const TrustStatus &left, const TrustStatus &right )
{ return left.compare( right ) == 0; }

inline bool operator!= ( const TrustStatus &left, const TrustStatus &right )
{ return left.compare( right ) != 0; }

//   ,     
inline bool operator> ( const TrustStatus &left, const TrustStatus &right )
{ return left.compare( right ) > 0; }

//   
class CertChainBuilder;

//     
//  :
// -  : 
// - CRL store: CA, Root
// - Store: CA
// - Root store: Root
// -  . crl , Trust: 
// - Policy: POLICY_ANY
// -  : CERT_CHAIN_REVOCATION_CHECK_CHAIN
class CertCC // CertChainContext
{
public:
    // , , 
    CertCC( bool add_root = true, bool extra_crl_stores = true,
	bool extra_cert_stores = true );
    ~CertCC();

    //  
    void set_usage( PCERT_USAGE_MATCH RequestedUsage );
    void set_date( const FILETIME& date );

    void set_flags( unsigned f );
    //       dwFlags
    // CertGetCertificateChain  CERT_CHAIN_ENGINE_CONFIG
    void set_common_flags(unsigned f);
    void set_blacklist_store( HCERTSTORE hStore );
    void set_trusted_store( HCERTSTORE hStore );
    void set_additional_store(HCERTSTORE hStore);
    void set_timeout( unsigned long time_value);
    void set_cache_resync(LPFILETIME value);

    void add_stores( const wchar_t *store, bool issystem = false );
    void add_stores( const store_handle& handle );
    void add_crl_stores( const wchar_t *store, bool issystem = false );
    void add_crl_stores( const store_handle& handle );
    void add_chain_engine(const HCERTCHAINENGINE hEngine);

    //    
    void clear_stores();
    void clear_crl_stores();

    //   

    unsigned get_flags( void ) const;
    bool is_blacklisted( PCCERT_CONTEXT ctx ) const;

    //  
    bool verify_certificate(PCCERT_CONTEXT p);

    //   
    TrustStatus get_status() const;

    BOOL toCERT_CHAIN_CONTEXT(PCERT_CHAIN_CONTEXT*);

protected:
    CertChainBuilder *builder;

private:
    //     
    CertCC &operator=(const CertCC &);
    CertCC(const CertCC&);
};

// 2022-apr-01 dim:   CertCC::toCERT_CHAIN_CONTEXT()   CertGetCertificateChain()
// --   
// --  ref_counter, cbSize
static inline PCERT_CHAIN_CONTEXT newChainCtx()
{
    PCERT_CHAIN_CONTEXT p = (PCERT_CHAIN_CONTEXT) ::calloc(sizeof (CERT_CHAIN_CONTEXT) + sizeof(DWORD), 1); // hack for ref_counter
    if (!p) {
	::SetLastError(ERROR_NOT_ENOUGH_MEMORY);
	return NULL;
    }
    //    CERT_CHAIN_CONTEXT   ref_counter
    const DWORD ref_counter = 1;
    ::memcpy(p+1, &ref_counter, sizeof(DWORD));
    p->cbSize = sizeof (CERT_CHAIN_CONTEXT);
    //    
    return p;
}
#endif // __CHAIN_UTIL_H
