/*
 * Copyright (C) 1997-2003 by Objective Systems, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by Objective Systems, Inc.
 *
 * PROPRIETARY NOTICE
 *
 * This software is an unpublished work subject to a confidentiality agreement
 * and is protected by copyright and trade secret law.  Unauthorized copying,
 * redistribution or other use of this work is prohibited.
 *
 * The above notice of copyright on this source code product does not indicate
 * any actual or intended publication of such source code.
 *
 *****************************************************************************/


/**
 * @file rtPrintToString.h
 */
#ifndef _RTPRINTTOSTRING_H_
#define _RTPRINTTOSTRING_H_
#include <stdio.h>
#include "asn1type.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @defgroup rtPrintToString<type> 
 * Format the output value to string in a "name = value" format. The value
 * format is obtained by calling one of the "ToString" functions with the given
 * value.
 *
 * @{
 */
/**
 * @param name         The name of the variable to print.
 * @param value        ASN.1 value to print (Note: multiple arguments may be
 *                       used to represent the value- for example a bit string
 *                       would be represented by a numbits and data argument.
 *                       See the function prototype forthe exact calling
 *                       sequence).
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringBoolean (ASN1ConstCharPtr name, ASN1BOOL value,
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param value        ASN.1 value to print (Note: multiple arguments may be
 *                       used to represent the value- for example a bit string
 *                       would be represented by a numbits and data argument.
 *                       See the function prototype forthe exact calling
 *                       sequence).
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringInteger (ASN1ConstCharPtr name, ASN1INT value, 
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param value        ASN.1 value to print (Note: multiple arguments may be
 *                       used to represent the value- for example a bit string
 *                       would be represented by a numbits and data argument.
 *                       See the function prototype forthe exact calling
 *                       sequence).
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringInt64 (ASN1ConstCharPtr name, ASN1INT64 value, 
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param value        ASN.1 value to print (Note: multiple arguments may be
 *                       used to represent the value- for example a bit string
 *                       would be represented by a numbits and data argument.
 *                       See the function prototype for the exact calling
 *                       sequence).
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringUnsigned (ASN1ConstCharPtr name, ASN1UINT value, 
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param value        ASN.1 value to print (Note: multiple arguments may be
 *                       used to represent the value- for example a bit string
 *                       would be represented by a numbits and data argument.
 *                       See the function prototype for the exact calling
 *                       sequence).
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringUInt64 (ASN1ConstCharPtr name, ASN1UINT64 value, 
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param numbits      The number of bits to be printed.
 * @param data         A pointer to the data to be printed.
 * @param conn         A pointer to the connector between the name and the
 *                       value. This points to either -> or .
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringBitStr (ASN1ConstCharPtr name, 
   ASN1UINT numbits, ASN1ConstOctetPtr data, ASN1ConstCharPtr conn, 
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param numocts      The number of octets to be printed.
 * @param data         A pointer to the data to be printed.
 * @param conn         A pointer to the connector between the name and the
 *                       value. This points to either -> or .
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringOctStr (ASN1ConstCharPtr name, 
   ASN1UINT numocts, ASN1ConstOctetPtr data, ASN1ConstCharPtr conn, 
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param cstring      A pointer to the character string to be printed.
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringCharStr (ASN1ConstCharPtr name, 
   ASN1ConstCharPtr cstring, char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param bstring      A pointer to a 16-bit string to print.
 * @param conn         A pointer to the connector between the name and the
 *                       value. This points to either -> or .
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToString16BitCharStr (ASN1ConstCharPtr name, 
   Asn116BitCharString* bstring, ASN1ConstCharPtr conn, 
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param bstring      A pointer to a 32-bit string to print.
 * @param conn         A pointer to the connector between the name and the
 *                       value. This points to either -> or .
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToString32BitCharStr (ASN1ConstCharPtr name, 
   Asn132BitCharString* bstring, ASN1ConstCharPtr conn,
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param value        ASN.1 value to print (Note: multiple arguments may be
 *                       used to represent the value- for example a bit string
 *                       would be represented by a numbits and data argument.
 *                       See the function prototype forthe exact calling
 *                       sequence).
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringReal (ASN1ConstCharPtr name, ASN1REAL value,
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param pOID         A pointer to a OID to be printed.
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringOID (ASN1ConstCharPtr name, ASN1OBJID* pOID,
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param pOID         A pointer to a OID to be printed.
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringOID64 (ASN1ConstCharPtr name, ASN1OID64* pOID,
   char* buffer, int bufferSize);

/**
 * @param bufferIndex  The index to the buffer.
 * @param pOID         A pointer to a OID to be printed.
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringOIDValue (ASN1OBJID* pOID, 
   char* buffer, int bufferIndex, int bufferSize);

/**
 * @param bufferIndex  The index to the buffer.
 * @param pOID         A pointer to a OID to be printed.
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringOID64Value (ASN1OID64* pOID, 
   char* buffer, int bufferIndex, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param numocts      The number of octets to be printed.
 * @param data         A pointer to the data to be printed.
 * @param conn         A pointer to the connector between the name and the
 *                       value. This points to either -> or .
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringOpenType (ASN1ConstCharPtr name, 
   ASN1UINT numocts, ASN1ConstOctetPtr data, ASN1ConstCharPtr  conn,
   char* buffer, int bufferSize);

/**
 * @param name         The name of the variable to print.
 * @param pElemList    A pointer to the element to be printed.
 * @param bufferSize   The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToStringOpenTypeExt (ASN1ConstCharPtr name, 
   Asn1RTDList* pElemList, char* buffer, int bufferSize);

/**
 * @param namebuf      A pointer to the buffer name.
 * @param bufSize      The size of the buffer to receive the printed value.
 * @param buffer       Pointer to a buffer to receive the printed value.
 */
EXTERNRT int rtPrintToString (ASN1ConstCharPtr namebuf, 
   char* buffer, int bufSize); 

/**
 * @}
 */
#ifdef __cplusplus
}
#endif
#endif 
