/*
 * Copyright(C) 2003  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile: CA_CMP_Requests.h,v $
 * \version $Revision: 1.24 $
 * \date $Date: 2005/01/24 12:36:43 $
 * \author $Author: cav $
 *
 * \brief RequestInfo class
 */

#ifndef CA_CMP_REQUESTS_H
#define CA_CMP_REQUESTS_H

#define CPCSP_C_SOURCE 30
#include "CA_CMP_Types.h"
#include "CA_CMP_Msg.h"

/**************************************************************/
/*                                                            */
/*  Internal structure                                        */
/*                                                            */
/**************************************************************/

enum RequestTypeEnum {
	REQUEST_TYPE_ALL = -1, //  
	REQUEST_TYPE_GET_CERTIFICATE = 0, //  
	REQUEST_TYPE_REVOKE_CERTIFICATE = 1, //  
	REQUEST_TYPE_GET_CRL = 2, //  
	REQUEST_TYPE_INITIAL_REQUEST = 3, //   
	REQUEST_TYPE_CROSS = 4, //  cross
	REQUEST_TYPE_CONFIRM = 5,   //   
	REQUEST_TYPE_UPDATE_KEY = 6, //    
	REQUEST_TYPE_SUSPEND_CERTIFICATE = 7, //  
	REQUEST_TYPE_RESUME_CERTIFICATE = 8, //  
	REQUEST_TYPE_GEN_MSG_CONTENT = 9, //  
	REQUEST_TYPE_CHANGE_NAME = 10 //  
};

enum RequestStatusEnum {
	REQUEST_STATUS_ALL = -1,        //  
	REQUEST_STATUS_ENTERED = 0,     // 
	REQUEST_STATUS_PENDING = 1,     // 
	REQUEST_STATUS_DECLINED = 2,    // 
	REQUEST_STATUS_ACCEPTED = 3,    // 
	REQUEST_STATUS_PROCESSED = 4,   // 
	REQUEST_STATUS_COMPLETED = 5    // 
};

struct ReasonFlags
{
    static const unsigned unused;
    static const unsigned keyCompromise;
    static const unsigned caCompromise;
    static const unsigned affiliationChanged;
    static const unsigned superseded;
    static const unsigned cessationOfOperation;
    static const unsigned certificateHold;

    //  .
    static const unsigned sequence[7];

    static std::string toString( int );
    static int fromString( const char* );
};

class RequestInfo : public PKIXCMP_Message
{
public:
	RequestInfo();
	RequestInfo( const RequestInfo& r ):PKIXCMP_Message()
	{
	    *this = r;
	}

	~RequestInfo() {}

	RequestInfo& operator=( const RequestInfo& r );

	void clear();

	//  
	int RequestID;

	//  -	ASN1T_CertificationRequest
	CACMPT_BLOB RawRequest;

	//   
	CACMPT_Date messageTime;

	// ASN1T_CertificationRequest.ASN1T_CertificationRequest_certificationRequestInfo.ASN1T_Name subject
	CACMPT_PARSED_RDN subjectRDN;

	//    ( ChangeNameReq)
	CACMPT_PARSED_RDN oldSubjectRDN;
	
	// ASN1T_CertificationRequest.ASN1T_CertificationRequest_certificationRequestInfo.ASN1T_CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo
        CACMPT_PublicKeyInfo	SubjectPublicKey;

	// extensions
	CACMPT_Extensions Extensions;

	// 
	char RequestAttributes[ 32768 ];

	//  -		ASN1T_CertificationRequest.ASN1T_AlgorithmIdentifier signatureAlgorithm;
	char RequestSignatureAlgorithm[ 254 ];

	//  - 	ASN1T_CertificationRequest.ASN1TDynBitStr signature;
	CACMPT_BLOB RequestSignature;

	//    

	//  -	ASN1T_Certificate
	CACMPT_BLOB RawOldCertificate;

	//  -		ASN1T_Certificate.ASN1T_TBSCertificate.ASN1T_CertificateSerialNumber serialNumber
	CACMPT_SERIAL OldCertificateSerialNumber;

	// enum RequestTypeEnum
	int RequestType;

	// enum RequestStatusEnum
	int Status;

	//  
	int Disposition;

	//    
	char DispositionMessage[ 8192 ];

	//   
	CACMPT_Date ResolvedWhen;

	//  
	CACMPT_Date RevokedWhen;

	//    
	CACMPT_Date RevokedEffectiveWhen;

	//  
	int RevokedReason;

	//  
	CACMPT_SERIAL SerialNumber;

	//   ,   Subject (  ASN1T_Name.ASN1T_RDNSequence)

	// ASN1T_ChangeNameReq.keyPhrase
	FreeText keyPhrase;

	// ASN1T_ChangeNameReq.additionalInfo
	FreeText additionalInfo;

	// 
	PKIStatusEnum pki_status;

	FreeText status_string;

	FailureInfo failure_info;

	// 
	char DeviceSerialNumber[ 256 ];
};
#endif /* CA_CMP_REQUESTS_H */
