#ifndef _LOAD_SCARD_INTERNAL_H_INCLUDED
#define _LOAD_SCARD_INTERNAL_H_INCLUDED

#ifndef UNIX
typedef DWORD PCSC_DWORD, *LPPCSC_DWORD;
#endif //UNIX

#ifdef _WIN32
#include <Winscard.h>
#else // !_WIN32
#include "reader/support.h"
#include "CSP_WinSCard.h"
#define LPSCARD_READERSTATEA LPSCARD_READERSTATE
#define SCARD_READERSTATEA SCARD_READERSTATE
#endif // _WIN32

#include "CPPCadesUECard.h"

using CryptoPro::PKI::CAdES::CPPCadesUECardThreadObject;

class SCardEventSource
{
public:
    SCardEventSource();
    ~SCardEventSource();

    HRESULT Initialize(CPPCadesUECardThreadObject& card);

    HRESULT WaitCardRemoved();
    HRESULT WaitTokenInserted();
private:
    bool m_bLibraryInitialized;
    CPPCadesUECardThreadObject m_cardInternal;
    SCARDCONTEXT m_hContext;

#ifndef IOS 
#ifdef _WIN32
    typedef HMODULE IntModuleHandle;
#else //!_WIN32
    typedef TSupModuleInstance IntModuleHandle;
#endif //_WIN32

    IntModuleHandle m_hScardLib;

    //     Winscard/pcsclite.so
    HRESULT LoadScardLibrary();
    void UnLoadScardLibrary();

    template< typename T > 
    bool LoadFunction(T** pFunction, LPCSTR pName);

    typedef LONG (WINAPI* SCardEstablishContext_ptr)(DWORD dwScope,
        LPCVOID pvReserved1, LPCVOID pvReserved2, LPSCARDCONTEXT phContext);
    typedef LONG (WINAPI* SCardReleaseContext_ptr)(SCARDCONTEXT hContext);
    typedef LONG (WINAPI* SCardGetStatusChange_ptr)(SCARDCONTEXT hContext, 
        DWORD dwTimeout, LPSCARD_READERSTATEA rgReaderStates, DWORD cReaders);
    typedef LONG(WINAPI* SCardListReaders_ptr)(SCARDCONTEXT hContext, 
        LPCSTR mszGroups, LPSTR mszReaders, LPPCSC_DWORD pcchReaders);

    SCardEstablishContext_ptr m_pSCardEstablishContext;
    SCardReleaseContext_ptr m_pSCardReleaseContext;
    SCardGetStatusChange_ptr m_pSCardGetStatusChange;
    SCardListReaders_ptr m_pSCardListReaders;

#endif //IOS
};

#endif // _LOAD_SCARD_INTERNAL_H_INCLUDED

