#ifndef CPP_ENROLL_PUBLIC_KEY_OBJECT_H_
#define CPP_ENROLL_PUBLIC_KEY_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollObjectId.h"

using namespace ATL;

namespace CryptoPro {
namespace PKI {
namespace Enroll {

//      webEnabled,     .
//      CertEnroll -  .
class CPPEnrollX509PublicKey
{
public:
    CPPEnrollX509PublicKey(void);
    ~CPPEnrollX509PublicKey(void);
    HRESULT InitializeFromDecodedPublicKeyInfo(CStringBlob& decodedPublicKeyInfo);
    HRESULT get_Algorithm(NS_SHARED_PTR::shared_ptr<CPPEnrollObjectId>& pVal);
    HRESULT get_EncodedKey(/*EncodingType Encoding, */CStringBlob& pValue);
    // internal only
    HRESULT get_KeyIdentifier(/*KeyIdentifierHashAlgorithm Algorithm,
        EncodingType Encoding, */CStringBlob& pValue);
    PCERT_PUBLIC_KEY_INFO getPublicKeyInfo();
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509PublicKey);
    CStringBlob m_decodedPublicKeyInfo;
    PCERT_PUBLIC_KEY_INFO m_pInfo;
    NS_SHARED_PTR::shared_ptr<CPPEnrollObjectId> m_pAlgorithm;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_PUBLIC_KEY_OBJECT_H_


