#ifndef CPP_ENROLL_NAME_VALUE_PAIR_OBJECT_H_
#define CPP_ENROLL_NAME_VALUE_PAIR_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollObjectId.h"
#include "CPPEnrollCollections.h"

using namespace ATL;
namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollObjectIds;
class CPPEnrollCertificatePolicies;

class CPPEnrollX509NameValuePair
{
public:
    CPPEnrollX509NameValuePair(void);
    ~CPPEnrollX509NameValuePair(void);
    HRESULT Initialize(
        CAtlString& strName,
        CAtlString& strValue);
    HRESULT get_Name(CAtlString& pVal);
    HRESULT get_Value(CAtlString& pVal);

protected:
    CStringBlob m_name;
    CStringBlob m_value;
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509NameValuePair);
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_NAME_VALUE_PAIR_OBJECT_H_
