#ifndef CPP_ENROLL_CONTAINER_KEY_OBJECT_H_
#define CPP_ENROLL_CONTAINER_KEY_OBJECT_H_

#include "cppcades.h"
#include <atlcrypt2.h>
#include "CPPCadesCPCertificate.h"

using namespace ATL;
using namespace CryptoPro::PKI::CAdES;

namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollContainerKey
{
public:
    CPPEnrollContainerKey(void);
    ~CPPEnrollContainerKey(void);
    HRESULT get_HasCertificate(BOOL& Val);
    HRESULT get_Certificate(NS_SHARED_PTR::shared_ptr<CPPCadesCPCertificateObject>& pVal);
    HRESULT get_IsExportable(BOOL& Val);
    HRESULT get_Type(DWORD& Val);
    HRESULT get_ExpirationTime(CryptoPro::CDateTime& value);
    HRESULT get_PublicKey(NS_SHARED_PTR::shared_ptr<CPPCadesCPPublicKeyObject>& pVal);
    HRESULT get_KP_FP(CAtlString& value);
    HRESULT get_KP_ALGID(DWORD& value);

    //internal use
    HRESULT Initialize(HCRYPTPROV hProv, HCRYPTKEY hKey, DWORD dwKeyType);
    void CheckInitialized();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollContainerKey);
    CCryptProvEx m_hProv;
    CCryptUserExKey m_hKey;
    DWORD m_dwKeyType;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPPublicKeyObject> m_pPublicKey;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_CONTAINER_KEY_OBJECT_H_
